#include <stdio.h>

#define FIRSTROW 0

#define MATSIZ 24
float mat[MATSIZ][MATSIZ];

#define BUFSIZ 64
char buf[BUFSIZ];
char *prog;

int matrow=0, matcol=0;

main(argc,argv)
int argc;
char *argv[];
{

	prog = argv[0];
	getdata(mat);
	mkproportion(mat);
	mktable(mat);
}

getdata(mat)
float mat[MATSIZ][MATSIZ];
{

	register int prevcol;
	int strcmp(), sscanf(), fscanf();
	float x, sum=0.0;
	char *toosmall = "%s:matrix toosmall";


	while(fscanf(stdin,"%s", buf) != EOF){
		if (!(strcmp(buf,"end")) || !(strcmp(buf, "stop"))){
			mat[matrow][matcol] = sum;	/* sto sum */
			if ( matrow++ != FIRSTROW && prevcol != matcol )
				err("%s:unequal matrix-row count",prog);
			if (matrow >= MATSIZ)
				err(toosmall,prog);
			if (buf[0] == 's')
				return;
			prevcol = matcol;
			matcol = 0;
			sum = 0.0;
		}
		else {
			if(sscanf(buf,"%f", &x) != 1)
				err("%s:bad conversion", prog);
			sum += x;
			mat[matrow][matcol++] = x;
			if (matcol >= MATSIZ)
				err(toosmall, prog);

		}
	}
}



debugdump(mat)
float mat[MATSIZ][MATSIZ];
{
	register int i,j; 
	int max = matcol+1;

	for(i=0; i < matrow; i++) {
		for(j=0; j < max; j++)
			printf("%f ", mat[i][j]);
		printf("\n");
	}
}

mkproportion(mat)
float mat[MATSIZ][MATSIZ];
{ 
	register float *col, *colsum;
	register int i;

	for(i=0; i < matrow; i++) {
		colsum = &mat[i][matcol];
		for(col=mat[i]; col != colsum; col++)
			*col /= *colsum;
	}
}


mktable(mat)
float mat[MATSIZ][MATSIZ];
{ 
	register float *col, *colsum, *nextcol;
	int row, k, tabpos;
	float sum;
	double fabs();

	fprintf(stdout,"column ");		/* print header */
	for(row=2; row <= matrow; row++)
		fprintf(stdout, "\t%2d", row);
	fprintf(stdout,"\n");

	for(row=0; row < matrow-1; row++) {
		fprintf(stdout,"%2d....\t", row+1);
		colsum = &mat[row][matcol];
		for(tabpos=0; tabpos < row; tabpos++)
			fprintf(stdout, "\t");
		for(k=row+1; k < matrow; k++){
			sum = 0.0;
			for(col=mat[row], nextcol=mat[k]; col < colsum; col++)
				sum += fabs(*col - *nextcol++);

			fprintf(stdout,"%4.1f\t", 100.0 * (1.0 - (0.5 * sum)));
		}	
		fprintf(stdout,"\n");
	}
}
