#
#include <stdio.h>
#include <ctype.h>

#define true 1
#define false 0

#ifdef DEBUG
char *tstr="\n+\t";
int debug=false;
#define tracef(x) if(debug) {putstr(tstr);printf x;}
#define PAUSE if(debug) putstr(FFSTR)

#else
#define tracef(x)
#define PAUSE
#endif

#define UPONE 1
#define ALLTHEWAY EOF
#define STOP 0
#define FF '\014'
char *FFSTR="\014";

			/* MAXFILES:max number of file that can be opened
				by any one uknow process */
#define MAXFILES 10

#define BSIZ 100
char buf[BSIZ];
#define TSIZ 32

FILE *fp, *fopen(), *fdopen();

char *progname;
char *bp[4];
char *expbp[24];
char *press="\n==>Press return to continue [help or /pattern]: ";
char *whichnumber="Which number [help or /pattern]? ";
char *strsave(), *fgets(), *malloc(), match();
char *nospace="nospace";

char expbuf[BSIZ];
char *exptr="explain";		/* default help (explain) filename */
char *root="root";		/* default root filename */

#define PATHSIZ 64
char oldpath[PATHSIZ];		/* buffer to save users current dir */
char *path="/usr/lib/uknow/general";		/* default path to uknow dir */

int recurseflg, depth=(-1), line;

typedef struct savestr {
	struct savestr *next;
	char *prompt;
	char *action;
} SAVE;


main(argc,argv)
int argc;
char *argv[];
{
	register int i=1;
	setout();

#ifdef DEBUG
	if (*argv[i] == '-') {
		if (*(argv[i] + 1) == 'd')
			debug = true;
		else
			err("bad option %s", argv[i]);
		--argc; i++;
	}
#endif


				/* save the users current dir */
	fp=fdopen(pipein("/bin/sh", "sh", "-c","pwd",0), "r");
	if(!fp)
		err("bad pipein");
	getln(oldpath, PATHSIZ, fp);
	fclose(fp);

	if (argc == 3) {
		path = argv[i];
		root = argv[++i];
	}

	if(chdir(path) == -1)
		err("%s:%s-Bad Path", argv[0], path);
	uknow(root);
}

uknow(file)
char *file;
{
	register char *c;
	register SAVE *tmp=NULL, *head=NULL;
	SAVE *start=NULL;
	int number, reply;
	char *title=NULL;

	ttyclr();
	tracef(("ENTERING UKNOW WITH FILE '%s'\n", file))


	if(++depth > MAXFILES || !(fp=fopen(file,"r"))){
		if (depth > MAXFILES)
			printf("\nToo many open files %d\n", MAXFILES);
		else
			printf("\nSorry can't find file %s\n", file);
		--depth;
		recurseflg = UPONE;
		putstr(FFSTR);
		return;
	}

	for(line=0; getln(buf,BSIZ,fp) != EOF; ++line) {
		if (parse(buf,bp,'|') == 2) {

			if (!(tmp=(SAVE *) malloc(sizeof(SAVE))))
				err(nospace);

			tmp->next=NULL;

			if((tmp->prompt=strsave(bp[0]))
				&& (tmp->action=strsave(bp[1])))
					;
			else
				err(nospace);

			if(head)
				head = head->next = tmp;
			else
				start=head=tmp;
		}
		else {			/* no '|' in line */
			c = buf;
			if (line <= 1) {
				for(; isspace(*c); c++)
					;
				if(*c == '$'){  /* first non blank char a $? */
					tracef(("saving title=%s\n", c));
					if(title)
						free(title);
					if(!(title=strsave(++c)))
						err(nospace);
				}
			}
			putstr(c);
			putc('\n',stdout);
		}
	} /* while !EOF */


again:
	if((reply=getreply(title,start))) {	/* true if numeric response in
						   range of the file prompts */

		for(number=1,tmp=start; number < reply;number++,tmp=tmp->next) {
			;
			tracef(("cmp:rply=%d numbr=%d\n",reply,number))
		}
		tracef(("action found=%s\n", tmp->action))

		PAUSE;

		if(*(tmp->action) == '#') {
			uknow(tmp->action + 1);
			if (recurseflg == UPONE) {	/* either go up 1 */
				ttyclr();		/* level or alltheway */
				goto again;
			}
		}
		else{
			putstr(tmp->action);
			putstr(FFSTR);
			goto again;
		}
	}


	ttyclr();
	if (depth)
		--depth;
	else
		goto again;		/* do not free the root */

	tracef(("freeing data for file=%s at depth=%d\n", file,depth))

	if(title)
		free(title);
	for(head=start; tmp; head=tmp) {		/* free list */
		tmp=head->next;
		free((char *) head);
	}

	fclose(fp);			/* close file */

	PAUSE;
}


int getreply(title,start)	/* given optional title and linked list of 
				   prompts, return a true if number in range
				   of readin prompt count. if not, count+1 or
				   count+2, then run thru explain to resolve */
char *title;
SAVE *start;
{
	register SAVE *tmp=start;
	register int number; 
	int reply;
	char *str;

again:
	if(title && line > 20){
		putstr(title);
		putc('\n',stdout);
	}

	line=999;

	putstr("\n===>\n");
	tracef(("getreply:address of start=%d \t of tmp=%d\n",start,tmp));
	for(number=0; start; start=start->next)
		printf("\t%2d) %s\n", ++number, start->prompt);

			/* internal prompt-go back to top? */
	if (depth) {
		printf("\t%2d)    Go up one level\n", number + 1);
		printf("\t%2d)    Go back to start\n",number + 2);
	}


	putstr(whichnumber);

	fflush(stdout);		/* flush stdout & get reply */
	getln(buf,BSIZ,stdin);

			/* find out what's in the buffer. if it's a
			 * good number, then return it to uknow. if it's
			 * an internally generated number (goto start or
			 * go up one level) do special returns. if none
			 * of the above, then run the buf thru explain to see
			 * if it can be resolved
			 */

	if (sscanf(buf,"%d",&reply) == 1 && reply >= 1) {
		tracef(("reply=%d \t number=%d\n", reply,number))

		if (reply <= number)		/* find posn in linked list */
			return(reply);

		if(++number == reply){		/* go up one stack level */
			tracef(("\tnumber=%d \t recurseflg=UPONE\n",number))
			recurseflg = UPONE;
			return(NULL);
		}

		if(++number == reply) {		/* to back up to top */
			tracef(("\tnumber=%d \trecurseflg=ALLTHEWAY\n",number))
			recurseflg = ALLTHEWAY;
			return(NULL);
		}
	}

	if((explain(buf)))		/* if the pattern was found in the */
		return(NULL);		/* explain file, then return a null, */
					/* else there was an error */
		

	start = tmp;			/* error, reprompt user */
	goto again;
}


putstr(c)
register char *c;
{
	char tmpbuf[TSIZ];

	if (*c == FF){
		putstr(press);
		fflush(stdout);
		if(getln(tmpbuf,TSIZ,stdin))
			explain(tmpbuf);
		ttyclr();
	}

	while(*c)
		putc(*c++,stdout);
}

explain(s)
register char *s;
{

	register int i, nf;
	static FILE *expfile;

	if (*s == 'q' && !*(s+1) || match(s,"stop") )
		exit(0);

	if(*s == '!') {	/* unix command escape */
		char *badpath="Bad Path - '%s'";
		if(chdir(oldpath) == -1)
			err(badpath, oldpath);
		system(++s);
		putstr(FFSTR);

				/* a bad chdir would have occurred in main */
		if(chdir(path) == -1)	
			err(badpath, "");

		return(NULL);
	}

	if(strcmp(s,"help") == 0)	/* help is in the explain file */
		goto gethelp;
		
	if(*s != '/') {		/* sorry folks, i do not understand */
		usrerror(s);
		return(NULL);
	}

	++s;	/* incr ptr to 1 char beyond '/' */
gethelp:
	tracef(("SEARCHING EXPLAIN FILE\n"))
	if (expfile)
		rewind(expfile);
	else
		if(!(expfile=fopen(exptr,"r")))
			return(NULL);

	if(*s)
		while(getln(expbuf,BSIZ,expfile) != EOF){
			tracef(("explainfile=%s\n",expbuf))
			if((nf=parse(expbuf,expbp,'|')) > 1)
				for(i=0; nf--; i++)
					if (match(s, expbp[i]))
						goto found;
		}	
	usrerror(--s);
	return(NULL);

found:
	tracef(("PATT '%s' FOUND\n",s));
	PAUSE;
	if(getln(expbuf,BSIZ,expfile) > 0) {
		tracef(("expbuf='%s'", expbuf));
		if (*expbuf == '#')
			uknow(expbuf + 1);
		else {
			do {
				putstr(expbuf);
				putc('\n',stdout);
			}
			while(getln(expbuf,BSIZ,expfile) > 0);
			putstr(FFSTR);
		}
	}
	return(1);		/* all ok:the key was found in explain file */
}

usrerror(s) char *s; {
	ttyvb();
	recurseflg = UPONE;
	if(*s != '/')
		printf("\nVery funny-what does '%s' mean?\n\n", s);
	else
		printf("\nCan't find pattern '%s'\n\n",s);
	putstr(FFSTR);
}
