#include <stdio.h>

#ifdef DEBUG
#define DEBUGF(x)	printf x
#else
#define	DEBUGF(x)	/* nothing */
#endif

/* purpose:given an f-ratio of f, numerator df and denom df, return prob */
double fprob(f,nn,nd)
double f;
long nn, nd;
{
	long ia, ib, ij, i, j;
	double tmp, y, zk, r, p, d, z, w;
	double sqrt(), atan(), pow();

ia = 2*(nn/2)-nn+2;
ib = 2*(nd/2)-nd+2;
w = f*nn/nd;
z = 1.0/(1.0+w);
if (ia>=1) {
	if (ia==1) {
		if (ib<1)
			goto L20;
		if (ib!=1) {
			p = sqrt(w*z);
			DEBUGF(("w,z,p=%g,%g,%g\n",w,z,p));
			d = 0.5*p*z/w;
			if (nn+nd<3)
				goto L20;
			if (nn+nd==3)
				goto L10;
			}
		else {
			p = sqrt(w);
			DEBUGF(("w,p=%g,%g\n",w,p));
			y = 0.3183098;
			d = y*z/p;
			p = 2.0*y*atan(p);
			if (nn+nd<2)
				goto L20;
			if (nn+nd==2)
				goto L10;
			}
		}
	else {
		if (ib<1)
			goto L20;
		if (ib!=1) {
			d = z*z;
			p = w*z;
			DEBUGF(("5:w,z,p=%g,%g,%g\n",w,z,p));
			if (nn+nd<4)
				goto L20;
			if (nn+nd==4)
				goto L10;
			}
		else {
			p = sqrt(z);
			d = 0.5*z*p;
			p = 1.0-p;
			DEBUGF(("4:w,z,p=%g,%g,%g\n",w,z,p));
			if (nn+nd<3)
				goto L20;
			if (nn+nd==3)
				goto L10;
			}
		}
	y = 2.0*w/z;
	DEBUGF(("y,w,z=%g,%g,%g,\n",y,w,z));
	ij = ib+2;
	if (ij<=nd) {
		if (ia!=1) {
			tmp = (nd - 1)/2;
			zk = pow(z, tmp);
			DEBUGF(("zk=%g\n", zk));
			/* zk = z**((nd-1)/2);	*/
			d = d*zk*nd/ib;
			p = p*zk+w*z*(zk-1.0)/(z-1.0);
			}
		else
			for(j=ij; j <= nd; j += 2){
				tmp = ia;
				d = (1.0+tmp/(j-2))*d*z;
				p = p+d*y/(j-1);
				}
		}
	y = w*z;
	z = 2.0/z;
	ib = nd-2;
	ij = ia+2;
	if (ij<=nn)
		for(i=ij; i <= nn; i += 2) {
			r = i+ib;
			d = y*d*r/(i-2);
			p = p-z*d/r;
			}
	L10: if (p>1.0)
		p = 1.0;
	else if (p<0)
		p = 0.0;
	return(1.0-p);
	}
L20:  return(1.0);
}
