

#include "table.h"

/* given n, sum and sumsq stored in the data node, calc mean, var, se etc */
statcalc (tbl, mean, var, sd, se, low, high)
register TABLE *tbl;
double *mean, *var, *sd, *se, *low, *high;
{
	double sqrt(), t_table;
	double tprob();
	double n=tbl->na;

	*mean = tbl->sum / n;
	*var = (tbl->sum * tbl->sum) / n;	/* div obs sq by n */
	*var = (tbl->sumsq-(*var)) / (n - 1.0);
	*sd = sqrt (*var);
	*se = *sd / sqrt (n);

	t_table = tprob(0.05, tbl->na);	/* t-table for 95% ci */
	*low = *mean - t_table * (*se);
	*high = *mean + t_table * (*se);
}
