#include <stdio.h>

#define BSIZ 512
char lnbuf[BSIZ];

#define BPSIZ 12
char *bp[BPSIZ];

#define BLANK ' '
#define BEFORE bp[3]
#define AFTER bp[5]
#define REFERENCE bp[8]
#define PRSTR(x) for(c=x; *c; ) putc(*c++, stdout)
#define SL(x) strlen(x)
#define true 1
#define false 0

char tabchar='\t';	/* default preceeding whitespace char */
int tablen=8;		/* column length of preceeding white space char */

int before=45;
int after=70;
int gap=2;
char *usage="%s [-Fx][-a#][-b#][-g#]";

main(argc,argv)
int argc;
char *argv[];
{
	register char *argp;
	register int i;
	int reference=true;
	char sep='"';
	FILE *fp=NULL, *myopen();

	for(i=1; i < argc; i++) {
		argp = argv[i];
		if(*argp == '-') {
			switch(*++argp) {

			case 'F':
				sep = *++argp;
				break;
			case 'g':
				if(sscanf(++argp, "%d", &gap) != 1)
					err(usage,argv[0]);
				break;
			case 'b':
				if(sscanf(++argp, "%d", &before) != 1)
					err(usage,argv[0]);
				break;
			case 'a':
				if(sscanf(++argp, "%d", &after) != 1)
					err(usage,argv[0]);
				break;
			case 'r':
				reference=false;
				break;
			case 't':
				tabchar = *++argp;
				tablen = (tabchar == '\t') ? (8) : (1);
				break;
			} /* switch */
		}

		else{	 /* a file */
			fp = myopen(fp, argp, "r");
			ptxfmt(fp,sep,reference);
		}
	}
	if(!fp)
		ptxfmt(stdin,sep,reference);
}

ptxfmt(infile, sep, reference)
FILE *infile;
char sep;
int reference;
{
	register int len;
	register char *c;

	while(getln(lnbuf,BSIZ,infile) != EOF) {
		if(cparse(lnbuf,BSIZ,bp,sep, BPSIZ) >= 9) {
				/* leading tabs */
			for(len=before-SL(BEFORE); len>=tablen; len-=tablen)
				putc(tabchar,stdout);
				/* fill rest with required blanks */
			if(len > 0)
				while(len--)
					putc(BLANK,stdout);
			PRSTR(BEFORE);
			for(len=1; len <= gap; len++)
				putc(BLANK,stdout);
			PRSTR(AFTER);
			if(reference) {
				for(len=after-SL(AFTER)-gap; len > 0; len--)
					putc('.',stdout);
				PRSTR(REFERENCE);
			}
			putc('\n',stdout);
		}
	}
}
