#include <stdio.h>
#include "usr.h"

#define BAD -1
#define EOS '\0'
#define NUMBEROFPOINTS 10

struct pfstruct {
	struct pfstruct *next;
	char *pfstr;
} *pf_list, *pf_head;


char *cmdlist[]={"xmin",		"xmax",		"ymin",
		"ymax",		"group",	"echo",
		"title",	"label",	"ptitle",
		"xt",		"yt",		"xlab",
		"ylab",		"xlen",		"ylen",
		"join",		"xsort",	"ysort",
		"d",		"vbar",		"i",
		""};

int usrcmd(str)
char *str;
{
	int set_val(), parse(), sparse(), argtype(), strcmp();
	int nf, i;
	register char *c;
	char *bp[2], *tmp[NUMBEROFPOINTS], *strsave();
	FILE *popen();

	c = str;
	++c;

		/* if 2nd char is a '@', then user has
		* provided a pf command to be sent directly
		* to pf. save this command in a linked list
		* and send to pf after all the qplot pf code
	}	* has been sent (see plot_drive funct)
		*/

	if (*c == '@') {
		if(!(pf_list=(struct pfstruct *) alloc(sizeof(*pf_list))))
			NOSPACE;
		if(!(pf_list->pfstr = strsave(++c)))
			NOSPACE;
		if(pf_head)		/* link */
			pf_list->next = pf_head;
		pf_head = pf_list;
		return;	
	}


	sparse(c, bp, '=');
	switch( argtype(bp[0]) ) {
		case TITLE:	if (*(usr->title) != EOS)
					cfree (usr->title);
				usr->title = strsave(bp[1]);
				break;

			/* title to assoc with point: @ptitle=rt:hithere */	
		case PTITLE:	
				sparse(bp[1], tmp, ':');
				set_str(tmp[0], tmp[1]);
				break;

					/* do NOT cfree the null group case! */
		case GROUP:	if ( usr->newgrp )
					cfree(usr->group);
				usr->group = strsave(bp[1]);
				++(usr->newgrp);
				break;

		case ECHO:	
				usr->echo =  strcmp(bp[1], "off");
				break;


		case LABEL:	if (!(strcmp(bp[1], "off")))
					usr->label = OFF;	
				else if (!(strcmp(bp[1], "on")))
					usr->label = ON;
				else if (!(strcmp(bp[1], "auto")))
					usr->label = AUTO;
				else
					goto usrerr;
				break;

				
				

		case XT:	if (set_val(XT, &usr->xt, bp[1]) == BAD)
					goto usrerr;
				break;

		case YT:	if (set_val(YT, &usr->yt, bp[1]) == BAD)
					goto usrerr;
				break;

		case XLAB:	if ( *(usr->xlab) != EOS )
					cfree(usr->xlab);
				usr->xlab = strsave(bp[1]);
				break;

		case YLAB:	if ( *(usr->ylab) != EOS )
					cfree(usr->ylab);
				usr->ylab = strsave(bp[1]);
				break;

		case XMIN:	if (set_val(XMIN, &usr->xmin, bp[1]) == BAD)
					goto usrerr;
				break;


		case XMAX:	if (set_val(XMAX, &usr->xmax, bp[1]) == BAD)
					goto usrerr;
				break;

		case YMIN:	if (set_val(YMIN, &usr->ymin, bp[1]) == BAD)
					goto usrerr;
				break;

		case YMAX:	if (set_val(YMAX, &usr->ymax, bp[1]) == BAD)
					goto usrerr;
				break;

		case XLEN:	if (set_val(XLEN, &usr->xlen, bp[1]) == BAD)
					goto usrerr;
				break;

		case YLEN:	if (set_val(YLEN, &usr->ylen, bp[1]) == BAD)
					goto usrerr;
				break;

		case XSORT:
		case YSORT:
		case VBAR:
		case JOIN:	
				if (bp[1]){
					nf = parse(bp[1], tmp, ',');
					for(i=0; i < nf; i++)
						set_misc(c, tmp[i]);
				}
				else
					set_misc(c, "");
				break;

		case D:		if ( usr->pf )
					pclose(usr->pf);
				usr->pf = stdout;
				break;

		case I:		if (usr->pf)
					pclose(usr->pf);
				if ((usr->pf=popen(bp[1], "w"))==NULL)
					err("%s:can't popen %s", usr->progname,bp[1]);
				break;


		case BAD:	goto usrerr;
				break;
		} /* swt */
return(0);

usrerr:
		err("%s:bad option \"%s=%s\"", usr->progname, bp[0], bp[1]);
} /* routine */

int argtype(s)
char *s;
{
	int strcmp(), i;

	for (i=0; *cmdlist[i] != EOS; i++)
		if ( !(strcmp(cmdlist[i], s)) ) 
			return(i);
	return (BAD);
}

int set_val(type, x, str)
int type;
double *x;
char *str;
{
	int scanf();

	if (sscanf(str, "%f", x) != 1)
		return (BAD);
 	usr->set[type] = true;
	return( -(BAD) );
}

send_pf_list(){

	if (pf_head)
		for(pf_list=pf_head; pf_list; pf_list=pf_list->next)
			fprintf(usr->pf, "%s\n", pf_list->pfstr);
}
