#include <stdio.h>
#include "data.h"

/* epsilon val:if abs(theta1-theta0) > EPSILON, then reiterate, else done */
#define EPSILON 0.0001

#define true 1
#define false 0

step7(){		/* iterate to find exact theta */
	register int i;
	register int old=0, new=1;
	int two=2;
	int bigger_than_epsilon();
	double sum, sival, den;
	double calc_sum();

	
	sum = calc_sum(si, theta[old]);
printf("sum of si * theta=%f\n", sum);
	
	while(bigger_than_epsilon(theta[old], theta[new])) {
		for(i=0; i < ntable; i++) {
			sival = si[i];
			den = 2.0*(ntrans-sival) + sum - sival * theta[old][i];
			theta[new][i] = sival / den;
		}
print_old_new(theta[old],theta[new]);	/* temp debugging routine */
		old = ++old % two;	/* incr old and take mod 2 */
		new = ++new % two;	/* same for new */
		sum = calc_sum(si, theta[old]);
	}

	cfree((char *) si);	/* release the space assoc with the si vector */
	newtheta = theta[new]; 	/* set newtheta pointer to new theta row */
			 	/* step 8 needs new theta's to calc the pis */
}



int bigger_than_epsilon(old, new)
register float *old, *new;
{
	register int i;
	double fabs();

	for(i=0; i < ntable; i++) {
		if (fabs(*old++ - *new++) > EPSILON)
			return(true);
	}
	return(false);
}

print_old_new(old,new)
register float *old, *new;
{
	register int i;
	double fabs();

	printstr("\nthe old-new vals & abs(diff):\n");
	for(i=0; i < ntable; i++, old++, new++)
		printf("%.6f %.6f %.5f\n", *old, *new, fabs(*old - *new));
	printstr("\n");
}

		
double calc_sum(si, theta)
register float *si, *theta;
{
	register int i;
	double sum=0.0;

	for(i=0; i < ntable; i++)
		sum += *si++ * *theta++;
	return(sum);
}
