
/*	Copyright 1981 by David Zittin, Biosciences Data Centre.	 */
#include <stdio.h>
#include "usrcmds.h"
#include "treedef.h"
#define true (1)
#define false (0)

int scmp;
static int ht;		/* boolean to mark node addition on avl tree */
static DTNODE *prev=NULL;

mkdata(root, xcase, x) 
DTNODE **root;
char *xcase;
float x;
{
	char *mystrsave();
	int strcmp();
	DNODE *dnode;
	register DTNODE *p, *p1, *p2; 	/* p=fast root, p1&p2 are for avl bal */
	
	p = *root;
	if (prev != NULL){
		if ( !(strcmp(prev->dkey,xcase))) {
			p = prev;
			goto found;
		}
		prev = NULL;
	}
	if (p == NULL){			/* notfound, mk a data node */
		GSPACE (p,DTNODE,1);
		ht = true;
		p->dkey = mystrsave(xcase);

		GSPACE (dnode,DNODE,1);		/* mk linked data list */
		p->start = dnode;		/* ptr to start of data list */
		p->na = 1;		/* n in a_th grp */
		p->start->data = x;	/* sto data at head lnk list */
		p->start->next = NULL;
		p->sum = x;		/* sum of data */
		p->sumsq = x * x;		/* sum sq data */
		p->end = p->start;	/* end of lnk list ptr */
		p->rtd = p->ltd = NULL;	/* left & rigth ptrs */
		p->bal = 0;
	} /* if */
		
	else if ( (scmp=strcmp ( p->dkey, xcase)) > 0) {
		mkdata ( &((*root)->ltd), xcase, x );
		if ( ht ) {	/* lft branch higher */
			switch ( p->bal ) {
				case 1 :
					p->bal = 0;
					ht = false;
					break;
				case 0 :
					p->bal = -1;
					break;
				case -1 : {
					p1 = p->ltd;
					if( p1->bal == -1 ){	/* ll rotate */
						p->ltd = p1->rtd;
						p1->rtd = p;
						p->bal = 0;
						p = p1;
					}
					else {		/* doubl lr rotate */
						p2 = p1->rtd;
						p1->rtd = p2->ltd;
						p2->ltd = p1;
						p->ltd = p2->rtd;
						p2->rtd = p;
						if (p2->bal == -1)
							p->bal = 1;
						else
							p->bal = 0;
						if ( p2->bal == 1)
							p1->bal = -1;
						else
							p1->bal = 0;
						p = p2;
					} /* else */
					p->bal = 0;
					ht = false;
					break;
				} /* case -1 */
			} /* switch */
		} /* if ht */
	} /* else */
						
	else if (scmp < 0) {
		mkdata ( &((*root)->rtd), xcase, x);
		if ( ht ) {	/* rt branch higher */
			switch ( p->bal ) {
				case -1:
					p->bal = 0;
					ht = false;
					break;
				case 0:
					p->bal = 1;
					break;
				case 1: {
					p1 = p->rtd;
					if ( p1->bal == 1) {
						p->rtd = p1->ltd;
						p1->ltd = p;
						p->bal = 0;
						p = p1;
					} 
					else {
						p2 = p1->ltd;
						p1->ltd = p2->rtd;
						p2->rtd = p1;
						p->rtd = p2->ltd;
						p2->ltd = p;
						if ( p2->bal == 1)
							p->bal = -1;
						else
							p->bal = 0;
						if ( p2->bal == -1 )
							p1->bal = 1;
						else
							p1->bal = 0;
						p = p2;
					} /* else */
					p->bal = 0;
					ht = false;
					break;
				} /* case +1 */
			} /* switch */
		} /* if rt higher */
	} /* else */
	else{				/* found */
found:
		ht = false;
		GSPACE (dnode,DNODE,1);		/* mk new data node */
		dnode->data = x;		/* sto data */		
		dnode->next = NULL;
		p->na++;			/* inr grp count */
		p->sum += x;		/* accum sum */
		p->sumsq += (x * x);	/* accum sumsq */
		p->end->next = dnode;	/* link */
		p->end = dnode;		/* set end to new dnode */
	}
	*root = prev = p;	/* set root to register tmp root */
}
