
/*	Copyright 1981 by David Zittin, Biosciences Data Centre.	 */

#define	TEST(x,a,b) ((x) ? a : b)
#include <stdio.h>
#include "usrcmds.h"
#include "treedef.h"

#define	SIG(s,e) ((s/e >= zval) ? "*" : "ns")

#define NL '\n'
char *L[] = {	"n", "min", "max", "mean", "95%ci(mean)", "median", 
		"var", "sd", "se", "g1", "g2" };

char *horizdec = "%s=%-8d \t ";
char *horizfloat = "%s=%g \t ";

char *columndec = "%-8s\t%d\n";
char *columnfloat = "%-8s\t%g\n";

char *gammacol = "%-8s\t%g%s\n";
char *gammahor = "%s=%g%s \t ";

char *cihoriz = "%s=%g %g \t ";
char *cicol = "%-8s\t%g\t%g\n";

char *cifmt, *decfmt, *floatfmt, *gammafmt;	/* tmp fmt ptrs */



float zval=1.96;		/* 95 % ci for std norm dist */
float *data_vec;		/* ptr to area to sto data for sorting */

int ntotal=0;			/* total in all grps */


/* print the data. do an inorder traversal of the data tree. print the
group stats assoc with each data node */

pr_grpstat(root)
DTNODE *root;
{
	int  max_group();	
	
	if (!(usrcmds.outfmt)) {	/* columnar */
		decfmt = columndec;
		floatfmt = columnfloat;
		gammafmt = gammacol;
		cifmt = cicol;
	}
	else {
		decfmt=horizdec; 		/* default fmt */
		floatfmt=horizfloat;
		gammafmt = gammahor;
		cifmt = cihoriz;
	}


		/* get vec to hold data for sorting */
	GSPACE(data_vec, float, max_group(root) );
	if (usrcmds.echo)
		printf("\n\n\n");
	printf("\n>>GROUP STATS (var. from n-1 df):%s<<\n",TEST(usrcmds.title==NULL," ",usrcmds.title));
	grpstat(root);
	printf("\nTOTAL %d\t\t\t(ns=not sig, p>0.05; *=sig, p<=0.05)\n",ntotal);
}

grpstat(root)
DTNODE *root;
{
	float mean, median, var, sd, se, low_95, high_95;
	float g1, g2, se_g1, se_g2;		/* skew and kutosis */	
	register DNODE *head;
	register float *dptr;
	register int i=0;
	int cmp();

	if(root != NULL){
		grpstat(root->ltd);
		ntotal += root->na;		/* accum grand tot */
		if (root->na < 2)
			printf("\n>>> %s ==>NO STATS, N < 2!\n",root->dkey);
		else {
			dptr = data_vec;

				/* mv link list to data vec for sorting */
			for(head=root->start; head; head = head->next)
				*dptr++ = head->data;
			qsort(data_vec, root->na, sizeof(float), cmp);

				/* calc median, get half way val */
			median = *(data_vec + (root->na/2) ); 	
			if ( !(root->na % 2))	/* even number */
				median = (median + *(data_vec + (root->na/2) - 1) ) / 2.0;

			statcalc(root, &mean, &var, &sd, &se, &low_95,&high_95);


/* print stats */

			printf("\n\n>>> %s ==>\n\n", root->dkey);
			printf(decfmt, L[i++], root->na);
			printf(floatfmt, L[i++], *data_vec);
			printf(floatfmt, L[i++], *(data_vec + root->na - 1));
			printf(floatfmt, L[i++], mean);

			if (usrcmds.outfmt) 			 /* horiz */
				putc(NL,stdout);
			printf(cifmt, L[i++], low_95, high_95);
			printf(floatfmt, L[i++], median);
			printf(floatfmt, L[i++], var);

			if (usrcmds.outfmt) 			 /* horiz */
				putc(NL,stdout);
			printf(floatfmt, L[i++], sd);
			printf(floatfmt, L[i++], se);


			if (root->na >= 5 && var > 0.0){
				gamma(data_vec, root->na, &g1, &se_g1, &g2, &se_g2);
				if (!(usrcmds.outfmt)) gammafmt[9] = NL;
				printf(gammafmt, "g1",g1,SIG(g1, se_g1));
				printf(gammafmt, "g2",g2,SIG(g2, se_g2));
				gammafmt[9] = '\t';
			}
			else
				printf("no gammas(N<5 or var=0)\n");
			printf("\n");
	} /* else */
	grpstat(root->rtd);
	}
}
int cmp(arg1, arg2)
float *arg1, *arg2;
{
	if (*arg1 > *arg2)
		return (1);
	if (*arg1 < *arg2)
		return(-1);
	return(0);	/* equal */
}
