
#include <stdio.h>
#include <ctype.h>
#include "usr.h"
#include "treedef.h"

#define CMDBUFSIZ 80
char cmdbuf[CMDBUFSIZ];
char *badcommand = "%s:Bad command specification:%s";

/* data buf */
#define BLEN 256

/* the number of fields in usr data */
#define BPLEN 100

int NF;
char buf[BLEN], *bp[BPLEN], *fgets(), *index(), *strcpy();
FILE *myopen(), *fdopen();

main(argc, argv)
int argc;
char *argv[];
{
	register int i;
	register char *argp;
	FILE *treef=NULL, *dataf=NULL;
	t_node *maketree(), *root;

	
	field = 1;
	progname = argv[0];
	for(i=1; i < argc; i++) {
		argp = argv[i];
		if(*argp == '-' && *(argp+1) ) 
			switch(*++argp){

			case 't':	if(!(treef=myopen(treef,argv[++i],"r")))
						err("%s:Can't open %s",
							progname, argv[i]);
					root = maketree(treef);
					break;

			case 'e':	++echo;
					break;
			
			case 'f':	if(sscanf(++argp,"%d", &field) != 1)
						err("%s:Bad field number",
							progname);
					break;

			default:	err("%s:Unknown flag", progname);
					break;
			}
		else {
			if(!(dataf=myopen(dataf,argp,"r")))
				err("%s:Can't open %s", progname, argv[i]);
			if(!treef){
				treef = stdin;
				root = maketree(treef);
			}
			drive_tree(dataf, root);
		}
	}

	if(!dataf) {		/* no data file opened above, usr stdin */
		if(!treef)
			root = maketree(stdin);
		drive_tree(stdin, root);
	}

}

t_node *maketree(treef)
FILE *treef;
{
	register t_node *root;
	t_node *bldtree();

	if (!(root = bldtree(treef)))
		err("%s:bad tree specs at line %d", progname, line);
	if(fgets(buf,BLEN,treef))
		err("%s:Tree file has too many lines", progname);
	return(root);
}

drive_tree(dataf, root)
FILE *dataf;
t_node *root;
{
	register int i;
	register t_node **sp;
	register char *retstr;
	t_node **bstack, **srch_tree();
	int max_level;


/* build event stack */
	max_level = max_depth(root);	/* get max depth of tree */
					/* get stack & mark beginning */
	if(!(sp=bstack=(t_node **) calloc(max_level,sizeof(t_node *))))
		err("%s:nospace", progname);

			/* process user data file */
	*sp = root;	/* set first element of stack to pt at tree */
	--field;	/* change usr field to C array subscript */
	while (fgets(buf, BLEN, dataf)) {
		NF = glnstr(buf,BLEN,bp,BPLEN);

/* if data file has less flds than usr specified, then null ptr */
recycle:
		if (NF < field)
			sp = bstack;

		if (!(sp = srch_tree(bp[field], sp, bstack)))
			sp = bstack;

			/* assgn return str to register var */
		if( !(retstr = (*sp)->retstr) )
			continue;

		if(*retstr == '!') {
			fflush(stdout);
			if(unixcmd(retstr, dataf)==EOF)
				return;
			if(!index(retstr,'<'))
				continue;
			goto recycle;
		}
		
		fputs(retstr, stdout);
		if (echo)
			for(i=0; i < NF; i++)
				printf(" %s", bp[i]);
		putc('\n', stdout);
	}
}


unixcmd(cmd, fromfile)
char *cmd;
FILE *fromfile;
{
	register char *endstr, *prog, *savebuf;

	if (strlen(cmd) >= CMDBUFSIZ-1)
		err("%s:Unixcmd too long",progname);

	/* make a copy of the unixcmd for parsing-don't butcher the original */
	savebuf=strcpy(cmdbuf, cmd);

/* now parse out the details of the unix command for the upto function */
	if((endstr = index(savebuf, '<'))) {
		if(*++endstr != '<')
			err(badcommand, progname, cmd);
		for(prog=endstr-2; isspace(*prog); )
			if(--prog < savebuf)
				err(badcommand, progname, cmd);
		*++prog = '\0';
		for(++endstr; isspace(*endstr); )
			if(!*endstr++)
				err(badcommand, progname, cmd);
	}

/* now process user's data stream thru usr specified unix command */
	return( upto(endstr, savebuf+1, fromfile) );
}

upto(endstr, program, fromfile)
char *endstr;
char *program;
FILE *fromfile;
{
	register char *tmpstr;
	register int i;
	register FILE *fp;
	int len;
	char *eof;

	if(!endstr) {
		system(program);
		return(1);
	}
	else {
		len = strlen(endstr);
		if(!(fp=fdopen(pipeout("/bin/sh", "sh", "-c", program, 0),"w")))
			err("upto:bad pipeout");
		for (;;) {
			for(i=0; i < NF; i++) {
				if(i) putc(' ',fp);
				fputs(bp[i],fp);
			}
			putc('\n',fp);
			if(!(eof=fgets(buf, BLEN, fromfile)))
				break;
			NF = glnstr(buf,BLEN,bp,BPLEN);
			tmpstr = bp[field];
			if(*tmpstr == *endstr && !strncmp(endstr,tmpstr,len))
				break;
		}
	}
	fclose(fp);
	wait();
	return( (eof) ? (1) : (EOF) );
}


/* max_depth - return max. depth of multiway tree */

int	max_depth(ptr)
t_node	*ptr;
{
	int max=0;

	if(ptr)
		find_depth(ptr, 1, &max);
	return(max);
} /* max_depth */


/* find_depth - traverse tree and find max. depth */

int	find_depth(ptr, cur, max)
t_node	*ptr;
register int	cur, *max;
{
	register t_node	**next;

	for(next=ptr->next_vec; *next; ++next)
		find_depth(*next, ++cur, max);
	if(cur > *max)
		*max = cur;
} /* find_depth */


