#include <stdio.h>
#include "usr.h"
#include <debug.h>

double tablval[3];	/* array where table O row is to be put */
#define P05 tablval[0]	/* table val for p = 0.05 */
#define P02 tablval[1]	/* p = 0.02 */
#define P01 tablval[2]	/* p = 0.01 */
#define PLIST tablval
#define true 1

#define LIKELY(x) (x)?(""):("un")
#define INCREASE(x) (x)?("an increase"):("a decrease")

	/* the z distribution */
#define Z1	1.645
#define Z05	1.96
#define Z025	2.24
#define Z01	2.575
#define Z001	3.27

#define F12 24
#define F13 F12
#define THREE '3'
#define TWO '2'

char *longmsg = "significant (%1.2f>p>%1.2f)";
char *lt_eq_msg = "significant (%1.2f >= p > %1.2f)";
char *shortmsg = "significant (p=%1.2f)";
char *notsig = "not significant (p>%1.2f)";


significant(morepos, s1, s2, n, T)
int morepos;
char *s1, *s2;
int n;
double T;
{


	int np1;
	int issig=true;
	double z, num, den, sqrt(), fabs();

	if (n < 0)
		err("%s botch:n<0(=%d)", usr.prog, n);

	printf("Test of Significance for %s and %s. Two-tailed probabilities.\n", s1, s2);
	printf("Number of nonzero diffferences=%d\n", n);

	printf("The calculated T stat is %g\n", T);
	if (n < 6) {
		printf("\tCan't do a %s on < 6 nonzero pairs\n", usr.prog);
		if(n == 5 && T == 0.0) {
			printf("\tHowever, since the 5 diffs have the same");
			printf(" sign, it is likely (p=0.05) there"); 
			printf("\n\tis a treatment effect\n");
		}
		return;
	}

	printf("CONCLUSIONS:\n\tSince the calculated");
	if(n > 25) {
				/* calc the z statistic */
		np1 = n + 1;
		num = T - n * np1 / 4.0;
		den = sqrt((n * np1 * (2.0 * n + 1)) / 24.0);

		TRACEF(("zval=%g \tnum=%g \tden=%g\n", z, num, den));
		z = fabs(num/den);	/* compute the z val of siegal */

		printf(" 'z' value (%g) is ", z);

		if(z <= Z1) {
			printf(notsig, 0.1);
			--issig;
		}
		else if (Z1 < z && z < Z05) {
			printf("not signifcant (%1.2f>p>%1.2f)", 0.1, 0.05);
			--issig;
		}
		else if (z == Z05)
			printf(shortmsg, 0.05);
		else if (Z05 < z && z < Z025)
			printf(longmsg, 0.05, 0.025);
		else if (z == Z025)
			printf(shortmsg, 0.025);
		else if (Z025 < z && z < Z01)
			printf(longmsg, 0.025, 0.01);
		else if (z == Z01)
			printf(shortmsg, 0.01);
		else if (Z01 < z && z < Z001) {
			longmsg[F12] = THREE;	/* change fmt str 1.2f->1.3f */
			printf(longmsg, 0.01, 0.001);
			longmsg[F13] = TWO;
		}
		else if (z == Z001)
			printf(shortmsg, 0.001);
		else
			printf("significant (p<0.001)");

	}

	else {
		lookup(n, PLIST);

		printf(" 'T' value (%g) is ", T);
		if(T > P05) {
			--issig;
			printf(notsig, 0.05);
		}

		else if (T <= P05 && T > P02)
			printf(lt_eq_msg, 0.05, 0.02);

		else if (T <= P02 && T > P01)
			printf(lt_eq_msg, 0.02, 0.01);

		else
			printf("significant (p<0.01)");
	}

	/* print conclusion */
printf(",\n\tit is %slikely that '%s' differs from '%s'.\n",LIKELY(issig), s1, s2);
if(issig) {
	printf("\tThe '%s' members of the pairs tended to demonstrate %s ", s1, INCREASE(morepos) );
	printf("\n\tof the measured response relative to the '%s' members.\n", s2);
	}
}
