{ Concurrent Worms  V1.00  J.R. Cordy  29 April 1982 }
var Worms: module
    include '%CURSES'

    pervasive const nWorms := 3

    var Its: monitor
	exports (YourTurn, MyTurn, WormDone, AllDone)

	{ Monitor to synchronize unit actions on the
	  terminal screen;  Its.MyTurn insures that the
	  process may manipulate the screen until it
	  calls Its.YourTurn                            }

	var mine: Boolean := false
	var yours: condition { not mine }
	var done : condition

	procedure MyTurn =
	    imports (var mine, var yours)
	    begin
		if mine then
		    { Someone else already has it }
		    wait (yours)
		end if
		mine := true
	    end MyTurn

	procedure YourTurn =
	    imports (var mine, var yours)
	    begin
		mine := false
		signal (yours)
	    end YourTurn

	procedure WormDone =
	    imports (var done)
	    begin
		signal (done)
	    end WormDone

	procedure AllDone =
	    imports (var done)
	    begin
		var numberDone : 0 .. nWorms := 0
		loop
		    wait (done)
		    numberDone := numberDone + 1
		    exit when numberDone = nWorms
		end loop
	    end AllDone
    end monitor

    { Screen parameters }
    pervasive const minX := 0
    pervasive const maxX := 79
    pervasive const minY := 0
    pervasive const maxY := 23

    { Worm parameters }
    pervasive const wormLength := 11
    pervasive const wormX0: array 1..nWorms of minX..maxX-1 := (0,38,72)
    pervasive const wormY0: array 1..nWorms of minY..maxY-1 := (0,11,22)
    pervasive const wormString: array 0..nWorms*wormLength-1 of Char :=
	($C,$o,$n,$c,$u,$r,$r,$e,$n,$t,$$S,
	 $E,$u,$c,$l,$i,$d,$$S,$$S,$$S,$$S,$$S,
	 $P,$r,$o,$c,$e,$s,$s,$e,$s,$$S,$$S)
    pervasive const wormWiggle: array 0..wormLength-1 of -1..1 :=
	(1,1,1,1,1,0,0,-1,-1,-1,0)

    { Worm algorithm }
    procedure Worm (w: 1..nWorms) =
	imports (var Its, var Curses)
	begin
	    { Segments of the worm }
	    var segment: array 0..wormLength-1 of
		record
		    var x: minX..maxX
		    var y: minY..maxY
		end record

	    { Present direction of motion }
	    var xdir: -1..1 := 1
	    var ydir: -1..1 := 1

	    { Turning parameters }
	    const maxCount := 1024
	    var count: 0..maxCount-1 := 0
	    const xturn: 0..maxCount := w * 117
	    const yturn: 0..maxCount := w * 37

	    { Head and tail segments }
	    var head: 0..wormLength-1 := 0
	    var tail: 0..wormLength-1 
	    var i: 0..wormLength
	    var j: 0..nWorms*wormLength-1

	    { Initialize }
	    i := 0
	    loop
		exit when i = wormLength
		segment(i).x := wormX0(w)
		segment(i).y := wormY0(w)
		i := i + 1
	    end loop

	    loop
		exit when Curses.HasCh

		tail :=  (head + 1) mod wormLength

		{ Compute new head position }
		if segment(head).x >= maxX-1 then
		    xdir := -1
		elseif segment(head).x <= minX+1 then
		    xdir := 1
		end if
		segment(tail).x :=
		    segment(head).x + xdir + xdir * wormWiggle(tail)
		assert (segment(tail).x >= minX and segment(tail).x <= maxX)

		if segment(head).y = maxY then
		    ydir := -1
		elseif segment(head).y = minY then
		    ydir := 1
		end if
		segment(tail).y := segment(head).y + ydir
		assert (segment(tail).y >= minY and segment(tail).y <= maxY)

		head := tail

		{ Redraw worm }
		Its.MyTurn
		i := head
		j := (w-1) * wormLength
		loop
		    Curses.Move (segment(i).y, segment(i).x)
		    Curses.AddCh (wormString(j))
		    exit when wormString(j) = $$S
		    i := (i + wormLength - 1) mod wormLength
		    j := j + 1
		end loop
		Curses.Refresh
		Its.YourTurn

		{ Decide if it's time to turn around }
		if count mod xturn = 0 then
		    xdir := -xdir
		end if
		if count mod yturn = 0 then
		    ydir := -ydir
		end if

		count := (count + 1) mod maxCount
	    end loop
	    Its.WormDone
	end Worm

	procedure Finalize =
	    imports (var Curses)
	    begin
		var c : Char
		Curses.Move (23, 0)
		Curses.CursorOn
		loop
		    exit when not Curses.HasCh
		    Curses.GetCh (c)
		end loop
		Curses.Clear
		Curses.Refresh
		Curses.Endwin
	    end Finalize

	initially
	    imports (var Curses)
	    begin
		Curses.Clear
		Curses.CursorOff
	    end

    process Worm1
	imports (Worm)
	begin
	    Worm (1)
	end Worm1

    process Worm2
	imports (Worm)
	begin
	    Worm (2)
	end Worm2

    process Worm3
	imports (Worm)
	begin
	    Worm (3)
	end Worm3

    process Cleanup
	imports (var Its, Finalize)
	begin
	    Its.AllDone
	    Finalize
	end Cleanup

end module
