/*
 * Tektronix 8560 Unix - Unix Copy
 *
 *
 *	Copyright (C), 1982, Tektronix Inc.
 *	All rights Reserved
 */


#ifdef SCCSID
static char *sccsid = "@(#)@(#)uuphone.c	5.1 (82/12/08) Tektronix 8560 Unix";
#endif

#include <stdio.h>
#include <time.h>
#include <signal.h>

extern int onintr();	/* forward refernce */

#define DEBUG(l, f, s)	if (Debug >= l) fprintf(stderr, f, s)
#define STDIN	0
#define	STDOUT	1

#define DIALLOG	"/usr/spool/uucp/DIALLOG"
#define	NONUM	1	/* no phone number in phone string */
#define	DIALERR	2	/* dialer returned error */
#define	BADTYPE	3	/* this program doesn't know about that type of modem */
#define	INTRPT	4

#define	DFLDEBUG	0

/*
 * uuphone - UUCP phone dialing program
 *
 *	uuphone [-xN] system dialer line phone#
 *
 *
 * this program (/usr/lib/uucp/uuphone) takes four or five arguments,
 * an optional '-xN' switch, where N = 0..9, and toggles debugging,
 * in the manner of the rest of the uucp stuff. The remaining
 * arguments, which must be present, are:
 *
 *		system	- the system name (for logging)
 *		dialer  - the third field from L-devices,
 *				either type (VADIC,HAYES) or device #
 *		line	- device which STDIN/STDOUT is directed to
 *		phone#	- the phone number string
 *
 *
 * This program assumes that its STDIN and STDOUT both
 * refer to the dialer in question.
 *
 * This program currently supports the Hayes Smart Modem (300 baud
 * version), and the Racal-Vadic 3451 with autodial option. Other
 * modems may be added by adding code in a sensible way, below.
 *
 * needed enhancements: add 'expect' style-subroutine, and code
 * device strings as 'expect-send' style stuff, a la L.sys
 *
 */ 

int	Debug = DFLDEBUG;
char	tbuf[BUFSIZ];
char	*myname;
int	nolog;		/* set if logfile open fails */
FILE	*log;			/* log file pointer */
char	*sys, *type, *dev, *phone;
struct tm	*now;
extern struct tm *localtime();

main(argc, argv)
int argc;
char **argv;
{
	int i;
	int r;
	char inbuf[BUFSIZ];		/* general purpose buffer */
	char *in;
	long ltime;

	/*
	 * our parent, uucico, does goofy things with signals
	 */

	signal(SIGILL, onintr);
	signal(SIGTRAP, onintr);
	signal(SIGIOT, onintr);
	signal(SIGEMT, onintr);
	signal(SIGFPE, onintr);
	signal(SIGBUS, onintr);
	signal(SIGSEGV, onintr);
	signal(SIGSYS, onintr);
	signal(SIGINT, onintr);
	signal(SIGHUP, onintr);
	signal(SIGQUIT, onintr);
	signal(SIGTERM, onintr);

	/*
	 * try opening log file, if we can't don't log
	 */

	myname = argv[0];
	if ((log = fopen(DIALLOG, "a")) == NULL) {
		nolog = 1;
	} else {
		nolog = 0;
		time(&ltime);
		now = localtime(&ltime);
		sprintf(tbuf, "(%d/%d-%d:%02d-%d)", now->tm_mon,now->tm_mday,
				now->tm_hour,now->tm_min,getpid());
	}

	if (argv[1][0] == '-' && argv[1][1] == 'x') {
		Debug = (argv[1][2])-'0';
		argv++;
		argc--;
	}
	if (argc != 5) {
		DEBUG(1, "uuphone: wrong number of arguments (%d)\n", argc);
		if (!nolog) {
			fprintf(log, "%s  %s  ERROR: wrong number of args\n",
				myname, tbuf);
			exit(-1);
		}
	}
	sys = argv[1];
	type = argv[2];
	dev = argv[3];
	phone = argv[4];

	if (!nolog) {
		fprintf(log, "%s %s %s %s (%s) - %s\n", myname, sys, tbuf, dev, type, phone);
	}

	DEBUG(1, "phone: %s\n", phone);


	/*
	 * p now points to null-delimited name of dialer type
	 * q now points to remainder of phone number string
	 */

	/* HAYES SMART MODEM */

	if ((strcmp(type, "HSM") == 0) || (strcmp(type, "HAYES") == 0)) {

		DEBUG(2, "phone: dialer is Hayes Smart Modem\n", "");

		/*
		 * NOTE: the Hayes defaults to using Pulse dialing - this
		 * can be overridden either by changing the code below, or
		 * by prefixing the phone number with
		 * the proper pulse or tone selctor letter
		 */

		write(STDOUT, "ATD", 3);
		write(STDOUT, phone, strlen(phone));
		write(STDOUT, "\r", 1);

		/*
		 * for HAYES, we expect the return string:
		 *  <CR><LF>CONNECT<CR><LF>
		 */

		/*
		 * this is a botch - we must read 1 byte at a time
		 */

		read(STDIN, inbuf, 1); /* suck up CRLF */
		read(STDIN, inbuf, 1); /* suck up CRLF */

		for (in=inbuf,i=0; i < BUFSIZ; i++) {
			if ((r = read(STDIN, in++, 1)) <= 0) {
				break;
			}
			in[-1] &= 0177;
			if (in[-1] == '\n' || in[-1] == '\r') {
				in--;
				break;
			}
		}
		in = '\0';
		DEBUG(4, "phone: HAYES, return = '%s'\n", inbuf);
		if (strncmp(inbuf, "CONNECT", 7) == 0) {
			if (!nolog) {
				fprintf(log, "%s %s %s DIAL SUCCEEDS (HAYES)\n",
					myname, sys, tbuf);
			}
			DEBUG(1, "phone: SUCCESS\n", "");
			exit(0);
		} else {
			if (!nolog) {
				fprintf(log, "%s %s %s DIAL FAILS (HAYES)\n",
					myname, sys, tbuf);
			}
			DEBUG(1, "phone: FAIL, code %d\n", DIALERR);
			exit(DIALERR);
		}
	/*NOTREACHED*/
	} else if ((strcmp(type, "VADIC")==0)||(strcmp(type, "RV")==0) ||
		(strcmp(type, "vadic") == 0) || (strcmp(type, "Vadic") == 0)) {

		int cr;

		/* RACAL-VADIC 3451 with AutoDial Option */
		
		DEBUG(2, "phone: dialer is Vadic 3451/Autodial\n", "");

		/*
		 * write 3 CR's to auto-baud,
		 *
		 * then write <ENQ><CR> so it will speak to us
		 */

		cr = '\r';
		write(STDOUT, &cr, 1);
		sleep(1);
		write(STDOUT, &cr, 1);
		sleep(1);
		write(STDOUT, &cr, 1);
		sleep(1);

		write(STDOUT, "\005", 1);
		sleep(1);
		write(STDOUT, &cr, 1);

		/*
		 * now we look for stupid 'HELLO: I'M READY\r\n*' prompt
		 */

		DEBUG(8, "phone: VADIC: sent ^E<CR>, looking for 'HELLO'\n","");

		for (in = inbuf, i = 0; i < BUFSIZ; i++) {
			if (read(STDIN, in++, 1) != 1)
				break;
			in[-1] &= 0177;		/* strip off parity */
			if (in[-1] == '*') break;
		}
		if (in[-1] != '*') {
			DEBUG(2, "phone: VADIC: bad response string 1\n", "");
			if (!nolog) {
				fprintf(log, "%s %s %s DIAL FAILS (VADIC)\n",
					myname, sys, tbuf);
			}
			exit(DIALERR);
		}

		DEBUG(8, "phone: VADIC: got 'HELLO ...'\n", "");

		/*
		 * now send 'D\r' to get into dialing mode, and slurp up
		 * stupid prompt #2, 'NUMBER?\r\n'
		 */

		write(STDOUT, "D", 1);
		sleep(1);
		write(STDOUT, &cr, 1);
		sleep(1);

		DEBUG(8, "phone: VADIC: sent 'D<CR>', looking for 'NUMBER?'\n", "");

		for (in = inbuf, i = 0; i < BUFSIZ; i++) {
			if (read(STDIN, in++, 1) != 1)
				break;

			in[-1] &= 0177;	/* strip parity */

			if (in[-1] == '\n')
				break;
		}
		*in = '\0';
		if (in[-1] != '\n') {
			DEBUG(2, "phone: VADIC: bad response string 2\n", "");
			if (!nolog) {
				fprintf(log, "%s %s %s DIAL FAILS (VADIC)\n",
					myname, sys, tbuf);
			}
			exit(DIALERR);
		}

		DEBUG(8, "phone: VADIC: got 'NUMBER?' = '%s'\n", inbuf);

		/*
		 * finally, we send the phone number
		 */

		in = phone;
		while(*in) {
			write(STDOUT, in++, 1);
			sleep(1);
		}
		write(STDOUT, &cr, 1);

		DEBUG(7, "phone: VADIC: sent '%s', looking for number\n", phone);

		for(in = inbuf, i = 0; i < BUFSIZ; i++) {
			if (read(STDIN, in++, 1) != 1)
				break;

			in[-1] &= 0177;

			if ((in[-1] == '\n') || (i >= (strlen(phone)+2)))
				break;
		}
		DEBUG(8, "phone: VADIC: read '%s'\n", inbuf);

		if (i < strlen(phone)) {
			DEBUG(2, "phone: VADIC: bad phone # verification\n","");
			if (!nolog) {
				fprintf(log, "%s %s %s DIAL FAILS (VADIC)\n",
					myname, sys, tbuf);
			}
			exit(DIALERR);
		}

		DEBUG(7, "phone: VADIC: got number\n", "");

		/*
		 * now a CR to OK the echoed number
		 */

		write(STDOUT, &cr, 1);

		DEBUG(8, "phone: VADIC: sent CR, waiting for 'DIALING'\n", "");

		/*
		 * VADIC now echoes 'DIALING: ' and eventually responds with
		 * one of 'ON LINE\r\n' or 'FAILED CALL\r\n'
		 */

		for(in = inbuf, i = 0; i < BUFSIZ; i++) {
			if (read(STDIN, in++, 1) != 1)
				break;

			in[-1] &= 0177;

			if (in[-1] == '\n')
				break;
		}
		*in = '\0';

		DEBUG(8, "phone: VADIC: got '%s'\n", inbuf);

		if (strncmp(inbuf, "DIALING:  ON LINE", 17) == 0) {
			DEBUG(2, "phone: VADIC, SUCCESS\n", "");
			if (!nolog) {
				fprintf(log, "%s %s %s DIAL SUCCEEDS (VADIC)\n",
					myname, sys, tbuf);
			}
			exit(0);
		} else {
			DEBUG(2, "phone: VADIC, return = '%s'\n", inbuf);
			if (!nolog) {
				fprintf(log, "%s %s %s DIAL FAILS (VADIC)\n",
					myname, sys, tbuf);
			}
			exit(DIALERR);
		}
		/*NOTREACHED*/
	} else if ((strcmp(type, "VENTEL")==0)||(strcmp(type, "Ventel")==0) ||
		(strcmp(type, "ventel") == 0)) {

		/* Ventel Autodialer */

		/*
		 * NOTE!!!
		 *
		 * Due to a severe lack of such a dialer
		 * THIS CODE HAS NEVER BEEN TESTED!
		 *
		 * caveat emptor
		 */
		
		DEBUG(2, "phone: dialer is Ventel Autodial\n", "");

		/* now try to get its attention */
		DEBUG(4, "uuphone: POKE VENTEL, ", "");

		/* IS-1 way
		write(dcf, "\r\r", 2);
		*/

		write(STDOUT, "\r",1);
		sleep(1);
		write(STDOUT, "\r",1);

		DEBUG(4, "uuphone: IS VENTEL THERE?\n", "");

		for(in = inbuf, i = 0; i < BUFSIZ; i++) {
			if (read(STDIN, in++, 1) != 1)
				break;

			in[-1] &= 0177;

			if (in[-1] == '$')
				break;
		}
		*in = '\0';

		if (in[-1] != '$') {
			DEBUG(2, "phone: VENTEL: bad response\n", "");
			if (!nolog) {
				fprintf(log, "%s %s %s DIAL FAILS (VENTEL)\n",
					myname, sys, tbuf);
			}
			exit(DIALERR);
		}

		/* now dial the number */

		/*ioctl(dcf, TIOCSETP, &ttbuf);    /* discard buffered stuff */
		write(STDOUT, "K", 1);

		for(in = inbuf, i = 0; i < BUFSIZ; i++) {
			if (read(STDIN, in++, 1) != 1)
				break;

			in[-1] &= 0177;

			if (in[-1] == ' ')
				break;
		}
		*in = '\0';

		if (strncmp(inbuf, "DIAL: ", 6) != 0) {
			DEBUG(2, "phone: VENTEL: bad response 2\n", "");
			if (!nolog) {
				fprintf(log, "%s %s %s DIAL FAILS (VENTEL)\n",
					myname, sys, tbuf);
			}
			exit(DIALERR);
		}

		write(STDOUT, phone, strlen(phone));
		write(STDOUT, "\r", 1);

		for(in = inbuf, i = 0; i < BUFSIZ; i++) {
			if (read(STDIN, in++, 1) != 1)
				break;

			in[-1] &= 0177;

			if (in[-1] == '!')
				break;
		}
		*in = '\0';

		DEBUG(8, "phone: VENTEL: got '%s'\n", inbuf);

		if (strncmp(inbuf, "ONLINE!", 7) == 0) {
			DEBUG(2, "phone: VADIC, SUCCESS\n", "");
			if (!nolog) {
				fprintf(log, "%s %s %s DIAL SUCCEEDS (VENTEL)\n",
					myname, sys, tbuf);
			}
			exit(0);
		} else {
			DEBUG(2, "phone: VADIC, return = '%s'\n", inbuf);
			if (!nolog) {
				fprintf(log, "%s %s %s DIAL FAILS (VENTEL)\n",
					myname, sys, tbuf);
			}
			exit(DIALERR);
			/*NOTREACHED*/
		}

	}
	DEBUG(1, "phone: FAIL, code %d\n", BADTYPE);
	if (!nolog) {
		fprintf(log, "%s %s %s DIAL FAILS (bad dialer '%s')\n",
			myname, sys, tbuf, type);
	}
	exit(BADTYPE);
}

onintr() {

	DEBUG(1, "phone: caught signal\n", "");
	if (!nolog) {
		fprintf(log,"%s %s %s CAUGHT SIGNAL\n",myname, sys, tbuf, type);
	}
	exit(INTRPT);
}
