/*  uupurge.h - common defines for uupurge modules
 *
 ***********************************************************
 */

#include <stdio.h>

/* file name defines - may need to be changed on a per system 
 * basis
 */

#define SPOOLDIR  "/usr/spool/uucp"           /* uucp spool dir */


/* internal defines - sizes of various structures
 */

#define MAXWORK      20                       /* max no of work files
					       * read from spooler
					       * at a time
					       */
#define BUFSIZE 120

#define MAXFULLNAME 120                       /* max no of chars in a
					       * full pathway name
					       */
#define UFILESIZ 15                           /* v7 filename size +1 */

/* various global structures
 */
 
char Rmtname[UFILESIZ];                       /* intended target machine */
char Cprefix[MAXFULLNAME];                    /* workfile prefix */ 
char worknames[MAXWORK][UFILESIZ];            /* internal buffer for
					       * array of workfile names
					       */
int Nojobs;
char destdir[MAXFULLNAME];                    /* name of dir where files
					       * may be moved
                                               */

char ndestdir[MAXFULLNAME];                    /* name of dir where news files
					       * may be moved
                                               */
char target[MAXFULLNAME];                     /*
                                               * space for particular
					       * name for a file to
					       * be moved
					       */
                                                

/* global flags set by input args
 */

int Rflag;             /* remove news files in spool dir */
int aflag;             /* move all files */
int nflag;             /* indicates that target dir for news supplied */
int dirflag;           /* indicates that target dir for non news or
			* for all target files has been supplied
			*/
int sflag;             /* single system has been specified */
int iflag;             /* indicates that we ignore error messages
			* returned by link sys call and copy subroutine
			*/
/*
 *  uucp file convention
 *  structures for C control files
 *  and for X or D*X  execute files
 */


/* this is a dummy structure only and is not
 * actually used - information read into the Dvec
 * and DXvec vectors below will follow this form
 */
  struct work_info {
     char *type;             /* type of work - S or send only
			      * accepted
			      */
     char *spfname;          /* full pathway name of file to send */
     char *destfname;        /* pathway file name on dest machine */
     char *user;             /* who initiated the work - not helpful */
     char *options;          /* options (-m or -d) not used here  */
     char *datafname;        /* name of data file in spool dir    
			      * if null then file not copied - use 
			      * spfname for location
			      */
     int  modebits;          /* mode bits of source file */
  };

/* execute file structure - X prefix or D<machine name>.X prefix
 * this structure is also a dummy structure. Info read into the 
 * EXvec vector below will follow this form
 */

 
struct exec_info {
    char *U_user;            /* user who made request */
    char *U_rmtsys;          /* system from which request originated */
    char *F_fname;           /* filename which is object of action */

    char *F_basename;        /* last part of filename (not used here)*/
    char *I_stdin;           /* standard input for program to execute */
    char *O_stdout;          /* standard output file */
    char *O_sysname;         /* output system */
    char *C_com;             /* command to execute */
    char *C_args;            /* args to command */
};


char *Dvec[10];         /* line 1 from control file  - data file
			 * to be transmitted
			 */
char *DXvec[10];        /* line 2 in control file - for exec file
			 * on remote machine
			 */
char *EXvec[10];        /* actual contents of remote execute
			 * file
			 */

/* defines for the vectors above to allow them to appear as the above
 * structures
 */

#define  DTYPE       Dvec[0] 
#define  DSOURCE     Dvec[1]
#define  DDESTFILE   Dvec[2]
#define  DUSER       Dvec[3]
#define  DOPTIONS    Dvec[4]
#define  DDFNAME     Dvec[5]
#define  DMODEBITS   Dvec[6]

#define  DXTYPE       DXvec[0] 
#define  DXSOURCE     DXvec[1]
#define  DXDESTFILE   DXvec[2]
#define  DXUSER       DXvec[3]
#define  DXOPTIONS    DXvec[4]
#define  DXDFNAME     DXvec[5]
#define  DXMODEBITS   DXvec[6]

#define  U_USER       EXvec[0]
#define  U_RMTSYS     EXvec[1]
#define  F_FNAME      EXvec[2]
#define  F_BASENAME   EXvec[3]
#define  I_STDIN      EXvec[4]
#define  O_STDOUT     EXvec[5]
#define  O_SYSNAME    EXvec[6]
#define  C_COM        EXvec[7]
#define  C_ARGS       EXvec[8]


/*********************************************************
 * STATUS
 * externs and constants
 */
/*
 * return codes
 */
#define DATAONLY    0
#define EXEC        1
#define OFF         0
#define ON          1
#define TRUE        1
#define FALSE       0
#define READ        0
#define WRITE       1
#define APPEND      2
#define SUCCESS     1
#define WORK        1       /* denotes existence of workfiles */
#define NOWORK      0
#define NOFILE      0       /* file cannot be opened     */
#define WDONE       1
#define WNOTDONE    2
#define NOSPOOL     1       /* the workfile is stand alone */
#define NEWS        2       /* the workfile is a news job  */
#define NONNEWS     3       /* the workfile is not a news job */

/* macro for debug
 */
int Debug;
#define CALLS(A,B)   if (Debug) fprintf(stderr,"A: about to call B\n")
