h61191
s 00005/00015/00255
d D 1.3 83/03/23 09:23:49 anna 3 2
c changes date
e
s 00011/00024/00259
d D 1.2 83/02/01 17:29:25 jan 2 1
c change date/time format
e
s 00283/00000/00000
d D 1.1 83/01/21 15:32:08 anna 1 0
e
u
U
t
T
I 1
/*
Name:
	APPACT Calendar System Command

Function:
	Delete an appointment file.

Algorithm:
	Cycle through the /u directory looking for users with appointment
	files for the current date. If found, form the name of the file to
	be deleted using current date and number of expiration days. If
	this file name is found, delete it.

Parameters:
	NONE

Returns:
	ENOERR	Normal Exit
	ENOENT	Bad home directory or no dolist file

Files and Programs:
	user appointments files

Installation Instructions:
	Compile cc -o exec.dir/appact appact.c ../library
	Change owner to root
	Deny write permissions except for owner

History:
	Jan 83, Release 7 Version 2, A. Chang...original version


*/
#include <time.h>
#include <stdio.h>
#include <pwd.h>
#include "../includes/error.h"
#include "../includes/getdef.h"
#include <sys/types.h>
#include <sys/stat.h>

char    date_array[8];                              /* The date in the week for dailycal to start in */
char   *date = date_array;                          /* Points to date */
char    tdate[10];                                  /* Holds default date */
char   *tempdate = tdate;
char    appt_name[12],
       *appt_file = appt_name;
int     tloc[2];                              /* Return from time system call */
int     year;
struct tm *tp;

D 2
char id[] = "@(#)appact.c       1.1 1/21/832";
E 2
I 2
char id[] = "%W% %H%";
E 2

/*

Name:
	main

Function:
	Activate appointment file for the day.

Algorithm:
	Setup appointment file name using todays date.
	Loop through password file getting user home directories.
	For each home directory, if there is an "exec" directory, look
	for "appointments" sub-directory. If found, look for a file matching
	the previously built appointment file name. If found, call do_it to
	form a pathname for a file to be deleted. If this file exists,
	delete it.

Parameters:
	None

Returns:
	ENOERR	Normal exit

Files and Programs:
	None


*/
main( argc, argv, envp)

int argc;
char *argv[];
char **envp;
{
    int     index;
    int     i,
	    mth_num,
	    tempday,
	    jdate;
    char    d[7],
	    *tdate_ptr=d;
    char    days[4],
	    *num=days;
    struct passwd *pw;
    struct passwd *getpwent();
    extern char *cnv_jdate_date();
    extern char *julian_date();

D 2
/*   if (setuid(0) == -1)        {
E 2
I 2
     if (setuid(0) == -1)        {
E 2
	fprintf(stderr, "appact: cannot setuid\n");
	exit();
D 2
    }
*/
E 2
I 2
     }

E 2
      time(tloc);                                 /* Get the current time */
      tp = localtime(tloc);
D 3
      tp->tm_yday += 1;
      year = tp->tm_year;
E 3
      tempdate = copy(itoa(tp->tm_year), tempdate);
D 3
      if (tp->tm_yday < 100) {
	 tp->tm_mon += 1;
	 if (tp->tm_mon < 10)
D 2
	    *tempdate++ = '0';
E 2
I 2
	     *tempdate++ = '0';
E 2
	 tempdate = copy(itoa(tp->tm_mon), tempdate);
	 if (tp->tm_yday < 10)
E 3
I 3
      if (tp->tm_yday < 10)
	 *tempdate++ = '00';
      else
	 if (tp->tm_yday < 100)
E 3
	    *tempdate++ = '0';
D 3
       }
	 tempdate = copy(itoa(tp->tm_yday), tempdate);
E 3
I 3
      tempdate = copy(itoa(tp->tm_yday), tempdate);
E 3
	 if (!valid_date (tdate, date, 1)) {
	    fprintf(stderr, "appact: serious system error in date conversion\n");
	    exit(EFORM);
	 }

    num = atoi(&argv[1][2]);                        /* find the number of days for a file to be expired */
D 3

E 3
    mth_num = which_month(&date_array[2]);          /* converts month to number */
D 3

E 3
    jdate = atoi(julian_date(date, mth_num, year)); /* converts month-day to julian date */
D 3

E 3
    tempday = jdate - num;                          /* difference in julian date */
D 3

E 3
    tdate_ptr = cnv_jdate_date(tempday, year );      /* convert julian date to month_day */

    for (i=0; *(tdate_ptr + i) != '\0'; i++)         /* forms the date to be deleted */
	d[i] = *(tdate_ptr + i);
    strcat(appt_file, "appts.");                     /* forms appointment file name */
    strcat(appt_file, tdate_ptr);
D 3

E 3
    for (index = 0; index < MAXUSERS; index++)
	if ((pw = getpwent()) != NULL)
	       do_it(pw);

    endpwent();
    exit(ENOERR);
}
/*

Name:
	do_it

Function:
	Activate appointment file for the day for a given user.

Algorithm:
	Given a password file structure, change to the home directory and
	check for "exec" subdirectory. If found, changes to it and look
	for "appointments" directory. If found, change to it and look for
	file namematching appt_file. If found, form the name of the file
	to be deleted by subtracting the number of days to be expired from
	the current date. If the file name is found, delete the appointment
	file.

Parameters:
	Password structure from getpwent

Returns:
	ENOERR	Normal exit

Files and Programs:
	appointments files.


*/

do_it(pw)
struct passwd *pw;
{
    int  i;
    char pathname[50],
	 *path_ptr=pathname;
D 2
    struct stat *stat_buf;
    FILE *sfp;
E 2


    path_ptr = pathname;

    for (i=0; *(path_ptr + i) != '\0';i++)      /* initialization of pathname */
	pathname[i] = '';

    if (chdir(pw->pw_dir) == -1)
	return;                                 /* No directory...forget it */
    else {
	 path_ptr = copy(pw->pw_dir, path_ptr);
	 *path_ptr++ = '/';
	 }

    if (chdir("exec") == -1) {
	*path_ptr++ = '\0';
	return;                                 /* Can't access exec */
    }
    else {
	 path_ptr = copy("exec", path_ptr);
	 *path_ptr++ = '/';
	 }

    if (chdir("appointments") == -1)  {         /* no appointments directory */
	*path_ptr++ = '\0';
	return;
    }
D 2
    else
	 path_ptr = copy("appointments", path_ptr);

 /* if (stat(appt_file, stat_buf) == -1)  {   */
    if ((sfp = fopen(appt_file,"r")) == NULL) {   /* no appointment file */
	*path_ptr++ = '\0';
	return;
    }
E 2
    else {
I 2
	 path_ptr = copy("appointments", path_ptr);
E 2
	 *path_ptr++ = '/';
	 path_ptr = copy(appt_name, path_ptr);
	 *path_ptr = '\0';
D 2
	 }
E 2
I 2
    }
E 2


I 2
       if (unlink(appt_file) == -1)
	  return;
       else
	  fprintf(stderr, "appact: successful deletion of an appointment file for %s for %s\n", appt_file, pw->pw_name);
E 2

D 2
  /*  if (stat(appt_file, stat_buf) == -1)  */
      if ((sfp=fopen(appt_file, "r")) == NULL)
	 return;
      else {
	    fclose(sfp);
	    fprintf(stderr, "appact: successful deletion of an appointment file for %s for %s\n", appt_file, pw->pw_name);
	    unlink(appt_file);
      }
E 2
    return;
}

/*
    cnv_jdate_date is a routine which converts julian date to date
    in the form of ddmmm taking in consideration of leap year & non
    leap year.
*/

int non_leap_date[13]={0,31,28,31,30,31,30,31,31,30,31,30,31};
int leap_date[13]={0,31,29,31,30,31,30,31,31,30,31,30,31};
extern *month_name();

char *cnv_jdate_date(jdate, year )
int jdate;
int year;
{

   register int i;              /* index for giving month number */
   static char datebuf[7],      /* stores the date of the file to be deleted */
	       *dptr=datebuf;

   if ((year / 4) * 4 == year && year != 0)   /*  leap year */
   {
      for (i=1;;i++)
	if ((jdate - leap_date[i]) < 0)
	   break;
	else
	   jdate -=  leap_date[i];
   }
   else
   {
				/* not leap year  */
      for (i=1;;i++)
	if ((jdate - non_leap_date[i]) < 0)
	   break;
	else
	   jdate -= non_leap_date[i];
   }
   if (i > 1)      /* for months excluding jan */
      jdate++;

   if (jdate < 10)                /* appends a zero to day */
      *dptr++ = '0';
   dptr = copy(itoa(jdate), dptr);
   copy(month_name(i), dptr);     /* append month to day */
   return(datebuf);               /* return the date of the file to be deleted */
}
E 1
