h45410
s 00017/00016/00206
d D 1.2 83/05/12 15:11:27 jan 2 1
c USENIX Distribution version
e
s 00222/00000/00000
d D 1.1 82/10/06 12:23:41 jan 1 0
e
u
U
t
T
I 1
/*
Name:
	DOLIST Calendar System Command

Function:
	Give a numbered listing of a list file

Algorithm:
	Output each line in the list file preceded by its line number in the
D 2
	list file
E 2
I 2
	list file..separate fields with
E 2

Parameters:
	User supplied list file  -  default is file name in $HOME/exec/dolist/default
	Authorized user  -  default is self

Returns:
	ENOERR	Normal Exit
	ENOENT	Bad home directory or no dolist file

Files and Programs:
	user supplied file              the list file
	/BIN/SORT                       used to sort the list items

Installation Instructions:
	Compile cc -o exec.dir/dolist dolist.c ../library
	Change owner to root
	Deny write permissions except for owner

History:
	Oct 79, Release 1 Version 1, G. Maltagliati, coded in shell
	Nov 80, Release 5 Version 1, G. Maltagliati, coded in C for efficiency
	July 82, Release 7 Version 1, L. Reed for Perkin-Elmer
	Aug 82, Release 7 Version 2, J. Neyer...rewrite exec support


*/
#include <stdio.h>
#include <pwd.h>
#include "../includes/error.h"
#include "../includes/getdef.h"
#include <sys/types.h>
#include <sys/stat.h>
#define USAGE "Usage: dolist <list_file> <auth_user>\n"
#define USERINVL "dolist: Invalid userid\n"
#define NOTAUTH "dolist: You are not an authorized user\n"
#define FILERR "dolist: Cannot find list file %s\n"

char    cmd_buf[CMDLEN],                        /* Command buffer for system command */
       *command = cmd_buf;

char id [] = "%W% %H%";

/*

Name:
	main

Function:
	Parse user parameters. Open list file. Sort the list file.
	Prepend item numbers then format and display list using
D 2
	tabscan.
E 2
I 2
	$DISPWIN.
E 2

Algorithm:
	Check the number of parameters.Call "setup" to open the list file.
	Call sort to sort the list file, thereby accomplishing prioritization
D 2
	due to lexicographical sort of "*" priority specifiers. Call tabscan
E 2
I 2
	due to lexicographical sort of "*" priority specifiers. Call dispwin
E 2
	to format and process list.

Parameters:
	list file name    (optional)
	user id (optional)

Returns:
	ENOERR	Normal exit
	ENOENT	Bad home directory or no dolist file

Files and Programs:
	/bin/sort               Unix sort routine
D 2
	/usr/tabstar/tabscan    Tabstar formatter

E 2
I 2
	$DISPWIN                Environment variable defining the dolist
				window display program
E 2

*/
main( argc, argv, envp)

int argc;
char *argv[];
char **envp;
{
    char listfile[CMDLEN];
    char *lfile, *date;                                 /* List file and dummy date pointer */
    char *line;                                         /* Points to input lines */
    struct passwd *user;                                /* Pointer to passwd struct for user */
    FILE *fp;                                           /* List file pointer */

    parse(argc, argv, envp, &date, &user, &lfile);
    if (!user)
	user = getpwnam(findenv("USER", envp));
    if ((chdir(user->pw_dir)) == -1)      {
	fprintf(stderr, "dolist: cannot access directory %s\n", user->pw_dir);
	exit (EACCES);
    }
    if (!authuser())      {
	fprintf(stderr, NOTAUTH);
	exit(EFORM);
    }
    if (lfile == NULL)  {                               /* Try to get default file */
	lfile = listfile;
	strcat (lfile, DEFAULT);
	if ((fp = fopen(lfile, "r")) == NULL)   {       /* Try to open default */
	    fprintf (stderr, "dolist: cannot open default file %s\n", lfile);
	    exit (EACCES);
	}
	line = getline(fp);
	strcpy(lfile, line);
	fclose(fp);
    }
    if ((fp = fopen(lfile, "r")) == NULL)   {         /* Open the list file */
	fprintf (stderr, "dolist: cannot open list file %s\n", lfile);
	exit(EACCES);
    }
    sort(lfile);                                      /* Sort the list file */
D 2
    tabscan(fp);                                  /* Format and display the list */
E 2
I 2
    dispwin(fp);                                  /* Format and display the list */
E 2
    fclose(fp);
    exit(ENOERR);
}
/*

Name:
	sort

Function:
	Sort the file given

Algorithm:
	Use the UNIX command sort to sort the file given placing the output
	back in the file given

Parameters:
	file	the name of the file to be sorted

Returns:
	None

Files and Programs:
	/BIN/SORT	used to sort the file


*/
sort (file)
char   *file;						/* Name of the file to be sorted */
{

    sprintf(command, "sort -o  %s %s", file, file);
    system(command);
}
/*

Name:
D 2
	tabscan
E 2
I 2
	dispwin
E 2

Function:
D 2
	Format list file using Tabstar.
E 2
I 2
	Format dolist file using the table/window display program
	defined by the environment variable $DISPWIN
E 2

Algorithm:
D 2
	Open a pipe to TABSCAN. Output the header. Output each list item
	prepended with a line number. Wait for tabscan to exit.
E 2
I 2
	Open a pipe to $DISPWIN. Output the header. Output each list item
	prepended with a line number. Wait for $DISPWIN to exit.
E 2

Parameters:
	file    pointer to file structure to be tabscan'd
	envp    environment pointer

Returns:
	None

Files and Programs:
D 2
	/usr/tabstar/tabscan    used to firmat and display list

E 2
I 2
	$DISPWIN        environment variale defining window/table display
			program
E 2

*/
D 2
tabscan(fp)
E 2
I 2
dispwin(fp)
E 2
FILE *fp;

#define READ 0
#define WRITE 1
#define LINELEN 256

{
    register int    curr_item = 1;              /* Item number to prepend to stream */
    char buffer[LINELEN];                       /* Line buffer */
    char *line = buffer;
    int p[2], popen_pid;
    FILE *pfp;

    if (pipe(p) < 0)    {                       /* Get a pipe */
	fprintf(stderr, "dolist: cannot open pipe\n");
	exit(EPIPE);
    }
    if ((popen_pid = fork()) == 0 )     {
	close (p[WRITE]);                       /* CHILD */
	close (READ);
	dup (p[READ]);
	close (p[READ]);
D 2
	execl (TABSCAN, "tabscan", "-", 0);
	fprintf(stderr, "dolist: cannot exec %s\n", TABSCAN);
E 2
I 2
	execl (getenv("DISPWIN"),"dispwin", "-", 0);
	fprintf(stderr, "dolist: cannot exec %s\n", getenv("DISPWIN"));
E 2
	exit(EEXEC);
    }
    if (popen_pid == -1)        {               /* PARENT */
	fprintf(stderr, "dolist: cannot fork\n");
	exit (EFORK);
    }
    pfp = fdopen(p[WRITE], "w");
    fputs(DOLIST, pfp);                         /* Write out header */
    while (fgets (line, LINELEN, fp))       {   /* Loop start */
D 2
	fputs((itoa(curr_item++)), pfp);        /* Number item */
E 2
I 2
	fputs((itoa(curr_item++, 0)), pfp);        /* Number item */
E 2
	fputc(FIELDCHAR, pfp);
	fputs (line, pfp);                      /* Rest of line */
    }
    fclose(pfp);
    wait(0);
    return;
}

E 1
