h63816
s 00001/00001/00417
d D 1.2 83/05/12 15:12:14 jan 2 1
c USENIX Distribution version
e
s 00418/00000/00000
d D 1.1 82/10/06 15:00:28 jan 1 0
e
u
U
t
T
I 1
#
/*
Name:
	TODAYCAL Calendar System Command

Function:
	Output a user's daily and monthly calendar

Algorithm:
	Execute dailycal and monthcal putting the output from each in separate
	files. Output the first page from the dailycal file, and then the two
	pages from the monthcal output file. If another page exists in the
	dailycal file, then output it.

Parameters:
	date		the date for which monthcal and dailycal are desired
	userid		calendar user's userid
	5 or 7		specifies a five or seven day calendar

Returns:
	ENOERR	Normal exit
	ENOENT	Bad home directory or cannot open the daily and monthly 
		calendar files.
	EACCES	Not an authorized user
	EFORM	Bad date format or incorrect number of arguments
	EINVAL	Invalid argument for 5 or 7 day calendar or invalid userid
	ENOEXEC	Cannot execute sort, dailycal or monthcal
	EPIPE	Cannot create pipe

Files and Programs:
	$EXECDIR/dailycal		the dailycal command
	$EXECDIR/monthcal		the monthcal command

Installation Instructions:
	Put in /usr/bin/exec.dir/todaycal
	Change owner to root
	Deny write permissions except for owner

History:
	Oct 79,	Release 1 Version 1, G. Maltagliati, coded in shell
	Sep 80,	Release 4 Version 1, Sgt T. Irish, added code for 5 and 7 day flag
	Nov 80,	Release 5 Version 1, G. Maltagliati, coded in C for efficiency
	Jul 82, Release 7, Version 1, L Reed for Perkin-Elmer


*/
#include <stdio.h>
#include <pwd.h>	/* /etc/passwd data */
#include "../includes/error.h"
#include "../includes/getdef.h"
#define AUTHUSER "exec/auth.inputters"
#define PLUS "+"
#define PAGEHDR " page "
#define NEWLINE2 "\n\n"
char   *execdir;	/* the $EXECDIR from the environment */

char id[] = "%W% %H%";

/*

Name:
	main

Function:
	Perform error checking on the arguments and direct the execution
	of the programs to create and output the daily and monthly calendar

Algorithm:
	Insure that the correct number of arguments were entered. If only
	one argument was entered (just the command name), then get today's
	date. Otherwise, check the validity of the date entered on the command
	line. Now if only one or two arguments were entered, then get the user
	information for the person logged in. Otherwise, get the user information
	for the userid entered on the command line. If a userid was entered 
	on the command line, then check to make sure the person logged on is 
	an authorized user. If a five or seven day calendar is also specified
	on the command line, then check to make sure a five or seven was entered.
	Create the name of an output file for dailycal and monthcal and call
	execute to execute both the programs. Finally call printcal to output
	the daily and monthly calendar.

Parameters:
	date		the date for which monthcal and dailycal are desired
	userid		calendar user's userid
	5 or 7		specifies a five or seven day calendar

Returns:
	ENOERR	Normal exit
	ENOENT	Bad home directory
	EACCES	Not an authorized user
	EFORM	Bad date format or incorrect number of arguments
	EINVAL	Invalid argument for 5 or 7 day calendar or invalid userid

Files and Programs:
	None


*/
main (argc, argv, envp)
int     argc;						/* Number of arguments */
char   *argv[];						/* Pointer to arguments */
char   **envp;		/* environment */
{
    int     tvec[2];					/* Time vector */
    char  **time_ptr,					/* Pointer to information about current date */
            daily_file[25],				/* Output file for dailycal */
            monthly_file[25],				/* Output file for monthcal */
            date[8],					/* Calendar date */
            userid[9],					/* Calendar user's userid */
            flag[1];					/* Day flag */
    struct passwd *pw;		/* /etc/passwd data */

    execdir = findenv("EXECDIR", envp);		/* calander programs are there */
    copy ("5", flag);
    if (argc > 4)					/* Check for invalid number of arguments */
    {
	printf ("too many arguments\n");
	exit (EFORM);
    }
    if (argc == 1)
    {
	time (tvec);					/* Retrieves time */
	time_ptr = localtime (tvec);			/* Changes time to current date */
D 2
	copy (itoa (time_ptr[3]), date);                /* Put current_day in date */
E 2
I 2
	copy (itoa (time_ptr[3],0), date);                /* Put current_day in date */
E 2
	copy (month_name (time_ptr[4] + 1), &date[2]);  /* Put current_month on end of date */
    }
    else
    {
	if (!valid_date (argv[1], date, 0))		/* Check for valid date */
	{
	    printf ("invalid or missing date\n");
	    exit (EFORM);
	}
    }
    if (argc <= 2)
    {
	if (chdir(findenv("HOME", envp)))	/* go to $HOME */
	{
	    printf ("bad HOME directory\n");
	    exit (ENOENT);
	}
    }
    else
    {
	if ((pw = getpwnam(argv[2])) == NULL)
	{
	    printf ("today.cal : invalid userid\n");
	    exit (EINVAL);
	}
	if (chdir (pw->pw_dir))		/* go to user's home */
	{
	    printf ("bad directory %s\n", pw->pw_dir);
	    exit (ENOENT);
	}
	if (!authuser ())				/* Check if not an authorized user */
	{
	    printf ("%s not an authorized user\n", argv[3]);
	    exit (EACCES);
	}
	if (argc == 4)
	{
	    if (strcmp (argv[3], "5") && !!strcmp (argv[3], "7"))
							/* Check for valid argument */
	    {
		printf ("invalid argument %s\n", argv[3]);
		exit (EINVAL);
	    }
	    if (!strcmp (argv[3], "7"))
		copy ("7", flag);
	}
    }
/* Create the name of the output files */
    copy (mktemp ("/tmp/todayaXXXXX"), daily_file);
    copy (daily_file, monthly_file);
    monthly_file[10] = 'b';
    execute ('c', date, pw->pw_name, flag, daily_file);    /* Execute dailycal */
    execute ('m', date, pw->pw_name, flag, monthly_file);  /* Execute monthcal */
    print_cal (daily_file, monthly_file, userid);       /* Output the daily and monthly calendar */
    unlink (daily_file);				/* Remove the output files */
    unlink (monthly_file);
    exit (ENOERR);
}
/*

Name:
	execute

Function:
	Place the output from dailycal or monthcal to a file

Algorithm:
	Create a pipe making the first part of the pipe standard input
	and the second part standard output. Execute the command, sending the
	output through the pipe. Have the parent read the pipe into a buffer
	and then output the buffer to the file given.
	The child will get the command from the proper directory.

Parameters:
	command		'm' for monthcal; 'd' for dailycal
	date		the date for monthcal or dailycal
	userid		the calendar user's userid
	five_seven	specifies whether a 5 or 7 day monthly calendar
	file		the name of the output file

Returns:
	ENOENT	Cannot create output file
	EPIPE	Cannot create pipe
	ENOEXEC	Cannot execute the command


*/
execute (command, date, userid, five_seven, file)
char   command,					/* The command to be executed */
       *date,						/* The date for dailycal or monthcal */
       *userid,						/* Calendar user's userid */
       *five_seven,					/* Specifies whether a five or seven day calendar is desired */
       *file;						/* Output file */
{
    int     pipefd[2],					/* Pipe file descriptors */
            fd,						/* File descriptor for output file */
            num_chars,					/* Number of characters read into the buffer */
            pid;					/* Process id */
    char    buffer[512];				/* Output buffer */

    if ((fd = creat (file, 0666)) == -1)		/* Create the output file */
    {
	printf ("todaycal: cannot open %s\n", file);
	exit (ENOENT);
    }
    if (pipe (pipefd) == -1)				/* Create the pipe */
    {
	printf ("todaycal: cannot create pipe.\n");
	exit (EPIPE);
    }
    while ((pid = fork ()) == -1);			/* Spawn off a new process */
    if (pid)
    {							/* * Parent * */
	close (0);
	dup (pipefd[0]);				/* make pipe standard input */
	close (pipefd[1]);
	while (num_chars = read (pipefd[0], buffer, 512))
	    write (fd, buffer, num_chars);
	close (pipefd[0]);
	close (fd);
	while (wait (0) != pid);				/* Wait for the child process to finish */
    }
    else
    {							/* * Child * */
	close (1);
	dup (pipefd[1]);				/* make pipe standard output */
	close (pipefd[0]);
	if (chdir(execdir) == 0)
		if (command = 'm')	/* monthcal */
		    execl ("monthcal", "monthcal", date, five_seven, PLUS, 0);
								/* Execute monthcal */
		else
		    execl ("dailycal", "dailycal", date, userid, PLUS, 0);/* Execute dailycal */
	printf ("todaycal: unable to execute command\n");
	exit (ENOEXEC);
    }
}
/*

Name:
	print_cal

Function:
	Output the users daily and monthly calendar

Algorithm:

	Output the first 66 lines from the daily calendar file.
	For each of the two pages of the monthly calendar file, output a page
	number and then the next 64 lines on that page so as to make the page
	66 lines in length. Now if any lines remain in the daily file, output
	a page number and then the next 64 lines of the file.

Parameters:
	daily_file	the daily calendar file
	monthly_file	the monthly calendar file
	userid		the calendar user's userid

Returns:
	ENOENT	Cannot open the daily or monthly calendar file

Files and Programs:
	/tmp/(daily_file)	the daily calendar file
	/tmp/(monthly_file)	the monthly calendar file


*/
print_cal (daily_file, monthly_file, userid)
char   *daily_file,					/* The daily calendar file */
       *monthly_file,					/* The monthly calendar file */
       *userid;						/* The calendar user's userid */
{
    register int    page_count = 2,			/* Page counter */
                    i,					/* Loop counter */
                    j;					/* Loop counter */
    char    page_buf[25],				/* Header for pages 2 and greater */
           *buf_ptr,					/* Pointer to page_buf */
            line[256],					/* Holds a line for output */
           *line_ptr,					/* Pointer to line */
           *temp_ptr;					/* Temporary pointer to page_buf */
    FILE   *fp1, *fp2;


    buf_ptr = copy (userid, page_buf);			/* Create the page header */
    buf_ptr = copy (PAGEHDR, buf_ptr);
    if (( fp1 = fopen(daily_file, "r")) == NULL)
    {
	printf ("todaycal: cannot open %s\n", daily_file);
	exit (ENOENT);
    }
    if ((fp2 = fopen(monthly_file, "r")) == NULL)
    {
	printf ("todaycal: cannot open %s\n", monthly_file);
	exit (ENOENT);
    }
    for (i = 1; i <= 66; i++)				/* Output the first 66 lines from the daily file */
    {
	line_ptr = copy (getline (fp1), line);
	*line_ptr++ = '\n';
	*line_ptr = '\0';
	write (1, line, strlen (line));
    }
    for (i = 1; i <= 2; i++)				/* Do the following for each of the 2 pages in the monthly file */
    {
	temp_ptr = copy (ascii_number (page_count++), buf_ptr);
	copy (NEWLINE2, temp_ptr);
	write (1, page_buf, strlen (page_buf));
	for (j = 1; j <= 64; j++)			/* Output 64 lines from the monthly file */
	{
	    line_ptr = copy (getline (fp2), line);
	    *line_ptr++ = '\n';
	    *line_ptr = '\0';
	    write (1, line, strlen (line));
	}
	getline (fp2);				/* Skip the next two lines */
	getline (fp2);
    }
    if (line_ptr = getline (fp1))
    {							/* There are still some lines in the daily file */
	temp_ptr = copy (ascii_number (page_count++), buf_ptr);
	copy (NEWLINE2, temp_ptr);
	write (1, page_buf, strlen (page_buf));
	for (i = 1; i <= 64; i++)			/* Output the next 64 lines from the daily file */
	{
	    line_ptr = copy (line_ptr, line);
	    *line_ptr++ = '\n';
	    *line_ptr = '\0';
	    write (1, line, strlen (line));
	    line_ptr = getline (fp1);
	}
    }
    fclose (fp1);
    fclose (fp2);
}
/*

Name:
	ascii_number

Function:
	Convert an integer to an ascii string

Algorithm:
	Start in the 10**4 position and work down until the first digit is
	found. From then on add an ascii '0' to the character in each position
	and place in a character array until the 10**0 position is reached.

Parameters:
	num	the integer to be converted to ascii

Returns:
	A pointer to the beginning of the character array

Files and Programs:
	None


*/
ascii_number (num)
int     num;						/* The number to be converted to an  ascii string */
{
    static char ascii[6];				/* The character string where the ascii number is stored */
    register int    i = 0,				/* An index into ascii */
                    flag = 0;				/* Indicates if the first digit of the number has been reached */


    if (num / 10000 != 0)
    {
	flag = 1;
	ascii[i++] = num / 10000 + '0';
	num - = num / 10000 * 10000;
    }
    if (num / 1000 != 0 || flag == 1)
    {
	flag = 1;
	ascii[i++] = num / 1000 + '0';
	num - = num / 1000 * 1000;
    }
    if (num / 100 != 0 || flag == 1)
    {
	flag = 1;
	ascii[i++] = num / 100 + '0';
	num - = num / 100 * 100;
    }
    if (num / 10 != 0 || flag == 1)
    {
	flag = 1;
	ascii[i++] = num / 10 + '0';
	num - = num / 10 * 10;
    }
    ascii[i++] = num + '0';
    ascii[i] = '\0';
    return (ascii);
}
E 1
