h30376
s 00060/00000/00000
d D 1.1 82/10/06 14:28:25 jan 1 0
e
u
U
t
T
I 1
/*
Name:
	authuser

Function:
	Determine if the user running is authorized by the
	target user.

Parameters:
	None

Algorithm:
	Get current user's name by running getlogin and getpwent.
	Then search the file AUTH file for the name.  If it exists,
	return 1, else return 0.

Assumptions:
	The current directory must be the target user's home directory.

History:
	Written Jul 82 by L. Reed, since was referenced but not
	included by ASAF software.

*/
#include <stdio.h>
#include "../../includes/error.h"
#include <pwd.h>
#define AUTH "exec/auth.inputters"
#define NOFILE "Could not access authorized users file\n"


authuser()
{

	static char id[] = "%W% %H%";
	register char *line, *name;
	FILE *fp;
	struct passwd *pw;
	extern char *getlogin(),*getuid();
	extern struct passwd *getpwuid();
	extern char *getline();

	if (( name = getlogin()) == NULL)
		if (pw = getpwuid(getuid()))
			name = pw->pw_name;
		else
			return (0);
	if ((fp = fopen(AUTH, "r")) == NULL) {
		fprintf(stderr, NOFILE);
		return(0);
	}
	while (line = getline(fp))  {
		if ((strcmp(name, line)) == 0)  {
			fclose(fp);
			return(1);
		}
	}
	fclose (fp);
	return(0);
}
E 1
