/* defines, structures, etc for the formatted data entry system
 * by David E. Miran,  Wisconsin State Lab of Hygiene
 * 11/20/80
 */

#define		LCASE	01	/* preserve lower case for this field */
#define		NUMERIC	02	/* field must be numeric */
#define		ALPHA	04	/* field must be alphabetic */
#define		REQUIRED 010	/* field must be filled in */
#define		DATE	020	/* field contains a date */
#define		LABNUM	040	/* field contains a lab number */
#define		PNAME	0100	/* field contains a patient name */
#define		DNAME	0200	/* field contains a doctor's name */
#define		CITY	0400	/* field contains a city name */
#define		RANGE	01000	/* range checking required for this field */

/* field letter codes for setting up a format are as follows
	L	LCASE
	9	NUMERIC
	R	REQUIRED
	A	ALPHA
	D	DATE
	N	LABNUM
	P	PATIENT NAME (PNAME)
	H	DOCTOR'S NAME (DNAME)
	C	CITY
	X	RANGE CHECKING
 */

struct fdef	{	/* format data field descriptor */
		int	f_size;		/* field size */
		int	f_lims;		/* pointer to range limit pair */
		int	f_flags;	/* field modifier flags */
		int	f_pos;		/* starting char pos of this field */
		};

/*  *********  arbitrary sizes and constants  *********  */

#define	MAXFLD	300		/* max number of fields in a format */
#define	SCRSIZE	2048		/* max screen input size (also a buffer size) */
#define	MAXRSIZE 2400		/* max input record size times 2 */
#define	BUFSIZE	512		/* ordinary buffer size */
#define	PAGELEN	24		/* lines per page (crt screen) */
#define	HIPRI	-100		/* very high priority */
#define	LOPRI	0
#define	RMODE	0340		/* raw mode, anyp */
#define	IMODE	0100340		/* block, raw, anyp */
#define	NMODE	0300		/* normal mode, anyp, no scroll */
#define	ETX	03		/* end of transmission */
#define	IBSIZE	50		/* terminal input blocking factor */
#define	MAXREC	2048		/* maximum compressed record size */
