/*
 *	keyset [-t text] ... [keyfile] ...
 *	ckeyset [-s] [-w] [-t text] ... [keyfile] ...
 * program the function keys of a teleray model 10 or HDS concept 108 terminal
 * key 1 is the xmit (on the teleray), key 8 is the current date (mmddyy)
 * other keys are programmed according to the file KEYTEXT or CKEYTEXT for the concept 108
 * which is a compiled file with entries as follows:
 *	for each key
 *	char k2[]  "02";	 program key 2 
 *	char k2a[] "line of text";
 *	'#" in line of text will be replaced by current date.
 *	char k2b[] "more text - last line of text ends with \0\0\0";
 *	 repeat as above for each key.
 * by David E. Miran and William J. Kurth
 * 3/8/83
 */

#include	<myio.h>
#define	RMODE	0340

long	atime;
char *chtime, date[8];
extern char *ctime();
char *keyfile;
char *cls "\014\0\0\0";
int	cls_l	4;
struct fbuf ibf, obf;
char *mname[] {
	"Jan", "Feb", "Mar", "Apr", "May", "Jun",
	"Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
	};
char *mnum[] {
	"01", "02", "03", "04", "05", "06",
	"07", "08", "09", "10", "11", "12"
	};

char	nkey[2], text[1500];

int	ttyorig[3], ttyraw[3];
int nullcnt;
int fid;
int	cmode	0;		/* set if concept 108 terminal */
char	ktab[]	"56789:;<=>?@AB%&'()*+,-./CDE";  /* key code table */

int	kmode	0;	/* set if actual key number is in gkey */
int	gkey	0;

char	*kt[]	{	/* text to program keys with (default) */
		"",	/* key 0 */
		"",	/* key 1 */
		"",	/* key 2 */
		"",	/* key 3 */
		"",	/* key 4 */
		"",	/* key 5 */
		"",	/* key 6 */
		"",	/* key 7 */
		"",	/* key 8 */
		"",	/* key 9 */
		"",	/* key 10 */
		"",	/* key 11 */
		"\033?\t",	/* key 12 - format home */
		"\t",	/* key 13 - tab */
		"",	/* key 14 */
		"\033U\033v  8p\033V \033f\033u",	/* key 15 - select window 1 */
		"\033U\033v8 8p\033V8\033F\033u",	/* key 16 - select window 2 */
		"\033U\033vP 8p\033VP\033F\033u",	/* key 17 - select window 3 */
		"\033U\033vh 8p\033Vh\033F\033u",	/* key 18 - select window 4 */
		"\033U\033v\001  8p\033V\001 \033F\033u",	/* key 19 - select window 5 */
		"\033U\033v\0018 8p\033V\0018\033F\033u",	/* key 20 - select window 6 */
		"\033U\033v\001P 8p\033V\001P\033F\033u",	/* key 21 - select window 7 */
		"\033U\033v\001h 8p\033V\001h\033F\033u",	/* key 22 - select window 8 */
		"",	/* key 23 */
		"",	/* key 24 */
		"",	/* key 25 */
		"\033?\t\033 #",	/* key 26 - format home and clear */
		"\033?\033>\033'",	/* key 27 - last field */
		"",	/* key 28 */
		0};
char	*progname;

int	ktl[]	{  /* char counts for std keys.  -1 means do NOT clear */
		0, 0, 0, 0, 0, 0, 0, 0,   /* keys 0 (dummy) - 7 */
		-1, 0, -1, -1, 3, 1, -1,  /* keys 8 - 14 */
		15, 15, 15, 15, 17, 17, 17, 17, /* window keys 15-22 */
		-1, -1, -1, 6, 6, -1,    /* keys 23-28 */
		0};

main(argc, argv)
int argc;
char **argv;
{
register int i;
char c;
int st, z;

	keyfile = "KEYTEXT";
	progname = *argv;
	if (strcmp(progname,"ckeyset") == 0) {
		cmode = 1;
		keyfile = "CKEYTEXT";
	}
	st = 0;
	gtty(1,ttyorig);
	ttyraw[0] = ttyorig[0];
	ttyraw[1] = ttyorig[1];
	ttyraw[2] = RMODE;
	stty(1,ttyraw);
	if (cmode) {
		write(1,"\033U", 2);  /* programming mode */
	} else {
		write(1, "\014\0\0\0\0", 5);
		sleep(2);
		write(1, "\033e", 2); /* disable display */
	}
	mfinit(&obf, 1);
	if (!cmode) {
		setkey("01", "\033i", 2);
		mflush(&obf);
		sleep(1);
	}
	time(&atime);
	chtime = ctime(&atime);
	for (i=0; i<12; i++) {
		if (strncmp(&chtime[4], mname[i], 3) == 0) {
			strncpy(date, mnum[i], 2);
			break;
		}
	}
	strncpy(&date[2], &chtime[8], 2);
	strncpy(&date[4], &chtime[22], 2);
	for (i=0; i<6; i++) {
		if (date[i] == ' ') date[i] = '0';
	}
	setkey("08", date, 6);
/* process arguments - if none process default keyfile (if any) and quit */

	if (argc <= 1) {
		dofile(keyfile);
		goto done;
	}
	while (--argc) {
		++argv;
		if (**argv == '-') {	/* option mode processing */
			if (strcmp(*argv,"-t") == 0) {
				--argc;
				++argv;
				i = strlen(*argv);
				if (i == 0) continue;
				if (!cmode)
					if (strncmp(argv[0],"01",2) == 0) continue; /* do not do f1 on teleray */
				setkey(argv[0],&argv[0][2],i-2);
				continue;
			}
			if (strcmp(*argv, "-w") == 0) {  /* concept windowns */
				if (!cmode) continue;
				for (i=15; i<=22; i++) skey(i);
				continue;
			}
			if (strcmp(*argv, "-s") == 0) {  /* concept standard keys */
				if (!cmode) continue;
				for (i=1; i<10; i++)
					if (ktl[i] == 0) zkey(i);
				for (i=10; i<15; i++)
					if (ktl[i] > 0) skey(i);
				for (i=26; i<28; i++)
					if (ktl[i] > 0) skey(i);
				continue;
			}
		}  /* end of option mode processing */
		dofile(*argv);
	}	/* end of while loop */
done:
	mflush(&obf);
	if (fid > -1) close(fid);
	if (cmode) {
		write(1, "\033u", 2);  /* user mode */
	}  else {
		write(1, "\033f", 2); /* enable display */
		sleep(2);
	}
	stty(1,ttyorig);
	exit(0);
}
setkey(key, string, stringl)
char *key, *string;
int stringl;
{
int	knum;
int	len;

	if (cmode) {
		mputrec("\0334",2,&obf);	/* start definition */
		/* compute char equivalent of length */
		len = stringl;
		if (len > 95)
			mput(len/96, &obf);
		mput(len%96+32, &obf);
		if (kmode)
			knum = gkey - 1;
		else
			knum = atoi(key)-1;
		mput(ktab[knum], &obf);	/* specify which key */
		mput('#',&obf);	/* execute mode */
		mputrec(string,stringl, &obf);
	} else {
		mputrec("\033U", 2, &obf);	/* start definition */
		mputrec(key, 2, &obf);		/* key number */
		mputrec(string, stringl, &obf);	/* text */
		mputrec("\033V", 2, &obf);	/* end definition */
	}
}
zkey(z)
int z;
{
	kmode = 1;
	gkey = z;
	setkey("  ","", 0);
	kmode = 0;
}
skey(z)
int z;
{
	kmode = 1;
	gkey = z;
	setkey("  ",kt[z], ktl[z]);
	kmode = 0;
}

dofile(f)
char *f;
{
register int i, z;
register char c;
fil:
	if ((fid = open(f, 0)) <0) goto fdone;
	seek(fid, 16, 0);
	mfinit(&ibf, fid);

lp:
	c = mget(&ibf);
	if (ibf.nrd < 1) goto fdone;
	if (c == '\0') goto lp;
	nkey[0] = c;
	nkey[1] = mget(&ibf);
	if (ibf.nrd < 1) goto fdone;
	i = 0;
	nullcnt = 0;
lp2:
	c = mget(&ibf);
	if (ibf.nrd < 1) goto setit;
	if (c == 0) {
		if (i == 0) goto lp2;	/* gap */
		if (nullcnt++ >1) goto setit;
		goto lp2;
	}
	if (c == '\\')  {
	c = mget(&ibf);
	goto  charx;
	}
	if (c == '#') {
		z = 0;
		while (z <= 5) {
			text[i++] = date[z++];
		}
	nullcnt = 0;
	goto lp2;
	}
charx:
	text[i++] = c;
	nullcnt = 0;	/* not 3 in a row */
	goto lp2;
setit:
	if (i>0) setkey(nkey, text, i);
	if (ibf.nrd > 0) goto lp;
fdone:
	close(fid);
}
