/*
 * recovri inode filesystem newfilename
 * filesystem must be a normal file or block-type special file. This is   checked.
 * the file described by inode on the filesystem will be copied to newfile
 * with the modes of the original file.
 * by David E. Miran
 * September 4, 1981
 */

#include "/usr/sys/hd/ino.h"			/* get disk inode structure */
#include <stdio.h>

struct inode	i_node;

struct {
	char	minor;				/* minor device of file	*/
	char	major;				/* major device of file	*/
	int	inumber;
	int	flags;
	char	nlinks;
	char	uid;
	char	gid;
	char	size0;
	int	size1;
	int	addr[8];
	int	actime[2];
	int	modtime[2];
}	statnode;				/* to get file status */


#define BLOCK	060000				/* BLOCK-type flags */


unsigned low, high, cmode, bnum, iblk[256];
int ofid, bcnt, blk[256];
long nsize;
int	file, inum;

main(argc,argv)
int	argc;
char	*argv[];
{
register int i, j;
  int	isize, flag;

	if (argc != 4) {
		printf("Usage:  %s inode filesystem newfile\n",argv[0]);
		exit(0);
	}

	/*
	 * see if device is block special file or normal file.
	 */

	stat(argv[2],&statnode);	/* get device (file) status */
	if ((flag = (statnode.flags&BLOCK)) && flag != BLOCK) {
		printf("Device must be normal or block-type special file.\n");
		exit(0);
	}

	if ((file=open(argv[2],0)) < 0) {
		printf("can't open %s.\n",argv[2]);
		exit(0);
	}

	/*
	 * see if inode number is legal.
	 */

	seek(file,1,3);		/* point at block 1 */
	read(file,&isize,2);	/* read isize from superblock */

	inum = getdec(argv[1]);

	/*
	 * check if inode number is legal.
	 */

	if (inum <= 0 || inum > 16 * isize) {
		printf("Bad inumber: %d\n",inum);
		exit(1);
	}

	/*
	 * point at inode and recover.
	 */

	seek(file,(inum+31)/16,3);	/* point at block of inode */
	seek(file,32*((inum+31)%16),1);	/* point at inode in block */
	read(file,&i_node,sizeof i_node);	/* read inode */

	cmode = i_node.i_mode & 07777;
	low = 595;  /*  normally isize if superblock is intact */
	high = 59296;  /* normally 62535 */
	bcnt = 0;
	ofid = creat(argv[3],cmode);
	if (ofid < 0) {
		printf("cannot create newfile %s\n",argv[3]);
		exit(1);
	}
	if (i_node.i_mode & ILARG) goto large;
	for (i=0; i<8; i++) {
		if (i_node.i_addr[i] == 0) break;
		bcopy(i_node.i_addr[i]);
	}
	goto done;

large:
	/* process large files with indirect blocks */
	for (i=0; i<8; i++) {
		bnum = i_node.i_addr[i];
		if (bnum == 0) break;
		if ((bnum <= low) || (bnum >= high)) {
			printf("invalid indirect block = %u or %o octal\n",bnum, bnum);
			exit(1);
		}
		bread(bnum, iblk);
		for(j=0; j<256; j++) {
			if (iblk[j] == 0) goto done;
			bcopy(iblk[j]);
		}
	}

done:
	close(ofid);
	nsize = (long) bcnt * 512L;
	printf("Inode %d recovered as file %s - %d blocks = %D characters\n",inum, argv[3],bcnt, nsize);
	exit(0);
}

/*
 * get a decumal number. argument is a string. on error, message is printed
 * and exit.
 */

getdec(string)
char	*string;
{
  register char	*p, c;
  register int	num;

	p = string;
	num = 0;
	while(c = *p++)
		if (c >= '0' && c <= '9') {
			num =* 10;
			num =+ c - '0';
		} else {
			printf("Bad number %s\n",string);
			exit(0);
		}
	return(num);
}

bread(b,loc)
unsigned b;
int loc[];
{
	seek(file, b, 3);
	read(file, loc, 512);
}

bcopy(b)
unsigned b;
{
	if ((b <= low) || (b >= high)) {
		printf("invalid block number = %u or %o octal\n",b, b);
		exit(1);
	}
	bread(b, blk);
	write(ofid, blk, 512);
	bcnt++;
}
