#
/*
 * keyin  action  [device  [detail] ]
 * program to generate keyins for the rje package and the kick the
 * sender part of the rje communications package.
 *
 * By:   David E. Miran
 *       Wisconsin State Hygiene Lab
 *
 * April 23, 1981
 */

#include	<stdio.h>
#include	"../ntr/rjedef.h"
#include	"../ntr/rjefiles.h"

#define		NMSG	18	/* number of different keyins */
#define		NDEV	11	/* number of different devices */
#define		NSAFE	6	/* commands allowed to other than super user or dp group */

int	curtrno;		/* current transmittal number */
int	fid;			/* spare file descriptor */
char	line[3];		/* buffer for building control keyin*/
char	cmes[]		"CTRLxx\0";	/* control message number */
int	sendpid;

int	cmcd[]	{	/* keyin codes */
			TERMD, SUSPEN, RESUME, LOCKTM, REQUEUE,
			LOCKRQ, DISPF, DISPQ, TERMST, UNLOCK, RQTERM,
			COMPTM, COMQTM, LOCKOUT, DISPLY,
			RQTERM, 99, 98,	/* logout is rqterm, login is special */
			0};		/* and so is trace (98)  */
char	*cmnd[]		{	/* the keyin commands actually used */
		"termd", "suspend", "resume", "locktm", "rq",
		"lockrq", "dispf", "dispq", "termsite", "unlock", "rqterm",
		"comptm", "comqtm", "lock", "display",
		"logout", "login", "trace",
		0};
int	devcode[NDEV]	{	/* device codes - default is site */
			PR1, PR2, PUNCH, CONSOL, READER, SITE,
			'i', 'o', 'c', 't', 'r'		/* pseudo device codes for trace modes */
			};
char	*devlist[]	{	/* the device names used */
		"pr1", "pr2", "punch", "console", "reader", "site",
		"i", "o", "c", "t", "r",
			0};
char	*safelist[]	{	/* commands ordinary people can use */
			"login", "logout", "dispf", "dispq", "comptm", "comqtm",
			0};
int	uid, gid;


main(argc, argv)
int argc;
char ** argv;
{
register int i;
char type, dev, detail;

	if (argc < 2) {
		printf("usage: keyin action [device [detail]]\n");
		exit(1);
	}
	dev = SITE;	detail = 0;	/* defaults */
	fid = open(pidfile,0);
	read(fid, &sendpid, 2);
	close(fid);
	/* arguments 1 is command, 2 is device, 3 is detail */
	if (argc < 3) goto getcmnd;	/* no device or detail */
	for (i = 0; i< NDEV; i++)
		if (cmpx(devlist[i], argv[2])) {
			dev = devcode[i];
			goto getdet;
		}
	printf("keyin: unknown device %s\n",argv[2]);
	exit(1);
getdet:
	if (argc < 4) goto getcmnd;
	detail = atoi(argv[3]);
getcmnd:
	if (cmpx("kick", argv[1])) {	/* kick ntr, but no actual work */
		if (sendpid == 0) goto nokick;
		if (kill(sendpid, WORK) < 0) goto nokick;
		exit(0);
	}
	for (i=0; i<NMSG; i++)
		if (cmpx(cmnd[i], argv[1])) {
			type = cmcd[i];
			goto doit;
		}
	printf("keyin: unknown action %s\n", argv[1]);
	exit(1);
doit:
	/* we now have a message type, device and detail */
	uid = getuid() & 0377;
	gid = getgid() & 0377;
	if (uid == 0) goto do_now;
	if (gid == DPGROUP) goto do_now;
	for (i=0; i<NSAFE; i++)
		if (cmpx(safelist[i], argv[1])) goto do_now;
	printf("sorry: command %s restricted to super user\n", argv[1]);
	exit(1);
do_now:
	xlock();	/* lock the transmittal number file */
	fid = open(ctrnum, 2);
	read(fid, &curtrno, 2);
	curtrno++;
	if (curtrno > 99) curtrno = 1;
	seek(fid, 0, 0);
	write(fid, &curtrno, 2);
	close(fid);
	funlock(lockfile);
	cmes[4] = (curtrno/10) | 060;
	curtrno = curtrno%10;
	cmes[5] = curtrno | 060;
	chdir(datafile);
	fid = creat(cmes, 0644);
	/* construct keyin message here */
	line[0] = type;
	line[1] = dev;
	line[2] = detail;
	write(fid, line, 3);
	close(fid);
	xlock();
	if (sendpid == 0) goto rmesg;
	if (kill(sendpid, WORK) < 0) goto rmesg; /* no keyins if ntr not loaded */
	sleep(1);
	funlock(lockfile);
	exit(0);
rmesg:
	/* do not leave any keyins around if ntr is not running */
	funlock(lockfile);
	unlink(cmes);
nokick:
	printf("keyin: ntr not operating - keyin ignored\n");
	exit(1);
}
/* cmpx - compare two lines of text up to a null*/

cmpx(s1, s2)	/* return 1 if strings match */
char s1[], s2[];
{
register int i;
	for (i=0; i<1000; i++)	{
		if (s1[i] != s2[i]) return(0);
		if (s1[i] == '\0') return(1);
	}
	return(1);
}

xlock()
{
register int i;
	i = 0;
	while (!flock(lockfile)) {
		if (i++ > 20) {
			fprintf(stderr,"keyin:  Sorry - cannot lock file\n");
			exit(1);
		}
		sleep(1);
	}
}
