#
/*
 * sender
 * This is the routine to organize jobs and control messages, format
 * and/or compress them, and feed them to the protocol routine for
 * transmission to the UNIVAC 1100.
 * It maintains a table of jobs which is updated when a signal is received
 * from the job submittal program (send) or the control message generation
 * program (keyin).
 *
 *
 * Written by David E. Miran
 * Wisconsin State Hygiene Lab
 * 465 Henry Mall
 * Madison, Wi 53706
 *
 *  April 22, 1981
 *
 */

#include	<stdio.h>
#include	"rjedef.h"
#include	"rjeforms.h"

int	backflg		0;	/* backup and restart transmission */
int	brokim		0;	/* broken image flag */
int	eojprg		0;	/* use to indicate state of end of job processing */
				/* 1 = need eoj data buffer, 2 = need eoj message to terminate reader */
char	iccbuf[63];		/* image segment assembly buffer */
char	scurjob[7];		/* current job being transmitted */
int	sfid;			/* spare file id */
int	ibc, icc;		/* blank/char counts */
int	simprog		0;	/* image in progress */
int	imsize;			/* current image size */
int	inline;			/* current job input line number - debugging aid */
int	iptr;			/* input buffer pointer */
int	jobpend;		/* number of jobs to send in table */
int	jobprg;			/* 1 if sending is in progress */
int	jmax;			/* current number of jobs in table */
char	jname[300][7];		/* job names - 6 chars + null */
char	jstat[300];		/* job status */
int	jsfid;			/* job file id */
char	sjtext[20]	"text.xxxxxx\0\0\0\0";	/* input job file name */
int	scneed	0;	/* set by signal that job/ctrl is ready */
int	snrd;			/* number of chars read */
char	xibuf[512], xobuf[512];
char	obf[6];			/* for control messages */
struct	locmesg	*optr;		/* message buffer pointer */
int	savebc		0;	/* saved blank count */
char	savec	'\0';		/* saved char for image building */
int	savecc	0;		/* saved character count across buffer boundary */
int	savend		0;	/* end of image saved */
int	tpnt;			/* text pointer */
int	sjobprg	0;	/* a job is in progress */


sender()
{
extern int rjestate, termed, terming;
extern char *lsentfil;
register int i, jpos;
char c;
int xsfid;

reset:
	if (backflg) {
/* reset signal from protocol set backup flag - this means jobs
 * may have been lost in transmission, and communications
 * has broken down.  Dump the current job status table and rescan
 * the file to recreate it with correct status information.
 * also close any currently open files, and send a flush marker
 * to protocol.
 */

	jmax=jobpend=jobprg=sjobprg=0;
	simprog = brokim = eojprg = ibc = icc = 0;
	savec = savebc = savecc = imsize = 0;
	if(jsfid) close(jsfid);
	if (sfid) close(sfid);
	scneed = 1;
	backflg = 0;
	optr = xobuf;
	optr->m_size = 0;
	optr->m_type = IFLUSH;
	return(optr);
	}
mainlp:
	if (scneed) {
		if (scan()) {
			return(obf);
		}
	}
	if (sjobprg) goto jloop;
mainlp2:
	if (jobpend <= 0) goto nopend;
	if ( termed || terming ) goto nopend;
	for (jpos = 0; jpos<jmax; jpos++)
		if (jstat[jpos] == 4) goto jfound;
	jobpend = 0;
	goto nopend;  /* idle loop */
jfound:
	for (i=0; i<7; i++)
		scurjob[i] = jname[jpos][i];
	sjobprg++;

/* now call genjob repeatedly until return(1) indicates that job
 * transmission is complete.
 */

jloop:
	if (genjob()) { /* transmission done */
		/* send an end of job message */
		optr = xobuf;
		optr->m_size=0;
		optr->m_type=IEOJ;
		if (rjestate&TESTMD) printf("sender: transmission done on job %s\n",scurjob);
		if (backflg) goto reset;
		jobpend--;
		jobprg = 0;
		i=jsearch(scurjob)-1;
		jstat[i] = 5;	/* mark job sent */
		xsfid = creat(lsentfil, 0644);
		scurjob[6] = '\n';
		write(xsfid, scurjob, 7);
		close(xsfid);
		sjobprg = 0;
		return(optr);
	}
	/* transmission incomplete - return a buffer */
	return(optr);
nopend:
	/* job queue maybe empty. rescan file and sleep up to 5 min */
	if (scan()) {
		scneed++;
		return(obf);
	}
	if ( termed || terming ) goto nopend2;
	if (jobpend) goto mainlp2;
nopend2:
	/* tell protocol - no more for now */
	optr = xobuf;
	optr->m_size=0;
	optr->m_type=IEOF;
	return(optr);
}

/* signal catchers */

/* stwork - work to be done is in file - scan it ASAP */

stwork()
{
extern int rjestate;
	if (rjestate & TESTMD)  printf("sender: got work signal\n");
	scneed = 1;
	rjestate =| FREADY;
	signal(WORK, &stwork);
}

/*
 * scan
 * scan the input queue file for work to do.
 * queue any jobs and process in order
 * process control messages immediately
 *
 */

scan()
{
extern errno;
extern int rjestate;
struct dirent file1;
struct inode fnode;
extern char *datafile;
register int i;
int jpos, js, ifl;

	
	if ((sfid = open(datafile, 0)) < 0) {
		printf("ntr:sender: cannout open job queue file - errno = %d\n\r", errno);
		shutdown();
		exit(1);
	}
	
	while ((read(sfid, &file1, 16)) == 16) {
		if (file1.inum == 0) continue;
		js = jsearch(file1.fname);
		if (js > 0) continue; /* job already in queue */
		if (js == 0) {	/* possibly new job to process */
		/* look up group modes to check job status */
		/* 4=pending, 5=sent, 7= received back */
			stat(file1.fname, &fnode);
			ifl = (fnode.iflags & 070)>>3;
			if ((jmax > 250) && (ifl > 4)) continue; /* table near full - skip old jobs */
			for (i=0;i<7;i++)
				jname[jmax][i] = file1.fname[i];
			jstat[jmax] = ifl;
			if (ifl == 4) jobpend++;
			jmax++;
			continue;
		}
		if (js == -1) continue; /* not a job or control message */
		/* must be a control message - do it now */
		genctrl(file1.fname);
		close(sfid);
		return(1);
	}
/* we have scanned the file and (maybe) queued jobs - close file */
scandn:
	close(sfid);
	scneed = 0;
	return(0);
}

/* shuffle - remove old entries from the job table
 * return(1) if no room made (scan will be incomplete)
 */

shuffle()
{
register int i, j, k;

	i = -1;
	while (jmax > 250) {
		i++;
		if (i> 298) {
			printf("sender: job table overflow\n\r");
			return(1);
		}
		if (jstat[i] < 5) continue;
		for (j=i; j<jmax; j++)   {
			for (k=0; k<7; k++)
				jname[j][k] = jname[j+1][k];
				jstat[j] = jstat[j+1];
		}
		jmax--;
		continue;
	}
	return(0);
}

/*
 * jsearch
 * take a file name and decide if it is
 * (a) not of interest - return -1
 * (b) a control message - return -2
 * (c) a job not yet in the job table - return 0
 * (d) a job already in the table - return table position+1
 */

jsearch(name)
char name[];
{
register int jpos, i;

	if ((name[0] == 'C') & (name[1] == 'T') & (name[2] =='R') &
		(name[3] == 'L')) return(-2);
	if (name[0] != SITEID) return(-1);
	/* a ?valid? job name - check if it is in the table */
	for (jpos = 0; jpos<jmax; jpos++) {
		for (i=0; i<6; i++)
			if (name[i] != jname[jpos][i]) goto notyet;
	/* match */      return(jpos+1);
notyet:;
	}
	return(0);
}

/* genctrl - generate a control message */

genctrl(name)
char name[];
{
extern int rjestate;
char cbf[3];
register struct locmesg *opt;
int csfid;

/* form of a control message file is 3 chars with type, dev, detail */
	
	if (rjestate & TESTMD)  printf("genctrl entered\n");
	if ((csfid = open(name,0)) < 0) return; /* ignore if not there */
	read(csfid, cbf, 3);
	close(csfid);
	opt=obf;
	opt->m_size = 1;
	opt->m_dev = cbf[1];
	opt->m_detail = cbf[2];
	opt->m_text[0]= cbf[0];
	if (cbf[0] == 98) 	/* trace command */
		opt->m_type = ITRC;
	else
		opt->m_type = ICTRL;
	unlink(name); /* remove control message from file */
}
/*
 * genjob
 * read a job from a file, compress it, and send text buffers
 * to protocol.
 * a temporary exit is done after each buffer to allow for job file
 * rescan, and possible transmission of control messages.
 *
 */

genjob()
{

extern int rjestate, wtcterm;
extern int devstate[16];
register int i, ix;


	if (jobprg) goto sendit;
	/* a job is not currently in progress - set everything up
	 * open job file, send initialize message, and signal protocol
	 * if it is necessary
	 */

	optr=xobuf;
	optr->m_size=7;		/* trno + null */
	optr->m_type=ISTRT;	/* initialize */
	optr->m_dev = READER;
	optr->m_detail = 0;
	for (i=0; i<7; i++)	{
		optr->m_text[i] = scurjob[i];
		sjtext[i+5] = scurjob[i];
	}
	if ((jsfid = open(sjtext,0)) < 0) {
		/* cannot open job text - abandon job */
		jobprg = 0;
		return(1);
	}
	iptr = snrd = 512;
	jobprg++;
	imsize = simprog = savend = brokim = 0;
	if (rjestate&TESTMD) printf("sender.genjob: begun transmission of job %-7.7s\n",scurjob);
	inline = 1;
	return(0);

/* now to send a buffer of data */

sendit:
	optr = xobuf;
	if (eojprg == 1) goto doeoj;
	if (eojprg == 2) {
		eojprg = 0;
		devstate[READER] =& ~ACTIVE;
		rjestate =& ~JOBPRG;
		if (!(rjestate & (RECPRG|FREADY))) {
			rjestate =& ~ACTIVE;
			rjestate =| IDLE;
		}
		return(1);
	}
	ix = getbuf();
	optr->m_size = SNDSIZE;
	optr->m_type = IDATA;
	optr->m_dev = READER;
	optr->m_detail = 0;
	if (ix) eojprg = 1;
	return(0);
doeoj:
	optr->m_size = SNDSIZE;
	optr->m_type = IDATA;
	optr->m_dev = READER;
	optr->m_detail = DATAEOF;
	optr->m_text[0] = DATAEOF;
	for (i=1; i<SNDSIZE; i++)
		optr->m_text[i] = 0;
	eojprg = 2;
	close(jsfid);
	wtcterm = 1;  /* wait for terminate of device */
	return(0);
}

/* getbuf - assemble a buffer of text image segments */
/*	returns 1 on end of job, else 0 */

getbuf()
{

register int i;
register struct locmesg *opx;
int maxcx, maxc, ir;

	tpnt = 0;
	opx = optr = xobuf;
	maxc = 62;
	if (savecc) {
		savecc = 0;
		opx->m_text[tpnt++] = 0;
	}
	if (savend) {
		savend = 0;
		ir = 1;
		goto ckend;
	}

getlp:		/* get next image segment */
	ir = getim(maxc);
	if (ir == -1) goto do_eof;   /* end of job */
	if (simprog == 0) {
		opx->m_text[tpnt++] = SENDAS;  /* function code */
		simprog++;
	}
	if ((ibc > 62) || (icc > 62)) {
		printf("sender:genjob: compression error at line # %d ibc icc = %d %d\n", inline, ibc, icc);
		shutdown();
	}
	opx->m_text[tpnt++] = ibc;  /* blank count */
	opx->m_text[tpnt++] = icc;   /* char count */
	for (i=0; i<icc; i++)
		opx->m_text[tpnt++] = iccbuf[i];

ckend:
	if (tpnt > SNDSIZE) {
		printf("sender:genjob: compression error at ckend on line # %d tpnt= %d\n\r", inline, tpnt);
		shutdown();
	}
	if (ir == 1) {
		if (tpnt == SNDSIZE) {
			savend++;
			return(0);
		}
		imsize = simprog = 0;
		opx->m_text[tpnt++] = ENDIM;
	}
	if (tpnt == SNDSIZE) return(0);
	maxcx = maxc = SNDSIZE - tpnt;
	if (simprog) maxc =- 2;
		else maxc =- 3;  /* leave room for function, bc, and icc */
	if (maxc > 62) maxc = 62;
	if (maxc<1) {
		if (simprog == 0) {
			opx->m_text[tpnt++] = ENDBUF;
			while (tpnt<SNDSIZE)
				opx->m_text[tpnt++] = '\0';
			return(0);
		}  else  {
			if (maxcx == 1) {
				opx->m_text[tpnt++] = 0;
				savecc++;
				return(0);
			}  else  {
				opx->m_text[tpnt++] = 0;
				opx->m_text[tpnt++] = 0;
				return(0);
			}
		}
	}
	goto getlp;

do_eof:
	if (tpnt < SNDSIZE) opx->m_text[tpnt++] = ENDBUF;
	while (tpnt<SNDSIZE)
		opx->m_text[tpnt++] = '\0';
	return(1);
}

/* getim - assemble a text image segment */
/* this will get the next image segment, whose size is up to max,
 * which is min of (62, space left in buffer) while not running past
 * a card boundary, and breaking long lines at column 80.
 * returned values in global variables - ibc - initial blank count,
 * icc - char count, iccbuf - the characters
 * return code - 0= image segment ready, -1 = end of file (job),
 * +1 = end of image (ie. end of line or column 80 reached).
 */

getim(max)
int max;
{
extern char sget();
int bc;
register char c;

/* get next image segment (bc, icc, chars) up to max chars in size */

	ibc = bc = icc = 0;
	while (savebc > 0) {
		savebc--;
		ibc++;
		imsize++;
		if (imsize == 80) goto fullcard;
	}
	if (ibc == 62) goto fullseg;
	if (c = savec) goto nextp;
nextc:
	c = sget();
nextp:
	if (c == 0) return(-1);		/* end of job */
	if (c == '\n') {	/* newline */
		inline++;
		if (brokim > 0) {
			brokim = 0;
			goto nextc;
	/* this was a newline right after column 80 - ignore */
		}
		return(1);  /* end of image */
	}
	brokim=0;
	if (c == ' ') {
		if (icc == 0) {
			ibc++;
			imsize++;
			if (ibc >= 62) goto fullseg;
			if (imsize == 80) goto fullcard;
		}  else  {
			bc++;
			if (bc >= 62) {
				savebc = bc;
				return(0);
			}
		}
		goto nextc;
	}
	savec = c;
	if (bc > 2) {
		savebc = bc;
		return(0);
	}
	while (bc > 0) {
		bc--;
		iccbuf[icc++] = ' ';
		imsize++;
		if (imsize == 80) {
			savebc = bc;
			goto fullcard;
		}
		if (icc == max) {
			savebc = bc;
			goto fullseg;
		}
	}
	iccbuf[icc++] = savec;
	savec = '\0';
	imsize++;
	if (imsize == 80) goto fullcard;
	if (icc == max) goto fullseg;
	goto nextc;
fullseg:
	return(0);
fullcard:
	brokim++;	/* note - broken input line at column 80 */
	imsize = 0;
	return(1);
}

/* get - return next character from job file */

char sget()
{

	if (iptr == snrd) {  /* read next block */
		snrd = read(jsfid, xibuf, 512);
		if (snrd<1) return(0);	/* end of file */
		iptr = 0;
	}
	return (xibuf[iptr++]);
}
