/*
 * acct [ -w wtmp ] [ -s dist ] [ -d ] [ -p people ]
 *
 * modified to combine name and project number into a 12
 * character name field
 * -s dist means seek dist records into the wtmp file.
 * positive dist is from front and negative is from end.
 * negative past start of file is a no-op, positive past end is an error.
 * by David E. Miran  Wisconsin State Hygiene Lab
 * version of 3/14/83
 */

#include	<myio.h>
#include	<stdio.h>
#define	TSIZE	80
#define	USIZE	700

struct {
	char	iname[12];
	char	tty;
	char	fill1;
	float	time;
	int	fill2;
} ibuf;

struct {
	char	jname[8];
	char	jtty;
	char	jfill1;
	float	jtime;
	int	jfill2;
	char	proj[4];
} jbuf;

struct ubuf {
	char	name[12];
	float	utime;
} ubuf[USIZE];

struct tbuf {
	struct	ubuf	*userp;
	float	ttime;
} tbuf[TSIZE];

char	*wtmp;
int	pflag, byday;
double	dtime;
double	midnight;
double	lastime;
double	day	1440.;
int	pcount;
char	**pptr;

int	montab[] { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31,
		31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };

char	*monasc[] {
	"Jan",
	"Feb",
	"Mar",
	"Apr",
	"May",
	"Jun",
	"Jul",
	"Aug",
	"Sep",
	"Oct",
	"Nov",
	"Dec"
};

long	dist, fsize, dsize, lseek(), atol();
struct	fbuf	mbuf;
int	wfid;

main(argc, argv) 
char **argv;
{
	int c, fl;
	register i;
	register char *ip;
	int f;
	int j;

	wtmp = "/usr/adm/wtmp";
	dist = 0L;
	while (--argc > 0 && **++argv == '-')
	switch(*++*argv) {
	case 'd':
		byday++;
		continue;

	case 'w':
		if (--argc>0)
			wtmp = *++argv;
		continue;

	case 's':
		if (--argc > 0)
			dist = atol(*++argv);
		continue;

	case 'p':
		pflag++;
		continue;
	}
	pcount = argc;
	pptr = argv;
	if ((wfid = open(wtmp, 0)) < 0) {
		printf("No %s\n", wtmp);
		return;
	}
	if (dist != 0L) {	/* seek into accounting file */
		dsize = dist * 20L;
		fsize = lseek(wfid, 0L, 2);
		if (dsize > 0) {
			if (dsize >= fsize) exit(1);
			lseek(wfid, dsize, 0);
			goto sdone;
		}
		dsize = -dsize;
		if (dsize >= fsize)
			lseek(wfid, 0L, 0);  /* back beyond start of file */
		else
			lseek(wfid, (long) (fsize-dsize), 0);
	}
sdone:
	mfinit(&mbuf, wfid);
	midnight = 0.0;
	lastime = 0.0;
	for(;;) {
		i = mgetrec(&jbuf, 20, &mbuf);
		if (i == 0) break;
		for (i = 0; i < 8; i++)
			ibuf.iname[i] = jbuf.jname[i];
		j = 0;
		for (i = 8; i < 12; i++)
			ibuf.iname[i] = jbuf.proj[j++];
		ibuf.tty = jbuf.jtty;
		ibuf.fill1 = jbuf.jfill1;
		ibuf.time = jbuf.jtime;
		ibuf.fill2 = jbuf.jfill2;
/*  following section commented out
		fl = 0;
		for (i=0; i<8; i++) {
			c = ibuf.iname[i];
			if ('0'<=c&&c<='9'||'a'<=c&&c<='z'||'A'<=c&&c<='Z') {
				if (fl)
					goto skip;
				continue;
			}
			if (c==' ' || c=='\0') {
				fl++;
				ibuf.iname[i] = '\0';
			} else
				goto skip;
		}
*******  end of commented out section  */
		loop();
    skip:;
	}
    brk:
	ibuf.iname[0] = '\0';
	ibuf.tty = '~';
	time(&ibuf.time);
	loop();
	print();
}

loop()
{
	double ltod();
	register i;
	register struct tbuf *tp;
	register struct ubuf *up;

	if (ibuf.fill1||ibuf.fill2)
		return;
	ibuf.time = ltod(&ibuf.time)/60.;
	if(ibuf.tty == '|') {
		dtime = ibuf.time;
		return;
	}
	if(ibuf.tty == '}') {
		if(dtime == 0.)
			return;
		for(tp = tbuf; tp < &tbuf[TSIZE]; tp++)
			tp->ttime =+ ibuf.time-dtime;
		dtime = 0.;
		return;
	}
	if (midnight==0.0)
		newday();
	lastime = ibuf.time;
	if (byday && ibuf.time > midnight) {
		upall(1);
		print();
		newday();
		for (up=ubuf; up < &ubuf[USIZE]; up++)
			up->utime = 0.0;
	}
	if (ibuf.tty == '~') {
		ibuf.iname[0] = '\0';
		upall(0);
		return;
	}
	i = ibuf.tty;
	if ((i >= 'a') && (i <= 'z')) {
		i = i - 'a';
		goto gotln;
	}
	if ((i >= '0') && (i <= '9')) {
		i = i - '0' + 26;
		goto gotln;
	}
	i = i - 'A' + 36;
gotln:
	if (i<0 || i>=TSIZE)
		i = TSIZE-1;
	tp = &tbuf[i];
	update(tp, 0);
}

print()
{
	int i;
	float ttime, t;

	ttime = 0.0;
	for (i=0; i<USIZE; i++) {
		if(!among(i))
			continue;
		t = ubuf[i].utime;
		if (t>0.0)
			ttime =+ t;
		if (pflag && ubuf[i].utime > 0.0) {
			printf("\t%-14.12s%6.2f\n",
			    ubuf[i].name, ubuf[i].utime/60.);
		}
	}
	if (ttime > 0.0) {
		pdate();
		printf("\ttotal%15.2f\n", ttime/60.);
	}
}

upall(f)
{
	register struct tbuf *tp;

	for (tp=tbuf; tp < &tbuf[TSIZE]; tp++)
		update(tp, f);
}

update(tp, f)
struct tbuf *tp;
{
	int i, j;
	struct ubuf *up;
	double t, t1;

	if (f)
		t = midnight;
	else
		t = ibuf.time;
	if (tp->userp) {
		t1 = t - tp->ttime;
		if (t1>0.0 && t1 < 1.5*day)
			tp->userp->utime =+ t1;
	}
	tp->ttime = t;
	if (f)
		return;
	if (ibuf.iname[0]=='\0') {
		tp->userp = 0;
		return;
	}
	for (up=ubuf; up < &ubuf[USIZE]; up++) {
		if (up->name[0] == '\0')
			break;
		for (j=0; j<12 && up->name[j]==ibuf.iname[j]; j++);
		if (j>=12)
			break;
	}
	for (j=0; j<12; j++)
		up->name[j] = ibuf.iname[j];
	tp->userp = up;
}

among(i)
{
	register j, k;
	register char *p;

	if (pcount==0)
		return(1);
	for (j=0; j<pcount; j++) {
		p = pptr[j];
		for (k=0; k<8; k++) {
			if (*p != ubuf[i].name[k]) goto nxtnam;
			if (k == 7) return(1);
			if ((*(++p) == '\0') && (ubuf[i].name[k+1] == ' ')) return(1);
		}
		return(1);
nxtnam:;
	}
	return(0);
}

newday()
{
	if(midnight == 0.)
		midnight = 360.;	/* time zone adjustment - 6 hours is cst */
	while (midnight <= ibuf.time)
		midnight =+ day;
}

pdate()
{
	register days, mons, yrs;
	double year, tim;

	if (byday==0)
		return;
	yrs = 2;
	tim = 0.0;
	for(;;) {
		year = 365. * day;
		if(yrs%4 == 0)
			year =+ day;
		if(tim+year > midnight)
			break;
		yrs++;
		tim =+ year;
	}
	days = (midnight-tim-720.)/day;
	montab[1] = 28;
	if(yrs%4 == 0)
		montab[1]++;
	for (mons=0; montab[mons]<=days; mons++)
		days =- montab[mons];
	mons =% 12;
	printf("%s %2d", monasc[mons], days+1);
}
