#
/* elist [dataset]
 * list all of the data sets, or list all elements (files) in a single
 * data set.
 * Used to get a list of files for use with the enquiry program enq
 * by David E. Miran  -  Wisconsin State Hygiene Lab
 * 9/8/80
 */

#define	DPGROUP	20	/* group id for data processing */

char	rec[2048];
char	ibuf[2048];
char	uname[9];
char	mfile[]	"/2/dp";	/* master directory */
char	afile[]	"auth";		/* file with access authorizations for a data set */
char	datafile[]	"data";	/* directory containing data elements (files) */
char	dir[]	".";		/* the current working directory */

struct	{
	int	inum;
	char	fname[14];
	}	dirent;		/* the directory entry structure */

int	uid, gid, bufeof, recsize;
int	nrd;
int	iptr;			/* ibuf pointer */
int	fptr;			/* for counting off files */
int	fid, dfid;		/* file descriptors */

main(argc, argv)
int argc;
char **argv;
{
register int i;
register char c, *cptr;
char *xcptr;

	uid = getuid()&0377;
	gid = getgid()&0377;
	chdir(mfile);
	if (uid == 0) goto auth_sp;
	if (gid == DPGROUP) goto auth_sp;
	if (getpw(uid, rec) != 0) {
		printf("user %d unknown\n", uid);
		exit(1);
	}
	i = 0;
	while ((c = rec[i]) != ':')     uname[i++] = c;
	uname[i] = ',';
	if (argc <2) goto auth_ok; /* only list of data sets */
	if (chdir(argv[1]) < 0) {
		printf("dataset %s does not exist\n", argv[1]);
		exit(1);
	}
	if ((fid = open(afile, 0)) < 0) {
		printf("No authorization file for data set %s\n", argv[1]);
		exit(1);
	}
	iptr = nrd = 0;
	while (getrec()) {	/* returns 0 on eof */
		cptr = uname;
		xcptr = rec;
		c = '\0';
		while (c != ',') {
			c = *cptr++;
			if (c != *xcptr++) break;	/* get next auth record */
			if (c == ',') goto auth_set;	/* good - found name */
		}
	}
	printf("You are not authorized to read data set %s\n", argv[1]);
	exit(1);
auth_sp:
	if (argc <2) goto auth_ok; /* only list of data sets */
	if (chdir(argv[1]) < 0) {
		printf("dataset %s does not exist\n", argv[1]);
		exit(1);
	}
auth_set:
	if (fid) close(fid);
	if (chdir(datafile) < 0) {
		printf("There is no data for data set %s\n", argv[1]);
		exit(1);
	}
auth_ok:
	i = 1;
	dfid = open(dir, 0);
	seek(dfid, 32, 0);	/* skip . and .. */
	while ( read(dfid, &dirent, 16) == 16) {
		if (dirent.inum == 0) continue;
		printf("%-16.16s", dirent.fname);
		if (i++ == 4) {
			i = 1;
			printf("\n");
		}
	}
	printf("\n");
	close(dfid);
	exit(0);
}

/* getrec - read a record into buffer rec as a standard compressed record - i.e.
 * strip out newlines and consider ! to mark the end of the record.
 * return 1 with record, or 0 on eof
 */

getrec()
{
register char c;
register int i;
	i = 0;
glp:
	c = get();
	if (bufeof) return(0);
	if (c == '\n') goto glp;
	rec[i++] = c;
	if (c == '!') {
		recsize = i;
		rec[i] = '\0';
		return(1);
	}
	goto glp;
}

char get()
{
	if (iptr == nrd) {
		nrd = read(fid, ibuf, 2048);
		if (nrd < 1) {
			bufeof = 1;
			return(0);
		}
		iptr = 0;
	}
	return(ibuf[iptr++]);
}
