/*
 *
 * whos: prints information about a user from /etc/user
 * tells users real name, class he's in and his major(if he answered
 * all the 'newuser' questions correctly).
 *
 *	Usage: whos <login name> [...]
 *
 * Modified Paul Pierce to allow multiple arguments
 *
 * Modified 9/22/78 by Randall R. Schulz so it would not quit
 * when it found an invalid login name in mutiple argument list
 *
 */

char buf[512],*bp;
int n;
int ufile;

main(argc,argv)
int argc;
char **argv;
{
	char c,*np;
	int narg;
	int flag;

	if(argc < 2) {
		write(1, "Usage: whos username\n", 21);
		exit();
	}
	if((ufile=open("/etc/user",0)) < 0) {
		write(1, "Can't open /etc/user\n", 25);
	}
    for(narg=1; argv[narg] != -1 ; narg++) {
	seek(ufile,0,0);
	n = 0;
	while((c=gc()) != 0) {
		np = argv[narg];
		flag = 1;
		while(c != ':' && *np != 0) {
			flag =& (c == *np++) ;
			c = gc();
		}
		flag =& (c==':');
		flag =& (*np == 0);
		if(flag)goto found;
		while((c=gc()) != 0 && c != '\n');
	}
	write(1, "No info on ", 11);
	write(1, argv[narg], strlen(argv[narg]));
	write(1, "\n", 1);
	continue;

found:
	if(argc > 2) {
		write(1, argv[narg], strlen(argv[narg]));
		write(1, ": ", 2);
	}
	while((c=gc()) != '\n') {
		if(c == ':') {
			write(1, "; ", 2);
		}
		else write(1, &c, 1);
	}
	write(1, "\n", 1);
    }
}

gc() {
	if(n--) return(*bp++);
	n = read(ufile,buf,512);
	if(n<=0) return(0);
	bp = buf;
	n--;
	return(*bp++);
}
