/*
 * xpack < ifile > ofile
 * read stdin and write stdout replacing excess blank lines with form feeds
 * Very useful to speed up printing on line printers.
 * by David E. Miran
 * version of 5/19/82
 */

#include	<myio.h>

struct fbuf ibuf, obuf;

#define	FF	014	/* form feed */
#define	PGSIZE	66	/* line per page */

main()
{
register int ch, ln, saveol;

	close(2);
	mfinit(&ibuf, 0);
	mfinit(&obuf, 1);
	ln = saveol = 0;
lp:
	ch = mget(&ibuf);
	if (ibuf.nrd < 1) goto endit;
	if (ch == '\n') {
		saveol++;  ln++;
		if (ln == PGSIZE) {
			mput(FF, &obuf);
			ln = saveol = 0;
		}
		goto lp;
	}
	if (ch == FF) {
		mput(ch, &obuf);
		ln = saveol = 0;
		goto lp;
	}
	while (saveol > 0) {
		saveol--;
		mput('\n',&obuf);
	}
	mput(ch, &obuf);
	while (ch != '\n') {
		ch = mget(&ibuf);
		if (ibuf.nrd < 1) goto endit;
		mput(ch, &obuf);
	}
	ln++;
	if (ln == PGSIZE) ln = 0;
	goto lp;
endit:
	if (ln != 0) mput(FF,&obuf);
	mfclose(&obuf);
}
