/*
 * tpd	printer daemon. Works as follows:
 *
 *	(1) try to open /dev/lp (or /dev/tty? if terminal mode).
*	    If terminal mode check and set locks as needed.
*	    If can't, exit.
 *	(2) scan /sptmp/data for files starting with "cf"
 *		& mode PRTMODE. None found ==> exit.
 *	(3) one found. Start printing. if > 1 copies, do in
 *		order. When done, delete control file and
 *		data file & -> (1).
 *	(4) L_SKIP signal:
 *		stop printing & re-read present control file.
 *		using present # copies, re-start current print.
 *	(5) L_KILL signal:
 *		stop current print, change mode of control file
 *		to 0600, put present parms in it.
 *
 * This program must be set-user root, since it may need to do chmod of
 * files it doesn't own, and it tries to nice itself to a high priority.
 *
 * Some race conditions may develop with the L_KILL and L_SKIP signals, but
 * these should rarely, if ever, happen.
 *
 * Main path always exits, spawning a deamon if the main path can open
 * the appropriate device.
 *
 * Written by Bob Beck, 21-JAN-77.
 * modified by David E. Miran to remove accounting and print 66 lines/page always
 * added plotmode - for output to /dev/plt instead of line printer  2/6/81
 * added capability to handle printing terminals as well - David Miran
 * version of 5/19/83
 */

#include "tpdinf.h"
#include	<stdio.h>
#define ever	;;
#define	BLOCKSIZE	1024

int	fout;
FILE	*ifile;
FILE	*fdopen();
struct	control	ctl;
int	killf, skipf;
struct	{
	int	inum;
	char	fnam[15];
	} dirent;
int	*first	dirent.fnam;
int	statb[18];

char	outb[BLOCKSIZE];
char	*outbp;
int	outbc;
int	lp;
char	lpr[]	"/dev/lp";
char	plt[]	"/dev/plt";
char	tdev[]	"/dev/tty?";	/* % is code for /dev/lp, rest are /dev/tty? */
char	term;
int	tmode	0;	/* set if output to a terminal */

#define	ROOT	0
struct	statp	{	/* pointer to a stat/fstat buffer */
	char	fila[4];
	int	modes;
	char	nlinks;
	char	xuid;
	char	filb[28];
	};
struct	statp *st;
char	spdbuf[100];	/* buffer for processing terminal characteristics */
#define	TMODE	0322	/* standard stty modes for terminal even,odd,xtab,nl */
int	tty[3], otty[3];		/* stty buffer */
int	lfid;
/* following are used in uprint mode */
int	epos, savepos, savl, spcnt;
char	line[256], sline[256];
#define	CTR	'~'		/* the signal character */
#define	FF	014		/* form feed character */
#define	CR	'\r'		/* return character */
#define	NL	'\n'		/* new line character */

/* following are used to get and give up line printer */
#define	daemon	1	/* daemon user id */
struct	{
	char	fill1[7];
	char	fuid;		/* files owner */
	char	fill2[28];
	}	fbuf;



char	topform[] " \n\014";	/* top of form string */

main(argc,argv)
int	argc;
char **argv;
{
extern int errno;
int	KILL();
int	SKIP();
register int cont, fd, dir;
int i, fid, j;
int	pid, spool, n;

	/*
	 * close all files. try to open device for writing. if can't, exit.
	 */

	term = '%';
	if (argc > 1) {	/* better be a terminal specification */
		term = argv[1][0];
		if (term != '%') {
			tmode = 1;
			tdev[8] = term;
			tpdpid[12] = term;
			tpdprid[12] = term;
			tpdlock[12] = term;
			tpdspd[12] = term;
			sfs[2] = term;
		}
	}
	for(fd = 3; fd < 16; fd++)
		close(fd);
	/* check if this is for a terminal and do setup */
	if (tmode) {
		i = stat(tpdlock,statb);
		if (i < 0) goto ckown;	/* no lock - so far so good */
		exit(0);	/* locked - forget it */
ckown:
		i = stat(tdev,statb);
		if (i < 0) exit(1);	/* no such device */
		st = statb;
		if (st->xuid != ROOT) exit(0);	/* someone is logged in */
		/* the device is free - create a lock file */
		lfid = creat(tpdlock,0400);
		if (lfid < 0) exit(1);  /* can't - someone snuck in */
		close(lfid);
		fid = open(tpdspd,0);	/* check terminal speed */
		if (fid < 0) rlsexit(0);	/* clear lock and quit */
		read(fid, spdbuf,100);
		i = atoi(spdbuf);	/* speeds are coded according to stty speed codes */
		close(fid);
		j = TMODE;
		if (i < 0) {  /* set up delays for cr and form feed */
			j |= 050000;  /* cr1 and vt1 */
			i = -i;
		}
		tty[0] = (i<<8) | i;
		tty[1] = 0;
		tty[2] = j;
		lp = open(tdev,2);
		gtty(lp,otty);
		stty(lp,tty);
		sleep(1);
	}  else  {	/* for line printer */
		stat(lpr, &fbuf);
		if (fbuf.fuid != daemon) exit(0);	/* lp not avail */
		if ((lp = open(lpr,1)) < 0)
			exit(0);
	}
	chdir(usrtpd);			/* change to /sptmp/data */

	/*
	 * let main path exit, and continue.
	 */

	if ((pid = fork()) > 0)
		exit(0);		/* good fork, main path exits */
	if (pid < 0)
		rlsexit(1);		/* if bad fork */

/*
 * set up to catch signals.
 * put priority up.
 */
	
	signal(L_HANG,1);			/* ignore hangup signal */
	signal(L_INT,1);			/* ignore interrupt signal */
	signal(L_KILL,KILL);
	signal(L_SKIP,SKIP);
	nice(TPDPRIO);
	
/*
 * write pid file for identification.
 */
	
	fd = creat(tpdpid,0644);
	pid = getpid();
	write(fd,&pid,2);
	close(fd);
	
/*
 * open directory.
 */

	if ((dir = open(usrtpd,0)) < 0)
		rlsexit(1);

/*
 * main loop. scan directory for proper files.
 */

	for(ever) {
		seek(dir,32,0);			/* skip "." and ".." */
		while(1) {
			if ((n = read(dir,&dirent,16)) < 0)
				rlsexit(1);
	
			if (n == 0) {			/* if scan turned up nothing, */
				rlsexit(0);		/* exit */
			}
	
/*
 * check for 'cf' and allocated file.
 */
	
			if (*first != 'cf' || !dirent.inum)
				continue;
			if (dirent.fnam[2] != term) continue;
	
/*
 * check stats.
 */
	
			stat(dirent.fnam,statb);
			if ((statb[2]&07777) == PRTMODE)
				break;			/* got good file */
		}
	
/*
 * got good name. read ctl and start printing.
 */
	
/* check if we still have control of the device (printer or terminal) */
		if (tmode) {	/* check terminal */
			i = stat(tpdlock,statb);
			if (i < 0) rlsexit(1);  /* lock went away */
			st=statb;
			if ((st->modes&0777) == 0) rlsexit(0); /* taken by rq */
		}  else  {  /* line printer */
			stat(lpr,&fbuf);
			if (fbuf.fuid != daemon) rlsexit(0); /* taken by rq */
		}
		cont = open(dirent.fnam,2);
		if (cont < 0 || read(cont,&ctl,sizeof ctl) < 0) {
			spoolerr("unlinking cf; cont=%d,direntfnam=%s\n",cont,dirent.fnam);
			unlink(dirent.fnam);
			continue;
		}
	
		print(cont);
	}
}

/*
 * printdo actual printing. handle signals.
 */

print(ctrl)
int ctrl;
{
register int lc, pc;
register int c;
int  h1, h2;
int  i, j;
int  prfd;
int  tof;
char  *file;
int	fid;
int  pagesz;

pagesz = FULLPG;

while(ctl.pfile < ctl.nfiles) {
	while(ctl.pcopy-- > 0) {
top:
/* check if we still have control of the device */
		i = 0;
		if (tmode) {  /* terminal */
			j = stat(tpdlock,statb);
			if (j < 0) i=1;
			st = statb;
			if ((st->modes&0777) == 0) i = 1;
		}  else  {  /* line printer */
			stat(lpr,&fbuf);
			if (fbuf.fuid != daemon) i = 1;
		}
		if (i != 0) {	/* control gone - quit */
				ctl.pcopy++;
				seek(ctrl,0,0);
				write(ctrl,&ctl,sizeof ctl);
				close(ctrl);
				xputc('\014');
				putflush();
				rlsexit(0);
			}

			file = makefn(sfs,ctl.pfile,ctl.sfpid);
			if ((fid = open(file,0)) < 0) {
				spoolerr("tpd: can't read %s",file);
				prdone(ctrl);
				return;
			}
	
			/*
			 * write print id file.
			 */
	
			prfd = creat(tpdprid,0644);
			if (prfd >= 0) {
				write(prfd,&ctl.pfile,4);
				close(prfd);
			}
			if (ctl.flags & C_PLTMODE) {
				plotit(fid);
				close(fid);
				goto done2;
			}
	
			/*
			 * get to proper position.
			 */
	
			ifile = fdopen(fid, "r");
			if (ctl.startp <= 0) ctl.startp = 1;
			pc = ctl.startp - 1;
			while(pc-- > 0) {
	
	
				for(lc = 0; lc < pagesz; lc++) {
	
					/*
					 * skip whole page.
					 */
	
					while((c = getc(ifile)) != '\n')
						if (c == '\014')
							goto form;
						else
							if (c == EOF)
								goto done;
				}
				form: ;
			}
	
			/*
			 * print it. first, initialize printer output & signal flags.
			 */
	
			outbp = outb;
			outbc = BLOCKSIZE;
			if (ctl.flags & C_UMODE) goto uprint;
			tof = 1;			/* we are at top of form */
			lc = killf = skipf = 0;		/* init flags & line count */
			while((c = getc(ifile)) != EOF) {
	
	
				if (tof) {
					tof = 0;
					if (c == -1)
						break;
				}
	
				/*
				 * check skipf and killf.
				 */
	
				if (killf) {
					xputc('\014');
					putflush();
					ctl.pcopy++;
					fclose(ifile);
					seek(ctrl,0,0);
					write(ctrl,&ctl,sizeof ctl);
					close(ctrl);
					chmod(dirent.fnam,IGNMODE);
					killf = 0;
					return;
				}
	
				if (skipf) {
					h1 = ctl.pcopy;
					h2 = ctl.pfile;
					fclose(ifile);
					seek(ctrl,0,0);
					read(ctrl,&ctl,sizeof ctl);
					ctl.pcopy = h1;
					ctl.pfile = h2;
					skipf = 0;
					goto top;
				}
	
				/*
				 * no signals in.
				 */
	
				if (c == '\n') lc++;
				if (c == '\014' || lc >= pagesz) {
					lc = 0;
					tof = 1;		/* set top of form */
					ctl.startp++;
				}
				xputc(c);
			}
			goto endpr;
uprint:
linloop:		/* get next line of text */
	i=getline();
	if (i < 0)	{	/* end of file */
		if (savl) {
			putline(sline);
			savl = 0;
		}
		goto endpr;
	}
				if (killf) {
					xputc('\014');
					putflush();
					ctl.pcopy++;
					ctl.startp = 1;
					fclose(ifile);
					seek(ctrl,0,0);
					write(ctrl,&ctl,sizeof ctl);
					close(ctrl);
					chmod(dirent.fnam,IGNMODE);
					killf = 0;
					return;
				}
/* interpret the lines here */
	epos = i;	/* save end of line position */
	if (line[0] != CTR) goto dopr;	/* an ordinary line */
	if (line[1] == CTR) {	/* a line starting with ~ */
		for (i=0; i<epos; i++)
			line[i] = line[i+1];
		epos =- 1;
		goto dopr;
	}
	if (line[1] == '*')	{	/* top of form */
		if (savl)	{
			putline(sline);
			savl = 0;
		}
		xputc(FF);
		tof = 1;
		goto linloop;
	}
	/* presume this is a ~N line and process */
	tof = 0;
	j = atoi(&line[1]);
	if (j == 0) {	/* overprint saved line with next one */
		sline[savepos-1] = CR;
		putline(sline);
		savl = savepos = 0;
		goto linloop;
	}
	/* line spacing greater than 0 - usually only for greater than 2 */
	if (savl)
		putline(sline);
	for (i=1; i<j; i++)
		xputc(NL);
	savl = 0;
	goto linloop;
dopr:	/* handle an ordinary line of print */
	tof = 0;
	if (savl)
		putline(sline);
		for (i=0; i< epos+1; i++)
			sline[i] = line[i];
		savl = 1;
		savepos = epos;
	goto linloop;


endpr:
	
			/*
			 * done this copy.
			 */
	
			if (!tof) xputc('\014');
			putflush();
	done:		fclose(ifile);
	done2:
			ctl.startp = ctl.startat;	/* set up next start page */
		}
		unlink(makefn(sfs,ctl.pfile,ctl.sfpid));
		ctl.pfile++;
		ctl.startp = ctl.startat = 1;		/* 2nd & > files start at 1 */
		ctl.pcopy = ctl.ncopies;
	}
	prdone(ctrl);
}

/*
 * output buffering.
 */

xputc(c)
char	c;
{
	if (!c)
		return;			/* ignore nulls */
	if (outbc--)
		*outbp++ = c;
	else {
		write(lp,outb,BLOCKSIZE);
		outbp = outb;
		outbc = BLOCKSIZE;
		xputc(c);
	}
}

putflush()
{
	write(lp,outb,BLOCKSIZE-outbc);
	outbp = outb;
	outbc = BLOCKSIZE;
}

/*
 * prdone	delete control and data file, close control file.
 */

prdone(cf)
int	cf;
{
	while(ctl.pfile < ctl.nfiles)
		unlink(makefn(sfs,ctl.pfile++,ctl.sfpid));
	close(cf);
	unlink(dirent.fnam);
}

/*
 * signal catchers.
 */

KILL()
{
	signal(L_KILL,KILL);
	killf++;
}

SKIP()
{
	signal(L_SKIP,SKIP);
	skipf++;
}

/* getline - build a line of text */

getline()
{
register char c;
register int i, curcol;

	curcol = 0;
cplp:
	if ((c = getc(ifile)) == EOF) return(-1);
	line[curcol++] = c;
	if (c == NL) {
		line[curcol] = '\0';
		return(curcol);
	}
	goto cplp;
}

putline(pline)
char pline[];
{
register char c;
register int i;

	for (i=0; i<savepos;i++) {
		c = pline[i];
		if (c == '\0') c = ' ';
		xputc(c);
	}
}
plotit(plotid)
int plotid;
{
int	i;
/* direct output to plotter instead of line printer */
	if (tmode) return;	/* cannot plot to a terminal for now */
	close(lp);
	sleep(2);
	lp = open(plt, 1);
	while((i = read(plotid, outb, BLOCKSIZE)) > 0)
		write(lp, outb, i);
	close(lp);
	sleep(1);
	lp = open(lpr, 1);
}

rlsexit(cd)
int cd;
{
register i;

	if (tmode) {
		sleep(5);
		stty(lp,otty);
	}
	close(lp);
	if (!tmode) exit(cd);
	i = stat(tpdlock,statb);
	if (i < 0) exit(cd);
	st = statb;
	if ((st->modes & 0777) == 0400)  /* no rq - spooler releases lock */
		unlink(tpdlock);
	exit(cd);
}
