/*
 * tpdinf	define KILL, and SKIP signals, control file structure and file names.
 *
 * Written by Bob Beck, 21-JAN-77.
 * removed accounting stuff and dropped priority 9/3/80 - David E. Miran
 * modified to support both line printer and printing terminals 12/10/82
 * define VERIFY for pkill (etc) verifications.
 * version of 12/16/82
 */

#define L_HANG	1		/* hangup - must ignore */
#define L_INT	2		/* interrupt - must ignore */
#define L_KILL	14		/* print kill */
#define L_SKIP	15		/* print skip */
#define MAXCOP	50		/* max allowed number copies */
#define TPDPRIO 0		/* tpd priority for nice call */
#define FULLPG	66		/* full page size */
#define	VERIFY	1		/* verify on for pkill, prem, pstop */

#define PRTMODE	0766		/* control file mode for printing */
#define IGNMODE	0600		/* control file mode for ignoring */

char	tpd[]		"/etc/tpd";
char	tpdpid[]	"/sptmp/ctrl/%pid";	/* ? is terminal code */
char	tpdprid[]	"/sptmp/ctrl/%prid";	/* current print */
char	usrtpd[]	"/sptmp/data";
char	tpdlock[]	"/sptmp/ctrl/?lock";	/* lock file */
char	tpdspd[]	"/sptmp/ctrl/?spd";	/* terminal characteristics file */
char	sfs[]		"sf%";

/*
 * control file structure.
 */

struct	control {
	int	ncopies;
	int	pcopy;			/* must initially be same as ncopies */
	int	startp;			/* start page for present copy */
	int	startat;		/* start page for present file */
	int	nfiles;			/* number of files */
	int	pfile;			/* present file, init to 0 */
	int	sfpid;			/* pid - file ident */
	int	uid;			/* uid of owner of spool file */
	int	flags;			/* see below */
};

struct	printid {
	int	thisp;			/* present file */
	int	prpid;			/* pid - identification */
};

/* control flags bits.  */
#define C_RAW	01		/* raw mode - full page, not tof simulation */
#define C_UMODE	010		/* uprint mode print control interpretation */
#define	C_PLTMODE 020		/* plotter output */
