/*
 *	v.index - index display for vir
 *	by David E. Miran
 *	12/7/82
 */

#include	<stdio.h>
#include	"vmyio.h"
#include	"vir.h"

extern long atol();

extern struct	dexhead	hrec;		/* HFILE (header file) */
extern struct	fil_ent	filent[MAXFILE]; /* data file information - HFILE-3 */
extern struct	fmt_def fmtdef[MAXFMT];
extern struct	fmt_inf	fmtinf[MAXFMT];	/* format information (internal) */
extern struct	pat_ent	prec;		/* one record from PFILE */
extern struct	num_ent	snrec;		/* one record from NFILE */
extern struct	sp_ent	srec;		/* one record from SFILE */

extern char	tbuf[MAXRSIZE], ibuf[MAXRSIZE];	/* terminal and internal buffers */


/* LOOKUP - control variables and tables (?2 files) */
extern int	plookp, nlookp, slookp;  /* set if currently searching p, n, or s file */
extern int	plooku, nlooku, slooku;  /* set if search beyond sequential area */
extern long ploc, nloc, sloc;  /* current offsets into index files */
extern long newnloc;

/* STATE - general system and state definitions */
extern int	icnt;	/* size of command line (= recsize) */
extern int	filspot;		/* current data file pointer in filent table */
extern int	imode;	/* set if index display is in progress */
extern long	initoff;	/* set for inital record offset in index display */
extern int scrst;

extern long MEG;

/* headings and print line formats */
char *hdgp "Position  Patient number  name\n";
char *hdgn "Position  Pat num   File #  Offset  File Name\n";
char *hdgs "Position  Spec number  Pat Num   File #  Offset  File Name\n";
char *formp "%8D%16D  %-14.14s\n";
char *formn "%8D%10D%8u%8D  %-30s\n";
char *forms "%8D%13D%10D%8u%8D  %s\n";


/*****************************  index  ************************************/
/* return +n for ! or other special response, -1 for error, else 0 */
index(st)
int st;
{
register int i;
char mode, c, pname[20], xbuf[BUFSIZ];
int offmode, pnc, rcnt, tcnt, j;
long number, iloc;

	pnc = offmode = rcnt = tcnt = 0;
	number = 0L;
	fmtoff();
	st++;
	setbuf(stdout, xbuf);
	mode = tbuf[st++];
	while (tbuf[st] == ' ') st++;
	if (tbuf[st] == '\0') goto idone;
	if (tbuf[st] == '+') {
		offmode = 1;
		st++;
	}
	number = atol(&tbuf[st]);
	pname[0] = '\0';
	if ((mode != 'p') && (mode != 'r') && (mode != 'n') && (mode != 's')) goto idone;
	if ((mode == 'n') || (mode == 's') || (offmode != 0)) goto noname;
	while (st < icnt) {
		c = tbuf[st++] & 0177;
		if ((c >= 'a') && (c <= 'z')) c &= 0137; /* fold to upper case */
		pname[pnc++] = c;
		if (pnc >= PNSIZE) break;
	}
	pname[pnc] = '\0';
noname:
	imode = 1;
	slookp = plookp = nlookp = 0;
	slooku = plooku = nlooku = 0;
	if (offmode) initoff = number;  /* set lookup routines for offset */
	switch (mode) {
		case 'r':	/* simple patient name lookup - match only */
			imode = 0; /* turn off special lookup mode */
		case 'p':	/* lookup starting at a given point */
phdg:
			printf(hdgp);
			while (lookp(pname)) {
				if ((strncmp(prec.p_name,pname,PNSIZE) < 0) && (plooku == 0) && (!offmode)) continue;
				rcnt++;  tcnt++;
				iloc = ploc/ sizeof (struct pat_ent) + 1;
				printf(formp,iloc,prec.p_num,prec.p_name);
				if (rcnt >= 20) {
					if ( i = ick(&rcnt)) goto qdis;
					goto phdg;
				}
			}
			break;

		case 'n':	/* lookup by patient number */
			if (hrec.compnum) {
				if (number < MEG)
					number += hrec.pnumyr * MEG;
			}
nhdg:
			printf(hdgn);
			while (lookn(number)) {
				if ((snrec.np_num < number) && (nlooku == 0) && (!offmode)) continue;
				rcnt++;  tcnt++;
				iloc = nloc/ sizeof (struct num_ent) + 1;
				j = lookupn(snrec.nf_num);
				printf(formn, iloc, snrec.np_num, snrec.nf_num, snrec.f_loc,filent[j].f_name);
				if (rcnt >= 20) {
					if ( i = ick(&rcnt)) goto qdis;
					goto nhdg;
				}
			}
			break;

		case 's':	/* lookup by specimen number */
shdg:
			printf(hdgs);
			while (looks(number)) {
				if ((srec.sp_num < number) && (slooku == 0) && (!offmode)) continue;
				rcnt++;  tcnt++;
				iloc = sloc/ sizeof (struct sp_ent) + 1;
				j = lookupn(srec.sf_num);
				printf(forms,iloc,srec.sp_num,srec.xp_num,srec.sf_num,srec.sf_loc,filent[j].f_name);
				if (rcnt >= 20) {
					if ( i = ick(&rcnt)) goto qdis;
					goto shdg;
				}
			}
	}
idone:
	i = 0;
	if (tcnt == 0) {
		printf("Invalid command or no entries match request\n");
		i = -1;
	}
qdis:
	fflush(stdout);
	setbuf(stdout, NULL);
	imode = 0;
	initoff = 0;
	slookp = plookp = nlookp = 0;
	slooku = plooku = nlooku = 0;
	if (!i)
		i = getin(1);
	return(i);
}

ick(x)
int *x;
{
register int i;
	*x = 0;
	fflush(stdout);
	scrst = 0;
	i = getin(1);
	if (i) return(i);
	fmtoff();
	return(0);
}
