/*
 *	v.rlook - index lookup routines for v.vir
 *	7/2/82
 */

#include	<stdio.h>
#include	"vmyio.h"
#include	"vir.h"

extern int nfid, n1fid, sfid, s1fid, pfid, p1fid;
extern char *s1, *n1, *p1;

extern char mget();
extern long tell(), atol(), lseek();

extern struct	dexhead	hrec;		/* HFILE (header file) */
extern struct	pat_ent	prec;		/* one record from PFILE */
extern struct	num_ent	snrec;		/* one record from NFILE */
extern struct	sp_ent	srec;		/* one record from SFILE */

/* LOOKUP - control variables and tables (?2 files) */
extern char pbase[NCPAT][16];	/* p2 file */
extern long	nbase[NCREC];	/* n2 file */
extern long	sbase[NCSPEC];	/* s2 file */
extern int	pbcnt, nbcnt, sbcnt;  /* counts of entries in p2, n2, s2 */
extern int	plookp, nlookp, slookp;  /* set if currently searching p, n, or s file */
extern int	plooku, nlooku, slooku;  /* set if search beyond sequential area */
extern struct fbuf plbuf, nlbuf, slbuf;  /* buffers for index files */
extern long ploc, nloc, sloc;  /* current offsets into index files */
extern long newnloc;
extern int imode;
extern long initoff;
extern int	SN_lkp, SP_lkp, SS_lkp;		/* save [nps]lookp states */
extern int	SN_lku, SP_lku, SS_lku;		/* and looku */
extern long	SN_off, SP_off, SS_off;		/* and current file offsets */

/******************************  lookn  **********************************/
/* find a patient number index entry and return it in snrec   */

lookn(xnum)
long xnum;
{
long i, off1, ynum, ndist;

	if (nlookp) goto nextrec;
	if (imode && (initoff > 0L)) {
		nloc = (initoff-1) * (long) sizeof (struct num_ent);
		nlooku = 0;
		goto doseek;
	}
	if (hrec.nmaxseq == 0) {
		nloc = 0;
		nlooku = 1;
		goto doseek;
	}
	for (i=0; i<nbcnt; i++)
		if (nbase[i] >= xnum) goto seta;
seta:
	if (i > 0) i--;
	off1 = (long) VBSIZE * i;
	i = off1/4;
/* off1 is the lseek distance into n1dex and i is # of records skipped */
	vfopn(&n1fid, n1, 0);
	lseek(n1fid, off1, 0);
	mfinit(&nlbuf, n1fid);
	while (mgetrec(&ynum, 4, &nlbuf)) {
		if (ynum >= xnum) goto setb;
		i++;
	}
setb:
	close(n1fid);
	if (i > 0) i--;
	nloc = (long) BSZN * i;
	nlooku = 0;
doseek:
	lseek(nfid, nloc, 0);
	nlookp = 1;
nextset:
	mfinit(&nlbuf, nfid);
	nloc -= sizeof (struct num_ent);
nextrec:
	while (mgetrec(&snrec, sizeof (struct num_ent), &nlbuf)) {
		nloc += sizeof (struct num_ent);
		if (imode) return(1);
		if (snrec.np_num < xnum) continue;
		ndist = nloc / sizeof (struct num_ent);
		if (ndist >= hrec.nmaxseq) nlooku = 1;  /* fell off end */
		if (snrec.np_num > xnum) {
			if (nlooku == 0) {
				nloc = lseek(nfid, (long) hrec.nmaxseq * sizeof (struct num_ent), 0);
				nlooku = 1;
				goto nextset;
			}
			continue;
		}
		return(1);  /* match found */
	}
	nlookp = 0;
	return(0);  /* end of matching patient numbers */
}

/******************************  lookp  **********************************/
/* find a patient name/number index entry and return it in prec   */

lookp(xname)
char *xname;
{
static int pcnt;
long i, off1, ndist;

	if (plookp) goto nextrec;
	if (imode && (initoff > 0L)) {
		ploc = (initoff - 1) * (long) sizeof (struct pat_ent);
		plooku = 0;
		goto doseek;
	}
	for (pcnt = 0; pcnt < PNSIZE; pcnt++)   /* count up size of name */
		if (xname[pcnt] == '\0') break;
	if (hrec.pmaxseq == 0) {
		ploc = 0;
		plooku = 1;
		goto doseek;
	}
	for (i=0; i<pbcnt; i++)
		if (strncmp(pbase[i], xname, pcnt) >= 0) goto seta;
seta:
	if (i > 0) i--;
	off1 = (long) VBSIZE * i;
	i = off1/16;
/* off1 is the lseek distance into p1dex and i is # of records skipped */
	vfopn(&p1fid, p1, 0);
	lseek(p1fid, off1, 0);
	mfinit(&plbuf, p1fid);
	while (mgetrec(&prec, 16, &plbuf)) {
		if (strncmp(&prec, xname, pcnt) >= 0) goto setb;
		i++;
	}
setb:
	close(p1fid);
	if (i > 0) i--;
	ploc = (long) BSZP * i;
	plooku = 0;
doseek:
	lseek(pfid, ploc, 0);
	plookp = 1;
nextset:
	mfinit(&plbuf, pfid);
	ploc -= sizeof (struct pat_ent);
nextrec:
	while (mgetrec(&prec, sizeof (struct pat_ent), &plbuf)) {
		ploc += sizeof (struct pat_ent);
		if (imode) return(1);
		if (prec.p_num == 0L) continue;
		if (pcnt == 0) return(1);
		if (strncmp(prec.p_name, xname, pcnt) < 0) continue;
		ndist = ploc/sizeof (struct pat_ent);
		if (ndist >= hrec.pmaxseq) plooku = 1;  /* fell off end */
		if (strncmp(prec.p_name, xname, pcnt) > 0) {
			if (plooku == 0) {
				ploc = lseek(pfid, (long) hrec.pmaxseq * sizeof (struct pat_ent), 0);
				plooku = 1;
				goto nextset;
			}
			continue;
		}
		return(1);  /* match found */
	}
	plookp = 0;
	return(0);  /* end of matching names */
}

/******************************  looks  **********************************/
/* find a specimen number index entry and return it in srec   */

looks(xnum)
long xnum;
{
long i, off1, ynum, ndist;

	if (hrec.nonspec) return(0);
	if (slookp) goto nextrec;
	if (imode && (initoff > 0L)) {
		sloc = (initoff -1) * (long) sizeof (struct sp_ent);
		slooku = 0;
		goto doseek;
	}
	if (hrec.smaxseq == 0) {
		sloc = 0;
		slooku = 1;
		goto doseek;
	}
	for (i=0; i<sbcnt; i++)
		if (sbase[i] >= xnum) goto seta;
seta:
	if (i > 0) i--;
	off1 = (long) VBSIZE * i;
	i = off1/4;
/* off1 is the lseek distance into s1dex and i is # of records skipped */
	vfopn(&s1fid, s1, 0);
	lseek(s1fid, off1, 0);
	mfinit(&slbuf, s1fid);
	while (mgetrec(&ynum, 4, &slbuf)) {
		if (ynum >= xnum) goto setb;
		i++;
	}
setb:
	close(s1fid);
	if (i > 0) i--;
	sloc = (long) BSZS * i;
	slooku = 0;
doseek:
	lseek(sfid, sloc, 0);
	slookp = 1;
nextset:
	mfinit(&slbuf, sfid);
	sloc -= sizeof (struct sp_ent);
nextrec:
	while (mgetrec(&srec, sizeof (struct sp_ent), &slbuf)) {
		sloc += sizeof (struct sp_ent);
		if (imode) return(1);
		if (srec.sp_num < xnum) continue;
		ndist = sloc / sizeof (struct sp_ent);
		if (ndist >= hrec.smaxseq) slooku = 1;  /* fell off end */
		if (srec.sp_num > xnum) {
			if (slooku == 0) {
				sloc = lseek(sfid, (long) hrec.smaxseq * sizeof (struct sp_ent), 0);
				slooku = 1;
				goto nextset;
			}
			continue;
		}
		return(1);  /* match found */
	}
	slookp = 0;
	return(0);  /* end of matching specimen numbers */
}

/****************************** sav *************************/
/***************************** rest ***********************/
/* save current lookup state */
/* restore current lookup state */
/* these are used by update and !u of display to save the current
 * lookup positioning, since uprec uses the lookup routines to find
 * the index entries to modify.
 */

sav()
{
	SN_lkp = nlookp;
	SN_lku = nlooku;
	SN_off = nloc + sizeof snrec;
	SP_lkp = plookp;
	SP_lku = plooku;
	SP_off = ploc + sizeof prec;
	SS_lkp = slookp;
	SS_lku = slooku;
	SS_off = sloc + sizeof srec;
}
rest()
{
	nlookp = SN_lkp;
	nlooku = SN_lku;
	nloc = SN_off;
	lseek(nfid, nloc, 0);
	mfinit(&nlbuf,nfid);
	nloc -= sizeof (struct num_ent);
	plookp = SP_lkp;
	plooku = SP_lku;
	ploc = SP_off;
	lseek(pfid, ploc, 0);
	mfinit(&plbuf,pfid);
	ploc -= sizeof (struct pat_ent);
	slookp = SS_lkp;
	slooku = SS_lku;
	sloc = SS_off;
	lseek(sfid, sloc, 0);
	mfinit(&slbuf,sfid);
	sloc -= sizeof (struct sp_ent);
}
