/*
 *	virdex
 *	update the indexes
 *	adding all files preceded by + and deleting all those preceded by -.
 *	-v means verbose - report files removed, packed, etc.
 *	-k means - do not delete temporary files (debugging option)
 *	-d - diagnostic traces during testing.
 *
 *	This is the index construction/rebuilding program for VIR
 *	by David E. Miran   5/11/82
 */

#include	<stdio.h>
#include	<myio.h>
#include	<signal.h>
#include	"vir.h"
#include	"virfiles.h"
#define		MAXSORT	150000L		/* max number of chars per sort pass */


struct	{
	char	fill1[32];
	long	fxtime;		/* file modified time */
	}	statbuf;	/* stat system call buffer */


long curoff, recoff;	/* current offset into file, start of current record */
char	*progname;
int	pid;
int	vflag	0;	/* set for verbose option */
int	kflag	0;	/* set to keep temp files */
int	scflag	0;	/* set to force scan of all files for holes */
int	dflag	0;	/* debugging */
int	fulflag	0;	/* to force full index reconstruction */
int	status;		/* return status from rsort */
int	ix;		/* current file number - for messages */


int	phase	0;	/* to decide if datadex is killable */
int	packing 0;	/* same */
int	holeflag	0;	/* set if holes found while scanning a file */

extern char mget();
extern long atol();
extern long getpn();
extern quitsig();


struct	dexhead	hrec;		/* HFILE (header file) */
struct	fil_ent	filent[MAXFILE]; /* data file information - HFILE-3 */
struct	fmt_def fmtdef[MAXFMT];	/* format names etc - HFILE-2 */
struct	fmt_inf	fmtinf[MAXFMT];	/* format information (FMTFILE-1) */
struct	fdef	fld[MAXFLD];	/* the format field descriptors - FMTFILE-2 */
struct	pat_ent	prec;		/* one record from PFILE */
struct	num_ent	nrec;		/* one record from NFILE */
struct	sp_ent	srec;		/* one record from SFILE */

char	tbuf[MAXRSIZE], ibuf[MAXRSIZE];	/* terminal and internal buffers */

/* RECORD - information on current record being processed */
int	recsize		0;	/* current expanded record size */
int	rsize;
long	rloc;

/* MISC - miscellaneous variables */

char	rbuf[150];	/* spare line buffer */

int specfld[MAXSPEC], specsize[MAXSPEC], numspf, ppos, psize, npos, nsize;
int yrpos;
struct pat_ent x1, x2, x3;
int pres1, pres2, pres3;
int hfid, fmtfid;
int pfid, nfid, sfid;
long psort, nsort, ssort;
long	rpcnt;
int	pass	0;

/* TEMP - temporary files  */
char	*ntempo		"/tmp/ntempoXXXXXX";
char	*ntempn		"/tmp/ntempnXXXXXX";
char	*ntempns	"/tmp/ntempnsXXXXXX";
char	*ntempx		"/tmp/ntempxXXXXXX";
char	*ptempo		"/tmp/ptempoXXXXXX";
char	*ptempn		"/tmp/ptempnXXXXXX";
char	*ptempns	"/tmp/ptempnsXXXXXX";
char	*ptempx		"/tmp/ptempxXXXXXX";
char	*stempo		"/tmp/stempoXXXXXX";
char	*stempn		"/tmp/stempnXXXXXX";
char	*stempns	"/tmp/stempnsXXXXXX";
char	*stempx		"/tmp/stempxXXXXXX";
char	*packtmp	"/tmp/packtmpXXXXXX";

struct fbuf fbn, fbp, fbs, f1;  /* myio buffers */

long	yr, bas;
long	MEG	1000000L;

main(argc, argv)
int argc;
char **argv;
{
register int i, j, k;
int ifmt;
char c;
int fid;
int st, end;

	progname = *argv;
	phase = 0;
	signal(SIGHUP, &quitsig);
	signal(SIGINT, &quitsig);
	signal(SIGQUIT, &quitsig);
	if (!flock(lockfile)) {
		printf("%s:  sorry - file is locked. Cannot update index.\n",progname);
		exit(1);
	}


	if ((hfid = open(hfile, 2)) < 0) nofile(hfile);
	if ((fmtfid = open(fmtfile, 0)) < 0) nofile(fmtfile);

	read(hfid, &hrec, sizeof hrec);
	read(hfid, &fmtdef[0], MAXFMT * sizeof (struct fmt_def));
	read(hfid, &filent[0], hrec.numfile * sizeof (struct fil_ent));
	read(fmtfid, &fmtinf[0], hrec.numfmt * sizeof (struct fmt_inf));
	read(fmtfid, &fld[0], hrec.nfmtfld*sizeof (struct fdef));
	close(hfid);
	close(fmtfid);

	argv++;		argc--;
	while (argc) {
		if (strcmp(*argv, "-v") == 0) {  /* verbose option */
			vflag = 1;
			goto endw;
		}
		if (strcmp(*argv, "-d") == 0) {  /* debugging option */
			dflag = 1;
			goto endw;
		}
		if (strcmp(*argv, "-k") == 0) {	/* keep temporary files */
			kflag = 1;
			goto endw;
		}
		if (strcmp(*argv, "-scan") == 0) {	/* full scan required */
			scflag = 1;
			goto endw;
		}
		if (strcmp(*argv, "-full") == 0) {	/* full index reconstruction required */
			fulflag = 1;
			goto endw;
		}
		if ((**argv != '+') && (**argv != '-')) {
			strcpy(rbuf, *argv);
addb:
			if (!saccess(rbuf,2)) {
				printf("%s: Access to file %s forbidden\n",progname,rbuf);
				quitsig(51);
			}
			argv++;  argc--;
			i = atoi(*argv);
			if ((i < 1) || (i > hrec.numfmt)) {
				printf("%s:  no such format as %d for file %s\n",progname,i,rbuf);
				quitsig(51);
			}
			addfile(rbuf, i-1);
			goto endw;
		}
		strcpy(rbuf, &argv[0][1]);
		if (**argv == '-') {
			if (rmfile(rbuf)) {
				printf("%s:  file %s cannot be removed, since it is not in the index\n",progname,rbuf);
			}
			goto endw;
		}
		if (**argv == '+') {
			goto addb;
			goto endw;
		}
		printf("%s: invalid argument %s\n",progname,*argv);
		quitsig(51);

endw:
	argc--;		argv++;
	}	/* end of argument processing while loop */

	if (hrec.intnum) fulflag = 1;
	mktemp(ntempo);
	mktemp(ntempn);
	mktemp(ntempns);
	mktemp(ntempx);
	mktemp(ptempo);
	mktemp(ptempn);
	mktemp(ptempns);
	mktemp(ptempx);
	mktemp(stempo);
	mktemp(stempn);
	mktemp(stempns);
	mktemp(stempx);
	mktemp(packtmp);

	for (i=0; i<hrec.numfile; i++) {
chk:
		if (scflag) {  /* prescan all files for holes */
			j = scan(filent[i].f_name);
			if (j > 0) filent[i].f_mode = HOLES;
			if (j < 0) filent[i].f_mode = CURREN;  /* will cause deletion on stat lookup */
		}
		if (filent[i].f_mode == HOLES) {
			j = packit(filent[i].f_name);
			if (j == 0)
				filent[i].f_mode = NOTCUR;
				continue;
		}
		if (filent[i].f_mode != CURREN) continue;
		if (stat(filent[i].f_name, &statbuf) < 0) {
			/* no such file - implies remove from index */
			if (vflag) printf("%s: file %s no longer exists. Removed from index\n",progname,filent[i].f_name);
			for (j = i; j<hrec.numfile-1; j++) {
				ncp(&filent[j], &filent[j+1], sizeof(struct fil_ent));
			}
			hrec.numfile--;
			if (i < hrec.numfile) goto chk;
			continue;
		}
		if (statbuf.fxtime >= hrec.lastup) /* not current */
			filent[i].f_mode = NOTCUR;
	}
/* start - copy the valid parts of the old index files */

	psort = nsort = ssort = 0;
	fid = xcreat(ptempo);
	if (fulflag) goto clop;
	pfid = open(pfile, 0);
	rpcnt = 0;
	mfinit(&f1,fid);
	mfinit(&fbp,pfid);
	while (mgetrec(&prec, sizeof prec, &fbp)) {
		if (prec.p_num == 0L) continue;
		rpcnt++;
		mputrec(&prec, sizeof prec, &f1);
		if (rpcnt >= hrec.pmaxseq) break;
	}
clop:
	mfclose(&f1);
	close(pfid);
	hrec.pmaxseq = hrec.nmaxseq = hrec.smaxseq = 0;
	hrec.maxpnum = 0;
	hrec.pnumbas = hrec.pnumyr = 0L;
	if (hrec.nonspec) goto opn;
	fid = xcreat(stempo);
	mfinit(&f1, fid);	/* f1 is output to temp */
	if (fulflag) goto clos;
	sfid = open(sfile, 0);
	mfinit(&fbs, sfid);
/* copy sfile, deleting non current entries */
	while (mgetrec(&srec, sizeof srec, &fbs)) {
		if (srec.sp_num == 0) continue;  /* deleted */
		i = lookupn(srec.sf_num);
		if (i < 0) continue;  /* file not found */
		if (filent[i].f_mode != CURREN) continue;
		mputrec(&srec, sizeof srec, &f1);
		hrec.smaxseq++;
	}
	close(sfid);
clos:
	mfclose(&f1);
opn:
	fid = xcreat(ntempo);
	mfinit(&f1, fid);	/* f1 is output to temp */
	if (fulflag) goto clon;
	nfid = open(nfile, 0);
	mfinit(&fbn, nfid);
/* copy nfile, deleting non current entries */
	while (mgetrec(&nrec, sizeof nrec, &fbn)) {
		if (nrec.np_num == 0) continue;  /* deleted */
		i = lookupn(nrec.nf_num);
		if (i < 0) continue;  /* file not found */
		if (filent[i].f_mode != CURREN) continue;
		mputrec(&nrec, sizeof nrec, &f1);
		hrec.nmaxseq++;
	}
	close(nfid);
clon:
	mfclose(&f1);
	/* set up to read modified files and reconstruct indexes */
	if (!hrec.nonspec) {
		sfid = xcreat(stempn);
		mfinit(&fbs, sfid);
	}
	pfid = xcreat(ptempn);
	mfinit(&fbp, pfid);
	nfid = xcreat(ntempn);
	mfinit(&fbn, nfid);
	for (ifmt = 0; ifmt< hrec.numfmt; ifmt++) {
/*  pre analyze the format here */
		st = fmtinf[ifmt].st_fld;
		end = fmtinf[ifmt].end_fld;
		numspf = 0;
		if ((fmtinf[ifmt].fmt_mod & PNAME) == 0) {  /* no patient name field */
			ppos = psize = 0;
			goto fx1;
		}
		i = fmtinf[ifmt].fld_nam + st;
		ppos = fld[i].f_pos;
		psize = fld[i].f_size;
fx1:
		npos = nsize = 0;
		if (hrec.intnum) goto fx2;  /* internal patient numbers */
		i = fmtinf[ifmt].fld_pn +st;
		npos = fld[i].f_pos;
		nsize = fld[i].f_size;
		if (hrec.compnum) {
			i = fmtinf[ifmt].fld_pny + st;
			yrpos = fld[i].f_pos + fld[i].f_size - 2;
		}
fx2:
		if (fmtinf[ifmt].fmt_mod & SPECIMEN) {
			for (i = st; i<end; i++) {
				if (fld[i].f_flags & SPECIMEN) {
					specfld[numspf] = fld[i].f_pos;
					specsize[numspf] = fld[i].f_size;
					numspf++;
				}
			}
		}
		if (dflag) printf("fmt %d pnam=%d,%d  pnum= %d,%d  numspf=%d\n",
			ifmt,ppos,psize,npos,nsize,numspf);
		for (i=0; i<hrec.numfile; i++) {
again:
			if (ifmt != filent[i].fmt_cd) continue;
			if (!fulflag) {
				if (filent[i].f_mode == CURREN) continue;
			}
			holeflag = 0;
			fid = open(filent[i].f_name, 0);
			if (fid < 0) {
				printf("%s:  cannot read data file %s - removed.\n",progname, filent[i].f_name);
				rmfile(filent[i].f_name);
				if (i < hrec.numfile) goto again;
				goto fdone2;
			}
			mfinit(&f1, fid);
			curoff = 0;
			ix = i;
getlp:
			getfrec(ibuf, &rsize, &rloc, &f1);
			if (rsize == 0) goto fdone;
			if (rsize < 5) goto getlp; /* not a real record */
			if (dflag) printf("record=%s\n",ibuf);
			expand(ibuf, tbuf, ifmt);
			if (recsize < ppos+1) goto getlp;
			if (recsize < npos+1) goto getlp;
			if (psize == 0) goto getl1;  /* no patient name */
			for (j = 0; j<PNSIZE; j++) {
				c = tbuf[ppos+j];
				if ((c >= 'a') && (c <= 'z'))
					tbuf[ppos+j] = c & 0137;
			}
			ncp(prec.p_name, &tbuf[ppos], PNSIZE);
getl1:
			prec.p_num = getpn();
			nrec.np_num = srec.xp_num = prec.p_num;
			nrec.nf_num = srec.sf_num = filent[i].f_num;
			nrec.f_loc = srec.sf_loc = rloc;
			if (dflag) printf("pnam=%14.14s  pnum = %D  file=%u  loc=%D\n",
				prec.p_name, prec.p_num, nrec.nf_num, nrec.f_loc);
			if (psize == 0) goto getl3;
/* make sure there are no blank name index records */
			for (j=0; j<PNSIZE; j++)
				if (prec.p_name[j] != ' ') goto getl2;
			goto getl3;
/* now make sure there are no leading blanks in patient names */
getl2:
			while (prec.p_name[0] == ' ') {
				for (j=1; j<PNSIZE; j++)
					prec.p_name[j-1] = prec.p_name[j];
				prec.p_name[PNSIZE-1] = ' ';
			}
			mputrec(&prec, sizeof prec, &fbp);
			psort += sizeof prec;
getl3:
			mputrec(&nrec, sizeof nrec, &fbn);
			hrec.nmaxseq++;
			nsort += sizeof nrec;
			for (j=0; j<numspf; j++) {
				if (specfld[j] > recsize) break;
				ncp(rbuf, &tbuf[specfld[j]], specsize[j]);
				rbuf[specsize[j]] = '\0';
				srec.sp_num = atol(rbuf);
				if (srec.sp_num == 0L) continue;
				mputrec(&srec, sizeof srec, &fbs);
				hrec.smaxseq++;
				ssort += sizeof srec;
			}
			goto getlp;
fdone:
			close(fid);
fdone2:
			if ((nsort > MAXSORT) || (ssort >= MAXSORT) || (psort > MAXSORT)) {
				xpass();  /* sort intermediates, merge, and continue */
				nsort = ssort = psort = 0;
			}
			if (holeflag) filent[i].f_mode = HOLES;
			if (vflag) printf("%s:  file %s (re)indexed.\n", progname, filent[i].f_name);
			if (filent[i].f_mode != HOLES)  filent[i].f_mode = CURREN;
		}
	}
	pass = 1;
	endpass(nfile, sfile, pfile, 1);
	/* base files have been built - now build the concentrates. */
	concit(pfile, p1, 16, BSZP);
	concit(p1,p2, 16, BSIZE);
	concit(nfile, n1, 4, BSZN);
	concit(n1, n2, 4, BSIZE);
	if (!hrec.nonspec) {
		concit(sfile,s1,4, BSZS);
		concit(s1, s2, 4, BSIZE);
	}
	if (!kflag) {
		unlink(ntempo);
		unlink(ntempn);
		unlink(ntempns);
		unlink(ntempx);
		unlink(ptempo);
		unlink(ptempn);
		unlink(ptempns);
		unlink(ptempx);
		if (!hrec.nonspec) {
			unlink(stempo);
			unlink(stempn);
			unlink(stempns);
			unlink(stempx);
		}
		unlink(packtmp);
	}
/* close out updated files here */
	time(&hrec.lastup);
	hfid = creat(hfile, 0664);
	i = sizeof hrec;
	j = sizeof (struct fmt_def);
	k = sizeof (struct fil_ent);
	write(hfid, &hrec, i);
	write(hfid, &fmtdef[0], MAXFMT * j);
	write(hfid, &filent[0], hrec.numfile * k);
	close(hfid);
	printf("INDEX updated\n");
	funlock(lockfile);
	exit(0);
}

/*******************************  addfile  **********************************/
/* add a new file to the file table (must not be present already) */

addfile(fname,fmnum)
char *fname;
int fmnum;
{
register int i, j;
	hrec.numfile++;
	if (hrec.numfile > MAXFILE) quitsig(28);
	hrec.maxfile++;
	if (hrec.maxfile > 65530) hrec.maxfile = 1;
	j = hrec.numfile-1;
	filent[j].f_num = hrec.maxfile;
	filent[j].fmt_cd = fmnum;
	filent[j].f_mode = NOTCUR;
	strcpy(filent[j].f_name, fname);
	return(j);
}

/******************************  concit  ***********************************/
/* concit - extract first n chars from each block (of size bs) of a file */

concit(ifile, ofile, n, bs)
char *ifile, *ofile;
int n, bs;
{
int i;
char	buf[BSZP];
int fida, fidb;

	if ((fida = open(ifile, 0)) < 0) {
		printf("cannot open concit ifile %s\n",ifile);
		quitsig(50);
	}
	if ((fidb = creat(ofile, 0664)) < 0) {
		printf("cannot open concit ofile %s\n", ofile);
		quitsig(50);
	}
	mfinit(&f1, fidb);
	while ((i = read(fida, buf, bs)) > 0) {
		mputrec(buf, n, &f1);
	}
	mfclose(&f1);
}

/****************************  endpass  ************************************/
/* endpass - finish sorting new and merging at end or intermediate pass */

endpass(nout, sout, pout, dop)
char *nout, *sout, *pout;
int dop;
{
register int i;
	mfclose(&fbp);
	mfclose(&fbs);
	mfclose(&fbn);

	pid = xfork();
	if (pid == 0)
		execl("/bin/rsort", "rsort", "-s", "18", "-o", ptempns, ptempn, 0);
	else
		i = wait(&status);
		if (status != 0)
			 sorterr(i,status,"ptempn");

	pid = xfork();
	if (pid == 0)
		execl("/bin/rsort", "rsort", "-s", "10", "-i", "-o", ntempns, ntempn, 0);
	else
		i = wait(&status);
		if (status != 0)
			 sorterr(i,status,"ntempn");

	if (hrec.nonspec) goto ns1;
	pid = xfork();
	if (pid == 0)
		execl("/bin/rsort", "rsort", "-s", "14", "-i", "-o", stempns, stempn, 0);
	else
		i = wait(&status);
		if (status != 0)
			 sorterr(i,status,"stempn");
ns1:


	pid = xfork();
	if (pid == 0)
		execl("/bin/rsort", "rsort", "-s", "10", "-i", "-m", "-o", nout, ntempo, ntempns, 0);
	else
		i = wait(&status);
		if (status != 0)
			 sorterr(i,status,"ntempns");

	if (hrec.nonspec) goto ns2;
	pid = xfork();
	if (pid == 0)
		execl("/bin/rsort", "rsort", "-s", "14", "-i", "-m", "-o", sout, stempo, stempns, 0);
	else
		i = wait(&status);
		if (status != 0)
			 sorterr(i,status,"stempns");

ns2:
	if (dop) {  /* final pass - use pmerge */
		pmerge();	/* merge in new pfile entries and strip duplicates */
	}  else  {
		pid = xfork();
		if (pid == 0)
			execl("/bin/rsort", "rsort", "-s", "18", "-m", "-o", pout, ptempo, ptempns, 0);
		else
			i = wait(&status);
		if (status != 0)
			 sorterr(i,status,"ptempns");
	}
}

/*******************************  expand  ************************************/

expand(in, out, fmtyp)
char *in, *out;
int fmtyp;
{
register char c;
register int ic, oc;
int i, j, k, st, end;
	st = fmtinf[fmtyp].st_fld;
	end = fmtinf[fmtyp].end_fld;
	ic = oc = 0;
	for (i=st; i< end; i++) {
		for (j=0; j<fld[i].f_size; j++) {
			c = in[ic++];
			if (c == hrec.recsep) goto quitex;
			if (c == hrec.fldsep) {	/* field padding needed */
				for (k=j; k<fld[i].f_size; k++)  {
					out[oc++] = ' ';
					if (oc >= MAXRSIZE) quitsig(34);
				}
				goto quitfl;
			}
			out[oc++] = c;
			if (oc >= MAXRSIZE) quitsig(34);
		}
/* if data is too large gobble excess characters */
goblp:
		if (ic >= MAXRSIZE) quitsig(34);
		c = in[ic++];
		if (c == hrec.fldsep) continue;
		if (c == hrec.recsep) break;
		goto goblp;
quitfl: ;
	}
quitex:
	out[oc] = '\0';
	recsize = oc;
	return;
}

/******************************  getfrec  ***********************************/
/* getfrec - get next record from a data file */

getfrec(rec, size, loc, fil)
char	*rec;
int	*size;
long	*loc;
struct	fbuf	*fil;
{
	register char c;
	register int i;

	i = 0;
recst:
	recoff = curoff;
glp:
	c = mget(fil);
	if (fil->nrd < 1) {
		*size = 0;
		return;
	}
	curoff++;
	if (c == 0177) {
		holeflag = 1;
		if (i == 0) goto recst;
		goto glp;
	}
	if  ((!hrec.modata) && (c == '\n')) goto glp;
	rec[i++] = c;
	if (i > MAXRSIZE) quitsig(34);
	if (c == hrec.recsep) {
		rec[i] = '\0';
		*size = i;
		*loc = recoff;
		if (c != '\n') {
			c = mget(fil);
			curoff++;
		}
		return;
	}
	goto glp;
}

/*******************************  lookup, lookupn  *************************/
/* look up files in the file table by name or number */

lookup(fname)
char *fname;
{
register int i;
	for (i=0; i<hrec.numfile; i++)
		if (strcmp(fname, filent[i].f_name) == 0) return(i);
	return(-1);
}
lookupn(fnum)
unsigned fnum;
{
register int i;
	for (i=0; i<hrec.numfile; i++)
		if (fnum == filent[i].f_num) return(i);
	return(-1);
}

/****************************  ncp, ncmp ***********************************/
/* ncp - to copy exactly n character regardless */

ncp(os,is,n)
register char *is, *os;
register int n;
{
	while (n--)
		*os++ = *is++;
}

/* ncmp - compare two strings of exactly length n */
ncmp(x, y, n)
char *x, *y;
int n;
{
register int i;
register char c1, c2;
	for (i=0; i<n; i++) {
		c1 = x[i] & 0377;
		c2 = y[i] & 0377;
		if (c1 == c2) continue;
		return(c2-c1);
	}
	return(0);
}

/*******************************  nofile   **********************************/

nofile(fn)
char *fn;
{
	printf("cannot open file %s\n",fn);
	quitsig(51);
}

/*************************  packit  ****************************************/
/* packit - squeeze deleted records out of a file */

packit(file)
char *file;
{
extern char mget();
int fidi, fido;
struct fbuf bufi, bufo;
register int i;
register char c;

	if ((fido = creat(packtmp, 0600)) < 0) {
		printf("cannot create pack temp file %s\n", packtmp);
		return(1);
	}
	if ((fidi = open(file, 2)) < 0) {
		printf("%s:  cannot pack file %s\n", progname,file);
		close(fido);
		return(1);
	}
	mfinit(&bufi, fidi);
	mfinit(&bufo, fido);
lp:
	c = mget(&bufi);
	if (bufi.nrd <1) goto cpback;
	if (c == 0177) goto lp;
	mput(c, &bufo);
	goto lp;
cpback:
	mfclose(&bufo);
	close(fidi);
	packing = 1;
	fido = creat(file, 0664);
	fidi = open(packtmp, 0);
	while ((i = read(fidi, &bufo, BSIZE)) > 0)
		write(fido, &bufo, i);
	close(fidi);
	close(fido);
	packing = 0;
	printf("%s:  file %s packed.\n",progname,file);
	return(0);
}

/******************************  pmerge  ************************************/
pmerge()
{
int fid1, fid2, i;
	pres1 = pres2 = pres3 = 0;
	pfid = xcreat(pfile);
	fid1 = open(ptempo,0);
	fid2 = open(ptempns,0);
	mfinit(&fbn, fid1);
	mfinit(&fbs, fid2);
	mfinit(&fbp, pfid);
	pres1 = get1();
	pres2 = get2();
lp:
	if ((pres1 == 0) && (pres2 == 0)) goto done;
	if (pres1 == 0) goto wr2;
	if (pres2 == 0) goto wr1;
	i = ncmp(&x1, &x2, sizeof x1);
	if (dflag)   /* debugging */
		printf("pmerge comparison - i=%d rec1=%-14.14s %d, rec2=%-14.14s %d\n",i,x1.p_name,x1.p_num,x2.p_name,x2.p_num);
	if (i == 0) {
		pres1 = get1();
		goto lp;
	}
	if (i > 0) {
wr1:
		putr(&x1);
		pres1 = get1();
		goto lp;
	}  else  {
wr2:
		putr(&x2);
		pres2 = get2();
		goto lp;
	}
done:
	mfclose(&fbp);
	close(fid1);
	close(fid2);
	return;
}
get1()
{
	return(mgetrec(&x1, sizeof x1, &fbn));
}
get2()
{
	return(mgetrec(&x2, sizeof x2, &fbs));
}
putr(rec)
char *rec;
{
register int i;
	if (pres3 == 0) goto wr;
	if (ncmp(rec, &x3, sizeof x3) == 0) return;
wr:
	ncp(&x3, rec, sizeof x3);
	if (hrec.intnum) goto wx;
	if (x3.p_num > hrec.maxpnum)  {
		hrec.maxpnum = x3.p_num;
		if (hrec.compnum) {
			yr = hrec.maxpnum/MEG;
			bas = hrec.maxpnum - (yr*MEG);
			hrec.pnumbas = bas;
			hrec.pnumyr = yr;
		}
	}
wx:
	for (i=0; i<PNSIZE; i++)
		if (x3.p_name[i] != ' ') goto wx2;
	goto wy;  /* drop entries with blank patient name */
wx2:
	mputrec(&x3, sizeof x3, &fbp);
	hrec.pmaxseq++;
wy:
	pres3 = 1;
}

/****************************  quitsig  *************************************/
quitsig(val)
int val;
{
	signal(SIGHUP, &quitsig);
	signal(SIGINT, &quitsig);
	signal(SIGQUIT, &quitsig);
	switch (val) {
		default:
			if ((packing == 1) ||(phase == 1)) {
				printf("*** forbidden to kill virdex during file packing or phase 2\n");
				return;
			}
			break;
		case 28:
			printf("%s: no room for new file. Limit is %d\n",progname,MAXFILE);
			goto unl;
		case 34:
			printf("%s: Invalid (oversize) record in file %s begins\n%-70.70s\n",progname,filent[ix].f_name,ibuf);
			break;
		case 50:	break;
		case 51:	goto unl;
	}
quit:
	if (!kflag) {
		unlink(ntempo);
		unlink(ntempn);
		unlink(ntempns);
		unlink(ntempx);
		unlink(ptempo);
		unlink(ptempn);
		unlink(ptempns);
		unlink(ptempx);
		unlink(stempo);
		unlink(stempn);
		unlink(stempns);
		unlink(stempx);
		unlink(packtmp);
	}
unl:
	funlock(lockfile);
	exit(1);
}

/**************************************  rmfile  ****************************/
/* rmfile - remove a file from the index */

rmfile(dfile)
char *dfile;
{
	register int i, j, k;
	k=hrec.numfile;
	i = lookup(dfile);
	if (i < 0) return(1);
	for (j = i; j< (k-1); j++) {
		ncp(&filent[j], &filent[j+1], sizeof(struct fil_ent));
	}
	hrec.numfile--;
	return(0);
}

/******************************  scan  **************************************/
scan(file)
char *file;
{
int fid, nrd;
register int i;
	fid = open(file, 0);
	if (fid < 0) return(-1);
	while ((nrd = read(fid, ibuf, BSIZE)) > 0) {
		for (i=0; i<nrd; i++)
			if (ibuf[i] == 0177) {
				close(fid);
				return(1);
			}
	}
	close(fid);
	return(0);
}

/************************************  sorterr  *****************************/
sorterr(code,stat,x)
char *x;
int code,stat;
{
	printf("%s:  sort error using file %s code= %d  status=%o\n",progname, x, code, stat);
	quitsig(50);
}

/********************  xcreat  ***********************************************/

xcreat(fn)
char *fn;
{
int i;
	i = creat(fn, 0644);
	if (i < 0)  {
		printf("%s:  cannot create file %s\n", progname, fn);
		quitsig(50);
	}
	return(i);
}

/********************************  xfork  ********************************/
xfork()
{
int i;
	i = fork();
	if (i < 0) {
		printf("%s:  cannot fork\n", progname);
		quitsig(50);
	}
	return(i);
}

/*************************  xpass  *****************************************/
/* xpass - manipulate files for an extra pass of sorting */

xpass()
{
	endpass(ntempx, stempx, ptempx, 0);
	unlink(ptempo);
	link(ptempx,ptempo);
	unlink(ptempx);
	pfid = xcreat(ptempn);
	mfinit(&fbp, pfid);
	unlink(ntempo);
	link(ntempx,ntempo);
	unlink(ntempx);
	nfid = xcreat(ntempn);
	mfinit(&fbn, nfid);
	if (!hrec.nonspec) {
		unlink(stempo);
		link(stempx,stempo);
		unlink(stempx);
		sfid = xcreat(stempn);
		mfinit(&fbs, sfid);
	}
}
/*************************  getpn  *****************************************/
/* get patient number from a record */

long getpn()
{
long tmp, tmp2;
	if (hrec.intnum) {
		hrec.maxpnum++;
		return(hrec.maxpnum);
	}
	ncp(rbuf, &tbuf[npos], nsize);
	rbuf[nsize] = '\0';
	tmp = atol(rbuf);
	if (!hrec.compnum) return(tmp);
	ncp(rbuf, &tbuf[yrpos], 2);
	rbuf[2] = '\0';
	tmp2 = atol(rbuf);
	tmp += tmp2 * MEG;
	return(tmp);
}
