/*
Name:
	writeappoint

Function:
	Write an appointment out to the file given placing it in a manner
	such that the appointments remain sorted by time.

Algorithm:
	Read the file a block at a time and scan thru the block until
	an appointment time later than the new one is found.  If no such
	appointment, append the new one at the end.  Otherwise, read from
	the back of the file to the insertion point, a block at a time, and
	rewrite each block several bytes to the right.  The "several" is
	the exact length of the new appointment.  Finally, write out the
	new appointment where it belongs.

Parameters:
	file		name of the appointment file
	appoint		the appointment to be entered

Returns:
	EACCES	Cannot open appointment file

Files and Programs:
	$HOME/exec/appointments/(file)		file to place appointment in

*/
#include <stdio.h>
#include "../../includes/error.h"


writeappoint (file, appoint)

char *file;		/* file name to manipulate */
char *appoint;		/* the appointment entry */

{
   static char id[] = "%W% %H%";

#define WBUF 512			/* size of buffer for reading file blocks */
	char buffer[WBUF+1];	/* the file i/o buffer */
	char *bp;		/* used to point inside buffer */
	char *rbyte;		/* pointer to byte past last one read */
	char *lastnl;		/* pointer to last newline in buffer */
	char ans_buf[256];
	char *answer = ans_buf; /* pointer to last terminal char read */
	int fd;			/* file descriptor */
	int flag;		/* set to 1 if adding to end of file */
	int aplen;		/* length of appoint (not counting null) */
	int insert;		/* spot in file to insert new appointment */
	int pos;		/* used by lseek in hunting around file */
	int len;		/* number chars read/written in updating block */
	int start;		/* start minute of the date (0-2400) */
	int nonewl;		/* true if last buffer had no newline */
	int last_end;		/* end time of previous appointment */
	int next_start;		/* start time of next appointment */
	char temp1,
	     temp2,
	     temp3;
	int  store_end;


	flag = 1;	/* assume we add at end */
	if ((fd = open(file, 2)) == -1   /* does it exist ? */
		&& (fd = creat(file,0644)) == -1)
			return(EACCES);	/* couldn't do it */
	else {
		start = atoi(appoint);	/* start time minute of day */
		temp1 = *(appoint + 4);
		nonewl = 0;
		last_end = -1;		/* none found */
		next_start = 2400;	/* none found */
		while ((rbyte = &buffer[read(fd,buffer,WBUF)]) > buffer ) {
			lastnl = rbyte;
			while (--lastnl >= buffer && *lastnl != '\n');
			if (nonewl) {
				if (lastnl < buffer)
					continue;   /* still none */
			}
			else {
				if (lastnl < buffer)  /* no newlines */
					if ( (next_start = atoi(buffer)) >= start) {
						flag = 0;
						bp = buffer;
						break;
					}
					else {
						last_end = atoi(buffer+6);
						nonewl = 1;
						continue;
					}
				bp = buffer;
				while (bp < lastnl) {
				    temp2 = *(bp + 4);
				    next_start = atoi(bp);
				    if (start == 1200 && temp1 == 'a')
					start = 0;
				    else
				       if (start < 1200 && temp1 == 'p' )
					   start +=  1200;
				       else
					  if (start == 1200 && temp1 == 'p')
					     start = 1200;


				    if (next_start == 1200 && temp2 == 'a')
					next_start = 0;
				    else
				       if (next_start < 1200 && temp2 == 'p' )
					   next_start += 1200;
				       else
					  if (next_start == 1200 && temp2 == 'p')
					     next_start = 1200;
				     if (next_start < start) {
					last_end = atoi(bp+6);
					while (*bp++ != '\n');
				     }
				     else
					break;
				}
				if (bp < lastnl) {
					flag = 0;   /* insert it */
					break;
				}
			}
			nonewl = 0;	/* next buffer starts at line start */
			lseek( fd, lastnl - rbyte + 1, 1);
		}
	}
	aplen = strlen(appoint);	/* need length for write */
	insert = lseek(fd, 0, 1) + (flag ? 0 : bp - rbyte);
			/* place to insert the new one */

       temp3 = *(appoint + 10);
       store_end = atoi(appoint + 6);
       if (store_end == 1200 && temp3 == 'a')
	  store_end = 0;
       else
	  if (store_end < 1200 && temp3 == 'p')
	     store_end += 1200;
	  else
	     if (store_end == 1200 && temp3 == 'p')
		store_end = 1200;

	if (start < last_end || (!flag && store_end > next_start)) {
		printf("\nCONFLICT on %s.  The appointments are:\n\n", file+6);
		lseek(fd, 0, 0);	/* go to file start */
		fflush(stdout);
		while( len = read(fd, buffer, WBUF))
			write(1, buffer, len);
		printf("\n\nDo you wish to add the appointment anyway? (y or n):  ");
		while (!fgets(answer, 256, stdin) || (*answer != 'y'
			&& *answer != 'n'))
			  printf("Enter y or n only:  ");
		if (*answer == 'n') {
			close(fd);
			return;
		}
			
	}
	pos = lseek(fd, 0, 2);		/* current end of file */
	len = WBUF;
	while (pos > insert) {   /* work backwards */
		pos -= WBUF;
		if (pos < insert) {   /* partial block ? */
			len = pos + WBUF - insert;
			pos = insert;
		}
		lseek(fd, pos ,0);	/* go to pos */
		read(fd, buffer, len);
		lseek(fd, pos + aplen, 0);
		write(fd, buffer, len);
	}
	lseek(fd, insert, 0);	/* put it here */
	write(fd, appoint, aplen);
}
