/* conset
 * program the concept 108 terminal to our standard configuration
 * by David E. Miran
 * version of 4/20/83
 */

#define	RMODE	0340
int	ttyorig[3],ttyraw[3];
char	*kt[] {		/* char strings to program the terminal */
		"\033U",	/* programmer mode */
		"\033 F",	/* xon/xoff on */
		"\033 p",	/* parity check off */
		"\033 t",	/* trailing blank suppress off */
		"\033f",	/* text mode */
		"\033s",	/* scroll mode */
		"\033 W",	/* auto wrap on */
		"\033B",	/* auto tab on */
		"\033W",	/* cursor is block */
		"\033  ",	/* insert mode off */
		"\033o$\t",	/* set eof to tab */
		"\033o%\r",	/* set eol to cr */
		"\033o&\003",	/* set eom to ETX */
		"\033Q!\033  \t",	/* turn off insert mode on line 1 */
		"\033 @",	/* set underline to be character, not attribute */
		"\033Q \033 v\t",	/* CTS/RTS off for keyboard */
		"\033Q!\033 v\t",	/* CTS/RTS off for line 1 */
		"\033Q\"\033 v\t",	/* CTS/RTS off for line 2 */
		"\033Q#\033 v\t",	/* CTS/RTS off for line 3 */
"\033 I^\0334&4#\033 3\033 4\0334$B#\033?\033\003\0334$E#\033/! \0334\">",
	"#\033!\0334\".#\033\"\0334\"?#\033(\0334\"/#\0339\0334\"=#\033T\0334\"-#\033t^\0\0\0\0\0\0\0\0\0\0",
		/* program latent expression to set up function keys */
		0};
int	ktl[] {
		2,
		3,3,3,2,2,3,2,2,3,
		4,4,4,
		7,3,
		7,7,7,7,
		37,39,	/* two parts of latent expression */
		0};
/* The following function keys are programmed by the latent expression
	send		clear to end of field/line and send
	f9/f23		transparent mode on/off
	f10		80 column mode
	f24		132 column mode
	f11		local
	f25		remote
	f14		home and clear to end of window
	f28		programmer status display
 */
main()
{
register int i;
	gtty(1, ttyorig);

	ttyraw[0] = ttyorig[0];
	ttyraw[1] = ttyorig[1];
	ttyraw[2] = RMODE;
	stty(0,ttyraw);
	for (i=0; i<1000; i++) {
		if (ktl[i] == 0) goto done;
		write(1,kt[i],ktl[i]);
		if (i%10 == 9) sleep(1);
	}
done:
	stty(0,ttyorig);
	exit(0);
}
