/* dent {[-m] [-k] [-t] [-e] [-c]} formfile datafile
 * very basic (and dumb) formatted data entry program
 * by David E. Miran
 * 4/11/83
 */

#include	"ddefs.h"
#include	<myio.h>
#include	<stdio.h>
#define		SIGHANG	1
#define		SIGINT	2
#define		SIGQUIT	3

char	crtbuf[SCRSIZE];
char	recbuf[MAXRSIZE];	/* record buffer */
int	crtptr, nrdf, iptrf;
char	*ffile, *dfile;		/* format and data files */
int	dset, fset;
int	dfid, ffid;
char	bell[]	"\07";		/* beep at people */
int	ttyo[3], mttyn[3], ttyw[3];	/* for stty */
int	ttyp[3];
/*  ttyo - original modes, n - for block raw, w - for raw, p - normal*/
int	recsize;		/* current record size (actual) */
int	savsize;		/* output (to screen) record size */
int	compsize;		/* compressed record size in recbuf */
int	maxrd	0;
int	maxrec	0;
char	endrec	'@';		/* char to signal end of input */
int	fldmax;			/* number of highest field */
int	ttyspd;
int	hispd	0;	/* set if terminal speed > 4800 baud */
int	lospd	0;	/* set if terminal speed <= 600 baud */
int	recmode	0;	/* record format mode */
char	fldsep	'\'';	/* standard field separator */
char	recsep	'!';	/* standard record end mark */
int	ntry	0;
int	nrd	0;
int	kopt	0;	/* program keys on concept 108 terminal */
#define	B4800	12	/* code for speed 4800 */
#define	B600	8	/* code for speed 600 */

struct	{
	char	f1[9];
	char	size0;
	int	size1;
	char	f2[24];
	}	sbuf;
int	uid, gid, setid;

struct fdef fld[MAXFLD];	/* field descriptors */
char	*termfile  "/etc/termftype";
char	*progname;
long	fsize;

extern int dlymode;
extern int quitsig();
extern int fmto_l, cls_l, nrec_l;
extern char *fmto, *cls, *nrec;
extern char eor;
extern int warn;
extern int termtype;
extern int slomode;

#ifdef	DEBUG
char	diagfile[]	"DIAG";
int	diag;
#endif

#ifdef DUMBKEY
/*  FUNCTION MEMORY - for dumb function key support on et2, dgx, and v400 terminals */
#define	FUNCSIZE	1000
#define	NUMFUNC	10
extern char simlow, simhigh;
extern int simfunc;
char	funcmem[FUNCSIZE];	/* programmable function memory */
int	funcst[NUMFUNC];	/* pointers to start of functions */
int	funclen[NUMFUNC];	/* function lengths */
int	funcmax	0;
/* date setting code */
long	atime;
char *chtime, date[8];
extern char *ctime();
char *mname[] {
	"Jan", "Feb", "Mar", "Apr", "May", "Jun",
	"Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
	};
char *mnum[] {
	"01", "02", "03", "04", "05", "06",
	"07", "08", "09", "10", "11", "12"
	};
#endif
char	*keyfile	"KEYTEXT";
char	*keyprog	"keyset";

main(argc, argv)
int argc;
char **argv;
{
register int i;
register char c;

	dset = fset = 0;
	progname = *argv;
	gtty(0,ttyo);
	ttyp[0] = ttyw[0] = mttyn[0]=ttyo[0];
	mttyn[2] = IMODE;
	ttyp[1] = ttyw[1] = 0;	/* no erase or kill */
	ttyw[2] = RMODE;	/* raw mode */
	ttyp[2] = NMODE;	/* normal, no scroll, etc */
	ttyspd = ttyo[0]&0377;
	if (ttyspd > B4800) hispd = 1;
	if (ttyspd <= B600) lospd = 1;
	if (argc < 3) {
usage:
		printf("usage: %s [-opt] format datafile\n",progname);
		exit(1);
	}
	argv++;  argc--;
	while (argc) {
		if (**argv == '-')  {
			switch (argv[0][1]) {
				case 't':
					tset(2);
					break;
				case 'e':
					tset(3);
					break;
				case 'c':
					tset(4);
					break;
				case 'k':
					kopt++;
					break;
				case 'm':
					recmode = 1;
					recsep = '\0';
					fldsep = ':';
					break;
				default:
					printf("unknown option: %s\n", *argv);
					exit(1);
			}
		goto endw;
		}
		if (fset == 0) {
			ffile = *argv;
			fset = 1;
		}  else  {
			if (dset == 0) {
				dfile = *argv;
				dset = 1;
			}  else {
				goto usage;
			}
		}
endw:
		argc--;   argv++;
	}
	if ((fset == 0) || (dset == 0)) {
		printf("must specify format and dataset names\n");
		exit(1);
	}
	i=0;
	while (c=dfile[i++]) {
		if (c < 040) {
			printf("invalid dataset name\n");
			exit(1);
		}
	}
		if (termtype == 0) termset(0);
	if (termtype == 0) {
		printf("unknown terminal type\n");
		exit(1);
	}
#ifdef DUMBKEY
	if (simfunc) {
		if (!funcset()) simfunc = 0;
		/* if function loading fails turn off the feature */
	}
#endif
	if (saccess(ffile, 4) == 0) {
		printf("Cannot read format file %s\n",ffile);
		exit(1);
	}
	if (saccess(dfile, 2) == 0) {
		printf("Cannot write data file %s\n",dfile);
		exit(1);
	}
	if ((dfid = open(dfile, 2)) < 0) {
		if ((dfid = creat(dfile, 0664)) < 0) {
			printf("Cannot create data file %s\n", dfile);
			exit(1);
		}
		uid = getuid()&0377;
		gid = getgid()&0377;
		setid = uid | (gid<<8);
		chown(dfile, setid);
	} else {
		seek(dfid, 0, 2);
	}
#ifdef DEBUG
	diag = creat(diagfile,0666);
#endif
	mttyn[1] = eor<<8|IBSIZE;
	if (termtype == 4) { /* concept 108 */
		keyfile = "CKEYTEXT";
		keyprog = "ckeyset";
	}
	if ((termtype == 2) || ((termtype == 4) && (kopt == 1))) { /* teleray or concept */
		i = fork();
		if (i < 0) {
kzz:
			printf("%s: fork or exec failed for keyset\n",progname);
			exit(1);
		}
		if (i == 0) {
			execl("/usr/bin/keyset",keyprog,keyfile,0);
			goto kzz;
		}
		i = wait(&nrd);
		nrd = nrd>>8;
		if ((i < 0) || nrd) goto kzz;
	}
	if (warn)	{
		printf("\07*****  SET  BLOCK  MODE  *****\07\n");
		sleep(2);
	}
	if ((ffid = open(ffile, 0)) < 0) {
		printf("Cannot open format file %s\n",ffile);
		exit(1);
	}
	putform(ffid);
	close(ffid);

/* we now have opened the data file and loaded the format.
 * set up the terminal modes, priority, and start processing */

	stty(0, ttyw);
	if (nrec_l) write(1,nrec,nrec_l);
	signal(SIGHANG, &quitsig);
	signal(SIGINT, 1);
	signal(SIGQUIT, 1);

inloop:
	waitrdy();
	get_trec();
	if (!lospd) lock(0);	/* unlock process */
	nice(LOPRI);
#ifdef DEBUG
	write(diag,crtbuf,recsize);
#endif
	i=0;
	while (crtbuf[i] < 040) i++;
	if (crtbuf[i] == endrec) goto done;
	compress();	/* squeeze out field separators */
	if (valchk()) {		/* return 1 if record is ok */
		put_frec();
		write(1, bell, 1);
		if (nrec_l) write(1, nrec, nrec_l);
		goto inloop;
	}
/* process here if record is bad */
/* clear screen, 2 beeps, send record back with ??, 1 more beep */
	write(1,bell,1);
	write(1,bell,1);
	write(1,cls,cls_l);
	sleep(1);
	stty(0,ttyp);
	puff(crtbuf,1);
	write(1,bell,1);
	if (nrec_l) write(1, nrec, nrec_l);
	goto inloop;

done:
	cleanup();
	exit(0);
}

cleanup()
{
extern int fmto_l;
extern char *fmto;
	close(dfid);
	write(1,fmto,fmto_l);
	stty(0, ttyo);
	printf("\nmax read %d chars, max rec %d chars\n", maxrd, maxrec);
	stat(dfile,&sbuf);	/* get file size and print it */
	l3tol(&fsize, &sbuf.size0,1);
	printf("\nfile %s has %D characters\n\n",dfile,fsize);
	if (warn)
		printf("\07*****  CLEAR  BLOCK  MODE  *****\07\n");
}

quitsig()
{
	if (!lospd) lock(0);
	cleanup();
	if (ntry > 2) {
		printf("%s:  Unable to read record in 3 tries. Call systems programmer\n",progname);
	}  else  {
		printf("%s:  Killed by keyin\n", progname);
	}
	exit(1);
}

/* waitrdy - wait until signaled that a page is ready, then lock
 * 	     process in core (exclusively), raise priority, and start xmit.
 */

waitrdy()
{
extern char inrdy;
extern char *ok;
extern int ok_l;
char ch, xch;
register int i;
int nrd;

	stty(0,ttyw);	/* regular raw mode */
wtinit:
	i=0;
rdlp:
	nrd = read(0, &ch, 1);
	if (nrd < 1) goto rdlp;
	ch &= 0177;
	if ((ch < 040) || (ch == 0177)) goto ckin;
	crtbuf[i++] = ch;
ckin:
	if (ch != inrdy) goto rdlp;
#ifdef DUMBKEY
	if (simfunc) {  /* check for function key request */
		xch = crtbuf[0];
		if ((xch >= 'A') && (xch <= 'Z')) xch = xch - 'A' + simhigh;
		/* fold shifted f1-f4 on et2 to same as f5-f8 on other terminals */
		if ((xch > simlow) && (xch <= 'z')) {
			funcdo(xch);
			goto wtinit;
		}
	}
#endif
	stty(0,mttyn);	/* block raw mode */
	if (!lospd) lock(1);	/* wait on core lock) */
	nice(HIPRI);
	write(1,ok,ok_l);	/* trigger transmit */
	return;
}

/* get_trec - read 1 record from terminal up to ETX, using block raw mode */

get_trec()
{
extern int errno, fmto_l;
extern char *fmto;
extern char eor;
register int curcnt;
register int i;
int nrd;

	ntry = 0;
inst:
	curcnt = 0;
inlp:
	nrd = read(0, &crtbuf[curcnt], 512);
	if (nrd <1) {
		/* error - help */
		cleanup();
		printf("Read error from terminal - nrd=%d, errno=%d\n", nrd, errno);
		exit(1);
	}
	for (i=curcnt; i<curcnt + nrd; i++)  {
		if (crtbuf[i] == eor) break;
		if (crtbuf[i] == 0) goto lost;
	}
	curcnt =+ nrd;
	if (nrd > maxrd) maxrd = nrd;
	if (crtbuf[curcnt-1] == eor) goto gotrec;
	if (crtbuf[curcnt-2] == eor) goto gotrec;
	goto inlp;
lost:		/* we lost input due to ttyhog limit - trigger retransmit */
	if (ntry++ > 3) quitsig();
	sleep(1);
	stty(0,mttyn);
	write(1,ok,ok_l);	/* trigger retransmit */
	goto inst;
gotrec:
	recsize = curcnt;
	if (recsize > maxrec) maxrec = recsize;
}

/* compress - squeeze out field separators */

compress()
{
register int i, j;
register char c;
int fs, f;
	j=0;
	for (i=0; i<recsize; i++) {
		c = crtbuf[i] &0177;
		if (c == eor) goto done;
		if ((c < 040) || (c == 0177)) continue;
		crtbuf[j++] = c;
	}
done:
	recsize = j;
}

/* valchk - check record for validity - return 1 if ok, else 0 */

valchk()
{
register int f, i;
register char c;
int flag, err, st, len, j;
int	endp;

	err = f = 0;

fldlp:
	len = fld[f+1].f_pos - fld[f].f_pos;
	st = fld[f].f_pos;
	flag = fld[f].f_flags;
	endp = st+len;

	if (( flag & (LCASE|NUMERIC|ALPHA|REQUIRED)) == 0) goto fold;
	if (st >= recsize) goto ck_r;	/* past end - check if required field */
	if (flag & NUMERIC) {	/* check numeric only field (also spaces) */
		for (i=st; i<endp; i++) {
			if (i >= recsize) break;
			c = crtbuf[i];
			if ((c >= '0') && (c <= '9')) continue;
			if (c == ' ') continue;
			err++;
			crtbuf[i] = '?';
		}
	}	/* end of numeric checking */

	if (flag & ALPHA) {	/* check alpha only field (also spaces) */
		for (i=st; i<endp; i++) {
			if (i >= recsize) break;
			c = crtbuf[i];
			if ((c>='a') && (c <= 'z')) continue;
			if (c == ' ') continue;
			if (c == '-') continue; /* hyphenated names */
			if ((c >= 'A') && (c <= 'Z')) continue;
			err++;
			crtbuf[i] = '?';
		}
	}	/* end of alpha checking */

ck_r:		/* checking for required field */
	if (flag & REQUIRED) {
		for (i=st; i<endp; i++) {
			if (i >= recsize)	{  /* missing required field after end of input */
				for (j = recsize; j<endp; j++)	/* pad up to current location */
					crtbuf[j] = ' ';
				recsize = endp+1;		/* update record size */
				goto missing;
			}
			if (crtbuf[i] != ' ') goto r_done;	/* something found */
		}
missing:
		crtbuf[st] = '?';
		err++;
	}
r_done:
	if (st >= recsize) goto nextf;
	if (flag & LCASE) goto nextf;	/* do not fold to upper case */
fold:	/* convert to all upper case unless LCASE set */
	for (i=st; i<endp; i++) {
		if (i >= recsize) break;
		c = crtbuf[i];
		if ((c < 'a') || (c > 'z')) continue;
		crtbuf[i] = c & 0137;	/* mask off lower case bit */
	}

nextf:
	f++;
	if (f <= fldmax) goto fldlp;
	if (err) return(0);
	return(1);
}

/* put_frec - write a record into the data file, putting in field
 * separators and squeezing out trailing blanks
 */

put_frec()
{
register int i, spcnt;
register char ch;
int ccnt;
int f, fs;

	spcnt = ccnt = i = compsize = f = 0;
lp:
	fs = fld[f++].f_size;
clp:
	if (i == recsize) goto backlp;
	ch = crtbuf[i++];
	fs--;
	if (ch == ' ') {
		spcnt++;
		goto nextc;
	}
	while (spcnt > 0) {
		xput(' ');
		ccnt++;
		spcnt--;
		if ((recmode == 0) && (ccnt == 80)) {
			xput('\n');
			ccnt = 0;
		}
	}
	xput(ch);
	ccnt++;
	if ((recmode == 0) && (ccnt == 80)) {
		xput('\n');
		ccnt = 0;
	}
nextc:
	if (fs) goto clp;
	spcnt = 0;
	xput(fldsep);
	ccnt++;
	if ((recmode == 0) && (ccnt == 80)) {
		xput('\n');
		ccnt = 0;
	}
	if (f < fldmax) goto lp;
backlp:
	i = compsize-1;
	if ((recbuf[i] == fldsep) || (recbuf[i] == '\n')) {
		compsize--;
		if (compsize) goto backlp;
		return;
	}
	if (recsep) xput(recsep);
	xput('\n');
	write(dfid, recbuf,compsize);
}

xput(c)
char c;
{
	recbuf[compsize++] = c;
}
/*****************************************************************************/
/* puff - put a timing null as appropriate for output */

puff(rec,pmode)
char *rec;
int pmode;
{
register i;
extern int termtype;
extern char outtab;
struct fbuf fpr;
register int f, fs;

	mfinit(&fpr, 1);
	for (i = 0; i<recsize; i++) {
		if (hispd) {
			switch (dlymode) {
				case 2:	/* most buffered terminals */
					if (i%25 == 0)
						mputrec("\0\0", 2, &fpr);
				default:  break;
			}
		}
		mput(rec[i], &fpr);
	}
done:
	mflush(&fpr);
}

#ifdef DUMBKEY
/*********************************  funcset  *************************************/
/* funcset - read in keyfile and set up for pseudo programmable function keys */

funcset()
{
register int num;
register char c;
register int i;
struct fbuf fibuf;
int fid, ccnt, nulcnt;
char sp[3];
	if ((fid = open(keyfile, 0)) < 0) return(0);
	seek(fid,16,0);	/* skip a.out header */
	mfinit(&fibuf, fid);
	for (ccnt=0; ccnt<NUMFUNC; ccnt++) funclen[ccnt] = 0;
/* set up current date in f8 */
	time(&atime);
	chtime = ctime(&atime);
	for (i=0; i<12; i++) {
		if (strncmp(&chtime[4], mname[i], 3) == 0) {
			strncpy(date, mnum[i], 2);
			break;
		}
	}
	strncpy(&date[2], &chtime[8], 2);
	strncpy(&date[4], &chtime[22], 2);
	for (i=0; i<6; i++) {
		if (date[i] == ' ') date[i] = '0';
	}
	strncpy(funcmem,date,6);
	funcmax = 6;
	funclen[6] = 6;
	funcst[6] = 0;
init:
	ccnt = 0;
	nulcnt = 0;
lp:
	c = mget(&fibuf);
	if (fibuf.nrd < 1) goto done;
	if ( c == '\0') goto lp;
	sp[ccnt++] = c;
	if (ccnt < 2) goto lp;
	sp[2] = '\0';
	num = atoi(sp);
	num -= 2;
	funcst[num] = funcmax;
	funclen[num] = 0;
lp2:
	c = mget(&fibuf);
	if (fibuf.nrd < 1) goto done;
	if (c == '\0') goto lp2;
	goto lp3b;
lp3:
	c = mget(&fibuf);
	if (fibuf.nrd < 1) goto done;
	if (c == '\0') {
		nulcnt++;
		if (nulcnt >=3) goto onedone;
		goto lp3;
	}
lp3b:
	funcmem[funcmax++] = c;
	funclen[num]++;
	goto lp3;
onedone:
	goto init;
done:
	close(fid);
	return(1);
}
/***********************************  funcdo  ******************************/
/* funcdo - imitate a real function key */

funcdo(ch)
char ch;
{
int fnum, savrs;
	fnum = (ch - simlow) -1;
	if (funclen[fnum] == 0) goto donit;
	savrs = recsize;
	recsize = funclen[fnum];
	puff(&funcmem[funcst[fnum]], 0);
	recsize = savrs;
donit:
	return;
}
#endif
