/* putform
 * load a format onto a crt screen
 * also save info about the structure of the format
 *
 * by David E. Miran, Wisconsin State Hygiene Lab
 * version of 4/20/83
 */

#include	"ddefs.h"
#include	"myio.h"

int	p_pos;		/* position of patient name field */
int	p_size;		/* size of patient name field */
int	progset	0;	/* set after teleray function key programmed */

/* character sequences for controlling crt terminals

 * form of this collection of items is as follows:
	x - a character pointer which can be pointed at the right string.
	x_l - a variable which can be set to the length of the string.

*/

/* the following sequences are:
	the char pointer variable
	the char count variable
	the character strings for sb2, try, et2, concept 108 terminals
	the corresponding counts
 */

char	*init;			/* init setup of a format */
int	init_l;
char	*initx[]	{
		0,
		"\033E\0\0\0",	/* clear screen - ESC E */
		"\024\014\0\0\033RP",	/* printer port off, clear screen, protect mode*/
		"\033\020\0\0\0\033\016\0\0\0\033\01", /* clear, inv scrn, inv char */
		"\033U\033\010A@ \033 r\033S\033i\033v  8p\033V\014\033I",
		/* prog mode, def clr characteristics,replace char and attribute, page, protect off,
		 * window (24*80), clear all, protect on */
		0 };
int	initlx[]  {0,5,7,12,26,0};

char	*strt;			/* start of data field */
int	strt_l;
char	*strtx[]	{
		0,
		"\033_1[\033[",
		" \033RD",
		" [\033\01",
		" \033D \033i",
		0};
int	strtlx[]	{0, 6, 4, 4, 6, 0};

char	*endf;			/* end of data field */
int	endf_l;
char	*endfx[]	{
		0,
		"\033]]\033_3",
		"\033RP ",
		"\033\01] ",
		"\033I \033d ",
		0};
int	endflx[]	{0, 6, 4, 4, 6, 0};

char	*fin;			/* end of format loading */
int	fin_l;
char	*finx[]		{
		0,
		"\033W\0\0\033E\0\0\0\033k",
		"\033RP\033W\014",
		"\033\01\033\027\033\020",
		"\033F\0\0\0\033&\0\0\0\0\033i\033d\033 R\033u\033?\033\003\t\0\0\0",
			/* forms, block, prot off, rev vid off, replace char only, usr mode, clear, tab */
		0};
int	finlx[]		{0,11,6,6,28,0};

char	*eol;			/* processing at end of format line */
int	eol_l;
char	*eolx[]		{
		0,
		0,
		"\033RP",	/* on try must reset protect */
		0,
		0,
		0 };
int	eollx[]		{ 0,0,3,0,0,0};
/* no end of line processing for other terminals */

char	*cls;			/* clear screen */
int	cls_l;
char	*clsx[]	{
		0,
		"\033E\0\0\0",
		"\014\0\0\0",
		"\033\020\0\0\0",
		"\033?\033\003\t",
		0};
int	clslx[]		{0, 5, 4, 5, 5, 0};
char	*ccls	"\033?\033\003";
int	cclsl	4;

char	*fmto;			/* format off and clear - when all done */
int	fmto_l;
char	*fmtox[]	{
		0,
		"\033X\0\0\033E\0\0\0",
		"\033X\014\0\0\0",
		"\033\027\033\016\0\0\0",
		"\033U\0\0\0\0337\0\0\0\0\033d\033f\033s\033?\014\033u\0\0\0",
			/* prog,block off,rev vid off,text,scroll,home,clrall,usr */
		0};
int	fmtolx[]	{ 0, 9, 6, 7, 26, 0};

char	*nrec;		/* set up for next record */
int	nrec_l	0;
char	*nrecx[]	{
		0,
		"\033H\0\0\0\033k",	/* go off-line */
		"\033H",
		"\033H",
		"\033?\t",	/* home */
		0};
int	nreclx[]	{0, 7, 2, 2, 3, 0};
char	*cnrec	"\033?";
int	cnrecl	2;

char	*ok;		/* char string to initiate page transmit */
int	ok_l;
char	*okx[]	{
		0,
		"\027",	/* ctrl w */
		"\033Z",	/* esc Z */
		"\033\025",	/* esc ctrl u */
		"\033\004",
		0};
int	oklx[]	{0, 1, 2, 2, 2, 0};

/* char string to initiate a transmit line function */
char	*rdln;
int	rdln_l	0;
char	*rdlnx[]	{
		0,
		0,
		0,
		"\033\032",
		0,
		0};
int	rdlnlx[]	{0, 0, 0, 2, 0, 0};


char	eor;		/* end of record character */
char	eorx[]	{ '\012', ETX, ETX, '\015', ETX, '\0'};
int	warn	1;	/* set if warning about block mode needed */
int	warnx[]	{0, 0, 1, 1, 0, 0};
int	termtype	0;	/* set to terminal type 1=sb2, 2=telry, 3= et2 , 4=concept108 */
int	scrwid		80;	/* screen width */
int	padln		1;	/* set if lines must be padded out to scrwid */
char	inrdy	ETX;		/* char to wait for which signals page ready */
char	inrdyx[]	{ '\n', '\021', ETX, '\015', ETX, '\0'};
int	lnmode	0;	/* single line availability - 0=not avail, 1= rdln to get, 2=given with transmit request (teleray) */
int	lnmodex[]	{0, 0, 2, 1, 2, 0};
int	dlymode	2;	/* style of output delay
			 * 0= none, 1=sb2 (alternate null and char in raw mode
			 * 2=buffered - timing delay every 50 chars */
int	dlymdx[]	{ 0, 1, 2, 2, 3, 0};

/*******************************  termset  ***********************************/

/* termset - lookup terminal type */
termset(tp)
char tp;
{
char c;
char termrec[4];
struct fbuf fpr;
int fid;
extern char *termfile;

	c = tp;
	if (tp) goto setit; /* explicit specification */
	c = ttyn(0);
	if (c == 'x') goto setit;
	if ((fid = open(termfile, 0)) < 0) {
		printf("Cannot open %s\n", termfile);
		goto setit;
	}
	mfinit(&fpr, fid);
	while (mgetrec(termrec, 4, &fpr)) {
		if (c != termrec[0]) continue;
		goto gotterm;
	}
	close(fid);
	goto setit;
gotterm:
	c = termrec[2];
	close(fid);
setit:
	switch (c) {
		case 't':
			tset(2); break;
		case 'e':
			tset(3); break;
		case 'c':	/* concept 108 */
			tset(4);
			break;
		default:
			termtype=0;
	}
}

/* routine to set up codes for various terminal types
 */

tset(t)
register int t;
{
	init = initx[t];
	init_l = initlx[t];
	strt = strtx[t];
	strt_l = strtlx[t];
	endf = endfx[t];
	endf_l = endflx[t];
	fin = finx[t];
	fin_l = finlx[t];
	eol = eolx[t];
	eol_l = eollx[t];
	cls = clsx[t];
	cls_l = clslx[t];
	fmto = fmtox[t];
	fmto_l = fmtolx[t];
	nrec = nrecx[t];
	nrec_l = nreclx[t];
	ok = okx[t];
	ok_l = oklx[t];
	rdln = rdlnx[t];
	rdln_l = rdlnlx[t];
	eor = eorx[t];
	warn = warnx[t];
	inrdy = inrdyx[t];
	lnmode = lnmodex[t];
	dlymode = dlymdx[t];
	termtype = t;
}
putform(fid)
int fid;
{
extern struct fdef fld[MAXFLD];
extern int fldmax;
register char ch, nch;
extern int ttyo[3];
register int i;
int lnum, fnum, fprog, curpos, lpos;
struct fbuf ffin, fout;
extern int ttyp[];
extern char *progname;
int	fixsize;	/* set if explicitly declared field size */

	seek(fid, 0, 0);
	stty(1,ttyp);
	mfinit(&ffin,fid);
	mfinit(&fout, 1);
	lpos = lnum = fprog = curpos = 0;
	fnum = -1;
	mputrec(init, init_l, &fout);
	mflush(&fout);
	if (eol_l) lpos++;  /* init takes 1 char on teleray */
	ch=mget(&ffin);   nch = mget(&ffin);

put_lp:
	if ((ch == ' ') && (nch == '[')) {	/* start of data field */
		mputrec(strt, strt_l, &fout);
		lpos =+ 2;
		ch = mget(&ffin);  nch = mget(&ffin);
		fnum++;
		fprog++;
		fld[fnum].f_size = 0;
		fld[fnum].f_lims = 0;
		fld[fnum].f_flags = 0;
		fld[fnum].f_pos = curpos;
		fixsize = 0;
		goto put_lp;
	}
	if (( ch == ']') && ((nch == ' ') || (nch == '\n'))) { /* end of data field */
		if (fixsize > 0) fld[fnum].f_size = fixsize;
		if (fld[fnum].f_flags & PNAME) {
			p_pos = fld[fnum].f_pos;
			p_size = fld[fnum].f_size;
		}
		for (i=0; i<fld[fnum].f_size; i++) {
			mput(' ',&fout);
			lpos++;
			curpos++;
		}
		mputrec(endf, endf_l, &fout);
		lpos =+ 2;
		if (nch == '\n') {
			ch = nch;
		}  else  {
			ch = mget(&ffin);
		}
		nch = mget(&ffin);
		fprog = 0;
		goto put_lp;
	}
	if (ch == '\n') {
		if (lpos > scrwid) goto err;
		lnum++;
		if (lnum == PAGELEN) goto endform;
		if (padln) {
			while (lpos<scrwid) {
				mput(' ', &fout);
				lpos++;
			}
		} else {
			mputrec("\r\n",2,&fout);
		}
		lpos = 0;
		ch = nch;
		nch = mget(&ffin);
		if ((ch == 0) || (nch == 0)) goto endform;
		if (lnum >= PAGELEN) goto endform;
		mputrec(eol, eol_l, &fout);
		if (eol_l) lpos++;
		goto put_lp;
	}
	if (!fprog) {
		mput(ch, &fout);
		lpos++;
	}
	if (fprog)  {	/* a data field is in progress */
		fld[fnum].f_size++;
		switch (ch)	{ /* set up descriptor */
			case ' ':	/* blanks - skip */
			case 'B':
				break;
			case 'L': fld[fnum].f_flags =| LCASE; break;
			case '9': fld[fnum].f_flags =| NUMERIC; break;
			case 'R': fld[fnum].f_flags =| REQUIRED; break;
			case 'A': fld[fnum].f_flags =| ALPHA; break;
			case 'D': fld[fnum].f_flags =| DATE; break;
			case 'N': fld[fnum].f_flags =| LABNUM; break;
			case 'P': fld[fnum].f_flags =| PNAME; break;
			case 'H': fld[fnum].f_flags =| DNAME; break;
			case 'C': fld[fnum].f_flags =| CITY; break;
			case 'X': fld[fnum].f_flags =| RANGE; break;
			case 'l':	/* field length spec */
				fixsize = (nch - '0') & 0177;
				ch = nch;
				nch = mget(&ffin);
				break;
			case 'a':
			case 's':
				ch = nch;
				nch = mget(&ffin);
				fld[fnum].f_size++;
				break;
			case 'S':
			case 'p':
			case 'c':
				break;	/* only functional in vir */
			default:
				goto err;
		}
	}
	ch=nch;
	nch=mget(&ffin);
	if (ch == 0) goto endform;
	goto put_lp;

endform:
	fld[fnum+1].f_pos = curpos;
	mputrec(fin, fin_l, &fout);
	mflush(&fout);
	fldmax = fnum;
	return(0);
err:
	write(1,fmto,fmto_l);
	stty(0,ttyo);
	sleep(1);
	printf("%s:  Error in format in line %d, where first line is zero.\n",progname,lnum);
	printf("lnum=%d, lpos=%d, curpos=%d,fnum=%d,ch=%c,nch=%c\n",lnum,lpos,curpos,fnum,ch,nch);
	if (warn)
		printf("\07*****  CLEAR BLOCK MODE  *****\07\n");
	exit(1);
}
