/*
 * char *getwd()
 * get current working directory
 * by David E. Miran
 * 12/2/81
 */
#include	<myio.h>
#ifdef DEBUG
#include	<stdio.h>
#endif

char	dot[]	= ".";
char	dotdot[] = "..";
char	*root	"/";
char	*sdev	"/dev";
char	*mtab	"/etc/mtab";

getwd(oname)
char *oname;
{
	register int i, curi, curd;
	int rdev, rino;
	int j, fid;
	struct sbuf {
		int dev;
		int ino;
		char	fil1[8];
		int	bdev;	/* device code for block special device */
		char	fil2[22];
		} d, dd;
	struct {
		int dino;
		char dirname[14];
		} dir;
	struct {
		char	dname[32];
		char	devname[32];
		}  mount;
	char	buf[512];	/* name buffer */
	int	bpos;
	struct	fbuf	ibuf;

	stat("/", &d);
	rdev = d.dev;
	rino = d.ino;
	bpos = 511;
	stat(dot,&d);
lp:
	curi = d.ino;
	curd = d.dev;
	chdir(dotdot);
	stat(dot,&dd);
	if ((dd.ino == curi) && (dd.dev == curd)) goto devtop;
	fid = open(dot,0);
	mfinit(&ibuf,fid);
	while (mgetrec(&dir, sizeof dir, &ibuf)) {
		if (dir.dino != curi) continue;
		for (i=13; i>= 0; i--)
			if (dir.dirname[i]) buf[bpos--] = dir.dirname[i];
		buf[bpos--] = '/';
		break;
	}
	close(fid);
	d.ino = dd.ino;
	d.dev = dd.dev;
	goto lp;
/* we have reached the root of a file system.
 * If this is the root file system we are done, otherwise find out where we are mounted.
 */

devtop:
	if ((rdev == curd) && (rino == curi)) goto done;
	chdir(sdev);
	fid = open(mtab,0);
	while ((read(fid, &mount, sizeof mount) == sizeof mount)) {
		stat(mount.devname,&d);
#ifdef DEBUG
	fprintf(stderr,"devtop: devname=%s dname=%s d.bdev=%o curd=%o\n",mount.devname,mount.dname,d.bdev,curd);
#endif
		if (d.bdev != curd) continue;
		for (i=31; i>=0; i--)
			if (mount.dname[i]) buf[bpos--] = mount.dname[i];
		break;
	}
	close(fid);
done:
	for (i=bpos+1; i<512; i++)
		*oname++ = buf[i];
	j = 511 - bpos;
#ifdef DEBUG
	fprintf(stderr,"return: j=%d bpos=%d\n",j, bpos);
#endif
	return(j);
}
