/*
 * rjeclock
 * this is a 30 second timer which will signal ntr every 30 seconds
 * to help decide if the Univac 1100 has timed out.
 *
 * By:   David E. Miran
 *       Wisconsin State Hygiene Lab
 *
 * October 14, 1982
 */

#include	"../ntr/rjedef.h"
#include	"../ntr/rjefiles.h"

int	fid;			/* spare file descriptor */
int	protpid;


main(argc, argv)
int argc;
char ** argv;
{
	sleep(30);	/* let ntr get up and running */
	if ((fid = open(pidfile, 0)) < 0) {
		printf("clock: cannot get ntr's process id\n");
		exit(1);
	}
	read(fid, &protpid, 2);
	close(fid);
	if (protpid == 0) {
		printf("clock:  ntr not active - clock shutting down\n");
		exit(1);
	}
lp:
	sleep(NSEC);
	if ((kill(protpid, CLOCK)) < 0) {
		printf("clock:  ntr gone - clock shutting down\n");
		exit(1);
	}
	goto lp;
}
