#
/* rmjob trnum  ...
 * remove all the files associated with a job
 *
 * by David E. Miran
 * 4/22/81
 */

#include	<stdio.h>
#include	"../ntr/rjedef.h"
#include	"../ntr/rjefiles.h"

int	uid, gid, setid, rjeown;
char	upjob[7];
struct	{		/* returned from a stat system call */
	char	fill1[4];
	int	flags;
	char	fill2;
	char	fuid;
	char	fgid;
	char	size0;
	char	sizew;
	char	fill3[20];
	long int modtime;
	}	sbuf;


main(argc, argv)
int argc;
char **argv;
{
register int i, j;
register char c;

	uid = getuid()&0377;
	gid = getgid()&0377;
	setid = uid|(gid<<8);
	rjeown = SITUID | (SITGID<<8);
	if (argc < 2) {
		printf("usage: rmjob transmittal-number\n");
		exit(1);
	}
aloop:
	argc--;
	argv++;
	if (argc < 1) exit(0);
	for (i=0; i<6; i++) {
		c = argv[0][i];
		if (c == 0) goto null;
		if ((c>= 'a') && (c<='z')) c =& 0337;  /* fold to upper case */
		runtext[i+15] = upjob[i] = jobctrl[i+10] = jobout[i+9] = c;
	}
	if (argv[0][6] != '\0') goto null;
	goto gotf;
null:
	printf("rmjob: invalid transmittal number %s\n", *argv);
	goto aloop;
gotf:
	if (stat(jobout, &sbuf) < 0) {
		if (stat(runtext, &sbuf) < 0) {
			printf("job %s does not exist\n",upjob);
			goto aloop;
		}
	}

	if (sbuf.fuid == uid) goto owned;
	if (uid == 0) goto owned;
	printf("job %s is not yours\n", upjob);
	goto aloop;
owned:
	unlink(jobout);
	unlink(jobctrl);
	unlink(runtext);
	goto aloop;
}
