/*
 * send
 * program to take files and compose a job for transmission to the Univac
 * computer, and when the job is fully composed send will kick ntr.
 *
 * By:   David E. Miran
 *       Wisconsin State Hygiene Lab
 *
 * April 23, 1981
 */

#include	<stdio.h>
#include	<signal.h>
#include	"../ntr/rjedef.h"
#include	"../ntr/rjefiles.h"

int	bufeof;			/* set on buffer empty */
char	*curfile;		/* pointer to name of current input file */
int	curcol	0;		/* current column (for tab substitution) */
int	curtrno;		/* current transmittal number */
int	fid;			/* spare file descriptro */
int	fndfin	0;		/* set if @fin found */
int	fndpas	0;		/* set if @pass found */
int	fndrun	0;		/* set if @run found */
char	ibuf[512];		/* input buffer */
int	infid;			/* input file descriptor */
int	iptr;			/* input buffer pointer */
char	jclass	'0';		/* job class */
char	line[512];		/* buffer for building/checking lines */
int	lineno	0;		/* line number */
int	lset	0;		/* set when file is locked */
int	nrd;			/* number of characters read */
int	ntrstat;		/* current status of communications */
char	obuf[512];		/* output buffer */
int	outset	0;		/* set if user specified an output file */
int	optr;			/* output buffer pointer */
int	rjeown;			/* uid/gid of rje system */
char	runid[]	"xxxxxx\0";   /* job transmittal number */
int	savcnt	0;		/* saved count of spaces from tab conversion */
char	*scline[]	{	/* lines to search for */
	"@RUN", "@run",
	"@PASS", "@pass",
	"@FIN", "@fin",
	0};
int	sendpid;				/* the pid itself */
int	tabopt	0;		/* set to 1 if tab conversion forbidden */
int	tabpos	0;		/* current line position for tab conversion - range 0-7 */
int	textfid;		/* job text file descriptor */
char	trnocd[]	"@TRNO                                   xxxxxx\n";  /* transmittal card */
int	uid, gid, setid;	/* user id, group id, combined for set */
char	*uoutfile;		/* pointer to name of output file if specified on call*/

int quitsig();

main(argc, argv)
int argc;
char ** argv;
{
register int i;

	if (argc < 2) {
		printf("send: no file specified\n");
		exit(1);
	}
	argv++;
	argc--;		/* skip program name */
argloop:
	if (**argv != '-') goto jstart;
	switch(*(++*argv)) {
		case 'w':	jclass = 'W';  break;
		case 'x':	jclass = 'X';  break;
		case 'n':	jclass = '0';  break;
		case 'd':	jclass = 'D';  break;
		case 'c':	jclass = 'C';  break;
		case 't':	tabopt++;  break;
		case 'f':	/* specify user output file - done by links */
			outset++;  argv++;
			argc--;
			uoutfile = *argv;
			break;
		default:
			printf("send: unrecognized option -%c\n", **argv);
			exit(1);
	}
	argc--;  argv++;
	goto argloop;

jstart:
	/* begin processing of a job after reading the options */
	signal(SIGHUP, &quitsig);
	signal(SIGINT, &quitsig);
	signal(SIGQUIT, &quitsig);
	if (xlock()) goto nolock;
	fid = open(trnum, 2);
	read(fid, &curtrno, 2);
	curtrno++;
	if (curtrno > 9999) curtrno = 1;
	seek(fid, 0, 0);
	write(fid, &curtrno, 2);
	close(fid);
	funlock(lockfile);
	lset = 0;
	fid = open(pidfile, 0);
	read(fid, &sendpid, 2);
	close(fid);
	fid = open(statfile,0);
	read(fid, &ntrstat, 2);
	close(fid);
	uid = getuid() & 0377;
	gid = getgid() & 0377;
	setid = uid | gid<<8;
	rjeown = SITUID | SITGID<<8;
	runid[0] = SITEID;
	runid[1] = jclass;
	runid[2] = (curtrno/1000) | 060;
	curtrno = curtrno%1000;
	runid[3] = (curtrno/100) | 060;
	curtrno = curtrno%100;
	runid[4] = (curtrno/10) | 060;
	curtrno = curtrno%10;
	runid[5] = curtrno | 060;
	for (i = 0; i<6; i++) {  /* copy transmittal number to various places */
		runtext[i+15] = runid[i];
		jobout[i+9] = runid[i];
		jobctrl[i+10] = runid[i];
		trnocd[i+40] = runid[i];
	}

	textfid = creat(runtext,0640);
	chown(runtext, setid);	/* user owns run text - for removal */
	write(textfid, trnocd, 47);
	lineno = 0;

/* file input loop */

finlp:
	/* check file access authorization */
	if (!(saccess(*argv, 4))) {	/* no permission */
		printf("send: access to file %s not allowed - job %s cancelled\n", *argv, runid);
		goto abandon;
	}
	if ((infid = open(*argv, 0)) < 0) {
		printf("send: file %s not readable - job %s cancelled\n", *argv, runid);
		goto abandon;
	}
	iptr = 512;	/* force read of a buffer of input */
	nrd = bufeof = 0;

linloop:		/* get next line of text */
	i=getline();
	if (i < 0)	{	/* end of file */
		close(infid);
		argc--;
		argv++;
		if (argc < 1) goto endjob;
		goto finlp;
	}
	lineno++;
	if (fndfin) {
		printf("text found after @FIN - job %s cancelled\n", runid);
		goto abandon;
	}
	/* cmp returns 1 if lines match, else 0 */
	if (cmp(line, scline[0], 4)) goto setrun;
	if (cmp(line, scline[1], 4)) goto setrun;
	if (cmp(line, scline[2], 5)) goto setpas;
	if (cmp(line, scline[3], 5)) goto setpas;
	if (cmp(line, scline[4], 4)) goto setfin;
	if (cmp(line, scline[5], 4)) goto setfin;
/* ordinary text - not a special line */
	if (!fndrun) {	/* should have already seen @run - quit */
		printf("job does not begin with @RUN - job %s cancelled\n", runid);
		goto abandon;
	}
	putline();
	goto linloop;

setrun:		/* found an @run card */
	if (fndrun)	{
		printf("job contains more than 1 @RUN card - job %s cancelled\n",runid);
		goto abandon;
	}
	fndrun++;
	putline();
	goto linloop;
setpas:		/* found password card */
	fndpas = 1;
	putline();
	goto linloop;
setfin:		/* found @FIN card */
	fndfin = 1;
	putline();
	goto linloop;

endjob:
	if (fndpas == 0) {
		printf("job does not contain a @PASS card - job %s cancelled\n",runid);
		goto abandon;
	}
	if (fndrun == 0) {
		printf("job does not contain a @RUN card - job %s cancelled\n",runid);
		goto abandon;
	}
	if (fndfin == 0) {
		printf("job does not contain a @FIN card - job %s cancelled\n",runid);
		goto abandon;
	}
/* job is now complete */
	if (optr > 0)	write(textfid, obuf, optr);	/* flush buffer */
	close(textfid);
	close(creat(jobout, 0600));
	chown(jobout, setid);
	close(creat(jobctrl,0640));
	chown(jobctrl, rjeown);
	if (xlock()) goto nolock;
	if (ntrstat == ACTIVE) {
		kill(sendpid, WORK);
	}  else  {
		switch (ntrstat) {
			case TERMK:
				printf("Warning - rje is not logged in\n");
				break;
			case NOTOP:
				printf("Warning - rje program is not loaded\n");
				break;
			default:
				printf("Rje is currently attempting to log in to the Univac computer\n");
		}
	}
	sleep(1);
	funlock(lockfile);
	lset = 0;
	printf("job %s queued for transmission\n", runid);
	if (outset) {
		if (!(saccess(uoutfile, 2))) goto nolink;
		if (link(jobout, uoutfile) < 0) goto nolink;
		printf("output for job %s will be put into file %s\n", runid, uoutfile);
		exit(0);
	}
	goto done;
nolink:
	printf("cannot link to file %s for output\n", uoutfile);
done:
	printf("output for job %s will be put into file %s\n", runid, jobout);
	exit(0);

nolock:
	printf("cannot lock transmittal file - job abandoned\n");
abandon:
	close(fid);
	close(textfid);
	unlink(runtext);
	exit(1);
}

/* cmp - compare two lines of text for a specified number of characters */


cmp(s1, s2, n)	/* return 1 if strings match */
char s1[], s2[];
int n;
{
register int i;
	for (i=0; i<n; i++)
		if (s1[i] != s2[i]) return(0);
	return(1);
}

/* getline - build a line of text */

getline()
{
register char c;
register int i;

	curcol = 0;
cplp:
	c = rget();
	if (bufeof) return(-1);
	line[curcol++] = c;
	if (c == '\n') return(0);
	goto cplp;
}
/* rget - return 1 char at a time, turning tabs into spaces */

rget()
{
register char c;

	if (tabopt) return(get());	/* do not do tab interpretation */
	if (savcnt)  {
		savcnt--;
		return(' ');
	}
	c=get();
	if (c == '\n') {
		tabpos=0;
		savcnt=0;
		return(c);
	}
	if (c != '\t') {
		tabpos++;
		tabpos =& 07;
		return(c);
	}
	savcnt = 8-tabpos;
	tabpos = 0;
	savcnt--;
	return(' ');
}

/* get - buffered read 1 character at a time */

get()
{

	if(iptr >= nrd) {	/* need to read another buffer */
		nrd = read(infid, ibuf, 512);
		if (nrd < 1) {
			bufeof = 1;
			return(0);
		}
		iptr = 0;
	}
	return(ibuf[iptr++]);
}

putline()
{
register char c;
register int i;

	i = 0;
cplp:
	c = line[i++];
	put(c);
	if (c == '\n') return(0);
	goto cplp;
}

put(c)
char c;
{

	obuf[optr++] = c;
	if (optr<512) return;
	write(textfid, obuf, 512);
	optr = 0;
}
xlock()
{
register int i;
	i = 0;
	while (!flock(lockfile)) {
		if (i++ > 20) {
			return(1);
		}
		sleep(1);
	}
	lset = 1;
	return(0);
}

quitsig()
{
	if (lset) funlock(lockfile);
	unlink(jobout);
	unlink(jobctrl);
	unlink(runtext);
	printf("send:  job %s cancelled\n",runid);
	exit(0);
}
