/*
  labels wxx lxx nxx c

a program to read a manuscript and generate mailing labels in the general
mode of the program labelsx on the old pdp-12.
the program reads the standard input, and prints labels on the
standard output.  The form of the input is either:
  a)    line 1\line 2\...
       or
  b)    line1
        line 2
        .
        .
        .
        line n!
Format a is the old pdp-12 format where newline marks the end of a label.
Format b is the new format where parts of a label are separated by newline,
and the end of the label is marked by !.
comment lines start with [ and the comment is from the [ thru the newline.

the options are as follows:
   wxx - output lines are xx characters wide - default is 34.
   lxx - label is xx lines high - default is 6.
   nxx - print xx copies of each label - default is 1
   c - select format b for input - default is format a.
*
* by David E. Miran  -  Wisconsin State Hygiene Lab
* 4/1/81
*
*
*/

#include	<stdio.h>
#define	MAXC	12000

char buf[MAXC+3];
char	ibuf[BUFSIZ];
char brkch, eol;
int length, width, ncopy, nline, i, j, tchar, nchar;
main(argc, argv)
char **argv;
int argc;
{
register int ch;
	length=6;
	width=34;
	ncopy=1;
	brkch='\\';
	eol='\n';

/*
	read parameters if any were given    */
	while (--argc) switch(**++argv) {
		case 'w':  width = atoi(*argv+1);
			break;
		case 'l':  length = atoi(*argv+1);
			break;
		case 'n':  ncopy = atoi(*argv+1);
			break;
		case 'c':  brkch = '\n';
			eol = '!';
			break;
		default:  fprintf(stderr,"labels: unknown option: %s\n",*argv);
	}
/*  read from standard input  - to get labels  */
	nchar = 0;  nline = 1;  tchar = 0;
	setbuf(stdin,ibuf);
	while ((ch = getc(stdin)) != EOF) {
		if ( ch == '[') {
/*  comment skipper - skip from [ thru eol
   this means that comments may be embedded in labels and are ignored  */
	comskip:
			if ((ch = getc(stdin)) == EOF) goto eofin;
			if (ch != '\n') goto comskip;
			continue;  /* out of comments - process next char */
			}
		if (tchar > MAXC) {
			fprintf(stderr,"labels:  following label too large\n");
			buf[tchar++] = '\n';
			write(2,buf,tchar);
			exit(1);
		}
		if (ch == brkch)  {
			buf[tchar++] = '\n';
			nchar = 0;
			nline++;
			continue;
		}
		if (ch == eol) {
			buf[tchar++] = '\n';
			endlab();
			continue;
		}
		if (nchar == width) {

			buf[tchar++] = '\n';
			nline++;         nchar = 5;
			for (i=0; i < 5; i++) buf[tchar++] = ' ';
		}
		buf[tchar++] = ch;
		nchar++;
	}
/*  print final label if one is in progress.  */

eofin:
	if (tchar > 0) {
		fprintf(stderr,"labels:  final label has no end character\n");
		exit(1);
	}
	exit(0);
}
/* start printing a label, since we have seen an end of label char
  remember - if brkch=! then gobble up the newline after it  */

endlab()
{
register int ch, j, i;
	while (nline > length) nline = nline - length;
	for (j = nline; j < length; j++)  buf[tchar++] = '\n';
	for (i = 0; i < ncopy; i++)  write(1,buf,tchar);
	if (eol == '!') {
endsch:
		if ((ch = getc(stdin)) == EOF) goto endlabx;
		if (ch != '\n') goto endsch; /* search for eol after ! */
		}
	nchar = 0;  nline = 1;  tchar = 0;
	return;
endlabx:
/* ran out of labels */
	exit(0);
	}
