#define DATA 03
#define BSS 04

struct	nl
{
	char	name[8];
	int	typ;
	int	*val;
} *nlp;
int	fi;
int	fo;
int	buf[8];
main(argc, argv)
char **argv;
{
	int n, m, i, j;
	int compare();
	register struct nl *p, *q;

	argc--;
	if (argc==0)
		fi = open("/unix", 0); else
		fi = open(*++argv, 0);
	if(fi < 0) {
		printf("cannot open %s\n",*argv);
		exit();
	}
	if (argc < 2)
		fo = creat("/etc/pssym", 0644); else
		fo = creat(*++argv, 0644);
	if(fi < 0) {
		printf("cannot create %s\n", *argv);
		exit();
	}
	read(fi, buf, 020);
	if(buf[0]!=0407 && buf[0]!=0410 && buf[0]!=0411) {
		printf("bad format\n");
		exit();
	}
	seek(fi, buf[1]&0777, 1);
	seek(fi, (buf[1]>>9)&0177, 4);		/* text */
	seek(fi, buf[2]&0777, 1);
	seek(fi, (buf[2]>>9)&0177, 4);		/* data */
	if(buf[7] != 1) {
		seek(fi, buf[1]&0777, 1);
		seek(fi, (buf[1]>>9)&0177, 4);
		seek(fi, buf[2]&0777, 1);
		seek(fi, (buf[2]>>9)&0177, 4);	/* reloc */
	}
	n = ldiv(0, buf[4], 12);
	if(n == 0) {
		printf("no name list\n");
		exit();
	}
	nlp = sbrk(12*n);
	read(fi, nlp, n*12);
	qsort(nlp, n, 12, compare);
	p = q = nlp;
	m = 0;
	for(i=0; i<n; i++) {
		if((p->typ&037) == DATA || (p->typ&037) == BSS) {
			if(p->name[0] != '_')
				goto not;
			for(j=0; j<8; j++)
				q->name[j] = p->name[j];
			q->typ = p->typ;
			q->val = p->val;
			q++;
			m++;
		}
not:
		p++;
	}
	buf[1] = buf[2] = buf[3] = 0;
	buf[4] = m*12;
	write(fo, buf, 020);
	write(fo, nlp, m*12);
}

compare(p1, p2)
struct nl *p1, *p2;
{
	int a, i;

	a = 0;
	if(p1->val > p2->val) {
		a = 1;
		goto out;
	}
	if(p1->val < p2->val) {
		a = -1;
		goto out;
	}
	for(i=0; i<8; i++)
	if(p1->name[i] != p2->name[i]) {
		if(p1->name[i] > p2->name[i])
			a = 1; else
			a = -1;
		goto out;
	}
out:
	return(a);
}
