/*
 * rotate < file1 > file2
 *
 * read the standard input and write the standard input, with a rotational
 * transformation.  That is, each line read becomes a column of the output.
 * The first line is column 1, and so forth. max input sizes are 66 chars
 * per input line and max 136 input lines (excess ignored).
 * Useable as a filter.
 * by David E. Miran
 * September 2, 1980

*/
char ch, eol;
int  lnum, cpos, ibuf[259];
char page[67][138];
/* each line of input fills a column (leftmost subscript) */
int i, j, maxc;
main()
{
extern fout;
	fout = 2;
	eol = '\n';
	maxc = lnum = cpos = 0;
/* blank out array */
	for (i=0; i< 66; i++)
		for (j=0; j< 136; j++)
			page[i][j] = ' ';
	while (( ch = getc(ibuf)) > 0) {
		if (ch == eol) {
			lnum++;
			cpos = 0;
			continue;
			}
		if ((cpos > 66) || (lnum > 136)) {
			printf("input data too large - at line %d column %d\n", lnum, cpos);
			exit(1);
		}
		page[cpos++][lnum] = ch;
		if (cpos > maxc) maxc = cpos;
	}
	lnum++;
	for (i=0;i<maxc;i++)
		page[i][lnum] = '\n';
	lnum++;
	for (i = 0; i < maxc; i++)
		write(1, &page[i][0],lnum);
	exit(0);
}
