#define REWIND 0
#define TAPEMARK 1
#define OFFREWIND 2
#define SPACER 3
#define SPACEF 5

struct {
	int	command;
	int	count;
} tcom;

char	conflict[] {"Cannot specify more than 1 device option\n"};
char	openerr[] {"Cannot open magtape\n"};
char	cmdcnterr[] {"Only one command per operation is allowed\n"};
char	hmt0[] {"/dev/hmt0: "};
char	rmt0[] {"/dev/rmt0: "};

char	*fnames[5] {
	"Rewind\n",
	"Write tape mark\n",
	"Offline and rewind\n",
	"Skip %d records",
	"",
	"Skip %d files"
};

int	backward,verbose;
char	*devname;

main(argc,argv)
int	argc;
char	*argv[];
{
	register char *fscan;
	register int fset,funct;
	int count,rtape,htape,dev;
	argc--;argv++;
	if(!argc) {
		if((dev = open("/dev/hmt0",0)) < 0) panic(openerr);
		execute(dev,SPACEF,1);
	}
	verbose = 0;
	while(argc-- > 0) {
		dev = -1;
		fset = 0;
		backward = 0;
		count = 1;
		fscan = *argv++;
		while(*fscan) switch(*fscan++) {
			case 'r':
				if(!fset++)
					funct = REWIND;
				else
					panic(cmdcnterr);
				break;
			case 'm':
				if(!fset++)
					funct = TAPEMARK;
				else
					panic(cmdcnterr);
				break;
			case 'o':
				if(!fset++)
					funct = OFFREWIND;
				else
					panic(cmdcnterr);
				break;
			case 'b':
				if(!fset++)
					funct = SPACER;
				else
					panic(cmdcnterr);
				break;
			case 'f':
				if(!fset++)
					funct = SPACEF;
				else
					panic(cmdcnterr);
				break;
			case 'c':
				if((argc == 0) || (count = atoi(*argv)) == 0)
					panic("No count argument\n");
				argc--;argv++;
				break;
			case '-':
				backward++;
				break;
			case 'R':
				if(dev > 0) panic(conflict);
				if((dev = open("/dev/rmt0",0)) < 0)
					panic(openerr);
				devname = rmt0;
				break;
			case 'H':
				if(dev > 0) panic(conflict);
				if((dev = open("/dev/hmt0",0)) < 0)
					panic(openerr);
				devname = hmt0;
				break;
			case 'v':
				verbose++;
				break;
			default:
				printf("Bad option: %c\n",*(fscan-1));
				exit(030);
		}
		if(!fset) funct = 5;
		if(dev < 0) 
			if((dev = open("/dev/hmt0",0)) < 0)
				panic(openerr);
			else devname = hmt0;
		execute(dev,funct,count);
	}
}



panic(str)
char	*str;
{
	printf(str);
	exit(377);
}



inform(str,arg)
char	*str;
{
	if(verbose) printf(str,arg);
}



execute(dev,cmd,num)
int	cmd,num;
{
	tcom.count = (num < 0 ? -num : num);
	inform(devname);
	inform(fnames[cmd],tcom.count);
	if(cmd >= 3) {
		if(( backward) || (num < 0)) {
			cmd++;
			inform(" backwards");
		}
		inform("\n");
	}
	tcom.command = cmd;
	if(stty(dev,&tcom) < 0) panic("Stty error\n");
	close(dev);
}
