/*
 * pstop [?]	program to stop current print.
 *
 * Sends L_KILL signal to currently executing tpd, which aborts
 * present print and re-writes and changes mode of control file.
 *
 * Must be set-user root to send signal to tpd which isn't same uid.
 *
 * Written by Bob Beck, 24-JAN-76.
 * Modified by David Miran to support multiple devices.
 * version of 12/16/82
 */

#include	<stdio.h>
#include "tpdinf.h"

struct	printid	prid;
struct	control	ctl;
char	cf[] "/sptmp/data/cf%xxxxx";
char	sf[] "/sptmp/data/sf%";
char	*lp	"/dev/lp";
char	*dev	"/dev/tty?";
int	tmode	0;
char	term	'%';
char	*progname;

main(argc,argv)
int argc;
char **argv;
{
  int pid;
  register int fd;

	progname = argv[0];
	/* get terminal code (if not for line printer) */
	if (argc > 1) {
		tmode = 1;
		term = argv[1][0];
		cf[14] = term;
		sf[14] = term;
		tpdpid[12] = term;
		tpdprid[12] = term;
		dev[8] = term;
	}
	/*
	 * get present tpd id.
	 */

	if ((fd = open(tpdpid,0)) < 0) {
		printf("%s: Can't read tpd pid file %s\n",progname,tpdpid);
		exit(1);
	}
	read(fd,&pid,2);		/* get tpd's pid */
	close(fd);

	/*
	 * get present print id.
	 */

	if ((fd = open(tpdprid,0)) < 0) {
		printf("%s:  Can't read print id file %s\n",progname,tpdprid);
		exit(1);
	}
	read(fd,&prid,sizeof prid);
	ascnum(cf+15,prid.prpid);
#ifdef VERIFY
	verify(cf,"stop");			/* verify permission */
#endif
	kill(pid,L_KILL);		/* send kill signal */
	sleep(1);				/* let tpd finish the kill */
	read(open(cf,0),&ctl,sizeof ctl);	/* read control file */
	printf("Stopped: %d, page %d\n",prid.prpid,ctl.startp);
}
/*
 * tpdkick	routine to send a signal to executing tpd.
 *		note: must be super user to do kill of process
 *		not same user.
 *
 * Written by Bob Beck, 21-JAN-77.
 */

tpdkick(sig)
int	sig;
{
  register int fd;
  int pid;

	if ((fd = open(tpdpid,0)) < 0) {
		printf("%s:  Can't read tpd pid file %s\n",progname,tpdpid);
		exit(1);
	}
	read(fd,&pid,2);
	close(fd);
	kill(pid,sig);
}
/*
 * verify	check that calling user owns spool file.
 *		If not ask if the person really wants to kill/stop/remove it
 *		By David E. Miran
 * version of 12/16/82
 */

struct	control	ctl;

verify(file,what)
char	*file, *what;
{
register int user;
int fd;
char	xbuf[20];

	user = getuid() & 0377;
	if ((fd = open(file,0)) < 0) {
		printf("%s:  Spool file %s not found\n",progname,file);
		exit(1);
	}
	if (read(fd,&ctl,sizeof ctl) < 0) {
		printf("%s:  Can't read spool file %s\n",progname,file);
		exit(1);
	}
	close(fd);

	if ((ctl.uid & 0377) != user) {
		printf("%s: The job currently printing on %s is not yours!\n",progname,tmode?dev:lp);
		printf("Do you really want to %s it?  Type y or n.\n",what);
		read(0,xbuf,20);
		if (xbuf[0] != 'y') exit(1);
	}
}
