#
/*
 * uprint file1 file2 ...
 * a program to print files with embedded spacing control commands,
 * in the form created by the NTR RJE system for output from a
 * Univac 1100 computer.
 *
 * By:   David E. Miran
 *       Wisconsin State Hygiene Lab
 *
 * August 13, 1980
*
* form of commands is as follows:
* each command is on a separate line, and begins with a signal
* character ('~'), and ends with a newline.
* the following commands are recognized:
*  ~*  top of form
*  ~N  print next line after advancing N lines where N is a string of digits.
*      0 - means overprint
*      1 - is normal spacing and is not usually coded, since a line not
*          preceeded with a spacing command is printed with this spacing.
*      2 - leave 1 blank line (usually replaced by a blank line in the text).
*      N - leave N-1 blank lines.
*  ~~  This is not a command, but a line beginning with '~', and the first
*      '~' will be dropped before printing.
*
*	Note - to print on the first line of a page after a top of form
*	it is necessary to overprint.
*
 */

#define	CTR	'~'		/* the signal character */
#define	FF	014		/* form feed character */
#define	CR	'\r'		/* return character */
#define	NL	'\n'		/* new line character */

int	bufeof;			/* set on input buffer empty */
char	*curfile;		/* pointer to name of current input file */
int	epos;			/* end position of current line */
int	fid;			/* spare file descriptor */
char	ibuf[512];		/* input buffer */
int	infid;			/* input file descriptor */
int	iptr;			/* input buffer pointer */
char	line[256];		/* buffer for  lines */
int	nrd;			/* number of characters read */
char	obuf[512];		/* output buffer */
int	optr;			/* output buffer pointer */
int	savepos;		/* end position of saved line */
int	savl	0;		/* set if there is a saved line */
char	sline[256];		/* saved line for output later */
int	spcnt;			/* saved spacing count for next line */


main(argc, argv)
int argc;
char ** argv;
{
register int i, j;

	if (argc < 2) {
		printf("usage: uprint file ...\n");
		exit(1);
	}
	argv++;
	argc--;		/* skip program name */

/* file input loop */

finlp:
	if ((infid = open(*argv, 0)) < 0) {
		printf("uprint: file %s is not readable\n", *argv);
		exit(1);
	}
	iptr = 512;	/* force read of a buffer of input */
	nrd = bufeof = 0;

linloop:		/* get next line of text */
	i=getline();
	if (i < 0)	{	/* end of file */
		if (savl) {
			putline(sline);
			savl = 0;
		}
		close(infid);
		argc--;
		argv++;
		if (argc < 1) goto endjob;
		goto finlp;
	}
/* interpret the lines here */
	epos = i;	/* save end of line position */
	if (line[0] != CTR) goto dopr;	/* an ordinary line */
	if (line[1] == CTR) {	/* a line starting with ~ */
		for (i=0; i<epos; i++)
			line[i] = line[i+1];
		epos =- 1;
		goto dopr;
	}
	if (line[1] == '*')	{	/* top of form */
		if (savl)	{
			putline(sline);
			savl = 0;
		}
		put(FF);
		goto linloop;
	}
	/* presume this is a ~N line and process */
	j = atoi(&line[1]);
	if (j == 0) {	/* overprint saved line with next one */
		sline[savepos-1] = CR;
		putline(sline);
		savl = savepos = 0;
		goto linloop;
	}
	/* line spacing greater than 0 - usually only for greater than 2 */
	if (savl)
		putline(sline);
	for (i=1; i<j; i++)
		put(NL);
	savl = 0;
	goto linloop;
dopr:	/* handle an ordinary line of print */
	if (savl)
		putline(sline);
		for (i=0; i< epos+1; i++)
			sline[i] = line[i];
		savl = 1;
		savepos = epos;
	goto linloop;


endjob:
	if (optr > 0)	write(1, obuf, optr);	/* flush buffer */
}

/* getline - build a line of text */

getline()
{
register char c;
register int i, curcol;

	curcol = 0;
cplp:
	c = get();
	if (bufeof) return(-1);
	line[curcol++] = c;
	if (c == NL) {
		line[curcol] = '\0';
		return(curcol);
	}
	goto cplp;
}

/* get - buffered read 1 character at a time */

get()
{

	if(iptr >= nrd) {	/* need to read another buffer */
		nrd = read(infid, ibuf, 512);
		if (nrd < 1) {
			bufeof = 1;
			return(0);
		}
		iptr = 0;
	}
	return(ibuf[iptr++]);
}

putline(pline)
char pline[];
{
register char c;
register int i;

	i = 0;
cplp:
	c = pline[i++];
	if (c == '\0') return(0);
	put(c);
	goto cplp;
}

put(c)
char c;
{

	obuf[optr++] = c;
	if (optr<512) return;
	write(1, obuf, 512);
	optr = 0;
}
