/*
 * tunable variables
 * param.h - version of 5/25/83
 */

#define	NBUF	26		/* size of buffer cache */
#define	NINODE	127		/* number of in core inodes */
#define	NFILE	150		/* number of in core file structures */
#define	NMOUNT	5		/* number of mountable file systems */
#define	NEXEC	3		/* number of simultaneous exec's */
#define	MAXMEM	(64*32)		/* max core per process - first # is Kw */
#define	SSIZE	20		/* initial stack size (*64 bytes) */
#define	SINCR	20		/* increment of stack (*64 bytes) */
#define	NOFILE	15		/* max open files per process */
#define	CANBSIZ	512		/* max size of typewriter line */
#define	CMAPSIZ	60		/* size of core allocation area */
#define	SMAPSIZ	170		/* size of swap allocation area */
/* CMAPSIZ need not be any larger than 2 times the number of simultaneous processes
 * which can be in core + 10 for a margin.  Assuming each process
 * averages 10k in size this means that 50 ought to be sufficient.
 * SMAPSIZE cannot need to any larger than 2 times NPROC + 10 to allow a margin
 * and to allow for sticky bit programs.
 */
#define	NCALL	20		/* max simultaneous time callouts */
#define	NPROC	83		/* max number of processes */
#define	MINPROC	2		/* min number free procs for user fork */
#define	NUPROC	12		/* default number simultaneous user procs */
#define	NTEXT	20		/* max number of pure texts */
#define	NCLIST	300		/* max total clist size - 14 char each */
#define	NDH11	48		/* number of dh-11 lines */
#define	NDHCTR	3		/* number of dh-11 multiplexors */
#define	DHNCH	32		/* max number of DMA chars for dh-11 */
#define	HZ	60		/* Ticks/second of the clock */
#define	SWPBRK	150		/* breakpoint for swap in */
#define	NMSEG	10		/* size of stack for mapin/mapout */

/* local features */
#define	NONSEP	1		/* non sep i/d machines - 11/34, 40, 60 */
/* disabled feature - XUBMAP - unibus map handling */

/*
 * priorities
 * probably should not be
 * altered too much
 */

#define	PSWP	-100
#define	PSWA	-10
#define	PINOD	-90
#define	PRIBIO	-50
#define	PPIPE	15		/* test; was 1 */
#define	PWAIT	40
#define	PSLEP	90
#define	PSYNCH	90		/* wait priority for synch stuff */
#define	PUSER	100

/*
 * default settings for scheduling parameters.
 */

#define SCPRI	16		/* pri coeff */
#define SCSIZE	1		/* size coeff */
#define SCTOUT	128		/* time swapped coeff */

/*
 * signals
 * dont change
 */

#define	NSIG	20
#define		SIGHUP	1	/* hangup */
#define		SIGINT	2	/* interrupt (rubout) */
#define		SIGQIT	3	/* quit (FS) */
#define		SIGINS	4	/* illegal instruction */
#define		SIGTRC	5	/* trace or breakpoint */
#define		SIGIOT	6	/* iot */
#define		SIGEMT	7	/* emt */
#define		SIGFPT	8	/* floating exception */
#define		SIGKIL	9	/* kill */
#define		SIGBUS	10	/* bus error */
#define		SIGSEG	11	/* segmentation violation */
#define		SIGSYS	12	/* sys */
#define		SIGPIPE	13	/* end of pipe */

/*
 * fundamental constants
 * cannot be changed
 */

#define	USIZE	16		/* size of user block (*64) */
#define	NULL	0
#define	NODEV	(-1)
#define	ROOTINO	1		/* i number of all roots */
#define	DIRSIZ	14		/* max characters per directory */
#define	BSIZE	512		/* size of mass storage block */
#define	BSIZEW	256		/* BSIZE in words */
#define	SBSIZE	8		/* BSIZE in core klicks (64 bytes) */
#define	CLSIZE	16		/* clist cblock size (CBSIZE + sizeof int) */
#define	CBSIZE	14		/* size of clist info portion */
#define	CROUND	017		/* clist accessing constant */

/*
 * structure to access an
 * integer in bytes
 */
struct
{
	char	lobyte;
	char	hibyte;
};

/*
 * structure to access an integer
 */
struct
{
	int	integ;
};

/*
 * Certain processor registers
 */
#define PS	0177776
#define KL	0177560
#define SW	0177570
