/*
 *	v.uprec - update records for vir
 *	3/16/82
 */

#include	<stdio.h>
#include	"vmyio.h"
#include	"vir.h"

extern long atol(), lseek();

extern struct	dexhead	hrec;		/* HFILE (header file) */
extern struct	fil_ent	filent[MAXFILE]; /* data file information - HFILE-3 */
extern struct	fmt_inf	fmtinf[MAXFMT];	/* format information (internal) */
extern struct	fdef	fld[MAXFLD];	/* the format field descriptors */
extern struct	num_ent	snrec;		/* one record from NFILE */
extern struct	sp_ent	srec;		/* one record from SFILE */

extern char	tbuf[MAXRSIZE], ibuf[MAXRSIZE];	/* terminal and internal buffers */

/* WORKING SET - current set of records */

extern struct {
	struct	num_ent crec_n;
	int	nfmt_num;	/* format associated with this record */
	long	nws_loc;	/* loc of index entry for this record */
	}  crec[MAXREC];	/* pointers to records in working set */
extern int	wsp;		/* points to current record entry during update */

extern int	recsize;	/* current expanded record size */
extern int	new_size;	/* new record (compressed) size */
extern long cp_off;		/* patient index offset of current patient */

/* LOOKUP - control variables and tables (?2 files) */
extern int	plookp, nlookp, slookp;  /* set if currently searching p, n, or s file */
extern int	plooku, nlooku, slooku;  /* set if search beyond sequential area */
extern long ploc, nloc, sloc;  /* current offsets into index files */
extern long newnloc;

/* STATE - general system and state definitions */
extern int	fdexmod;	/* set if any changes made */
extern int	filspot;		/* current data file pointer in filent table */

extern char bell[];

extern char	rbuf[80];	/* spare line buffer */
extern long newloc;
extern long errloc;
extern long errpnum;
extern long	errspec;
extern long MEG;
extern char *gens;
extern int auto_on;
extern long ML;

/********************************  uprec  ***********************************/
/* do the actual updating of a single record.
 * this means update the record itself, and also correct all index
 * references to this record.
 */

/* return codes - -1=error, 0=ok or null update, >0= getin return code */
uprec(fnum, floc, fmt, locmod)
unsigned fnum;
long floc;
int fmt, locmod;
{

register i, j, k;
int l, newp;
long m, oldspec[MAXSPEC], newspec[MAXSPEC], savnloc, newloc;
char opname[PNSIZE], npname[PNSIZE];
long opnum, npnum;
struct num_ent savnrec;
int ospcnt, nspcnt, upfid, oldsize, pnumchg, pnamchg, ocheck[MAXSPEC],ncheck[MAXSPEC];
long xyr;

	filspot = lookupn(fnum);
	fileck(filspot,2); /* no return if access forbidden */
	i = getfrec(fnum, ibuf, floc);
	if (i < 1) return(-1);
	oldsize = new_size;
	expand(ibuf, tbuf, fmt);
	if (locmod) { /* by spnum lookup - find nfile entry */
		nlookp = 0;
		while (lookn(srec.xp_num)) {
			if (snrec.nf_num != srec.sf_num) continue;
			if (snrec.f_loc != srec.sf_loc) continue;
			goto gotit;
		}
		/* cannot find record in nfile - bad */
		errpnum = srec.xp_num;
		errspec = srec.sp_num;
		errloc = floc;
		quitsig(36);
gotit:
		/* save old nfile entry */
		savnloc = nloc;
		ncpy(&savnrec, &snrec, sizeof snrec);
	} else {
	/* save old nfile entry */
		savnloc = crec[wsp].nws_loc;
		ncpy(&savnrec, &crec[wsp].crec_n, sizeof (struct num_ent));
	}
	npnum = opnum = savnrec.np_num;
	i = fmtinf[fmt].fld_nam;
	j = fmtinf[fmt].st_fld;
	k = fld[i+j].f_pos;
	ncpy(opname, &tbuf[k], PNSIZE);  /* save patient name */
	ospcnt = nspcnt = 0;
/* save a list of specimen numbers in original record (if any) */
	if ((fmtinf[fmt].fmt_mod & SPECIMEN) == 0) goto aspec;
	for (i = 0; i<fmtinf[fmt].num_fld; i++) {
		k = i+j;
		if (fld[k].f_pos > recsize) break;  /* done */
		if ((fld[k].f_flags & SPECIMEN) == 0) continue;
		l = fld[k].f_size;
		ncpyt(rbuf, &tbuf[fld[k].f_pos], l);
		m = atol(rbuf);
		if (m == 0L) continue;
		oldspec[ospcnt++] = m;
	}
aspec:
	setform(fmt+1);
	setcur();
	puff(tbuf);	/* display old record */
re_up:
	newp = 0;
	i = getin(2);
	if (i == 4) goto del_all;
	if (i) return(i);  /* must be & or @ or ! something */
/* check on status of patient name/number for changes */
	pnumchg = pnamchg = 0;
	i = fmtinf[fmt].fld_nam;
	j = fmtinf[fmt].st_fld;
	k = fld[i+j].f_pos;
	ncpy(npname, &tbuf[k], PNSIZE);
	if (!hrec.intnum) {
		i = fmtinf[fmt].fld_pn;
		k = fld[i+j].f_pos;
		l = fld[i+j].f_size;
		if ((tbuf[k] == '?') && auto_on) {  /* assign a new patient number */
			hrec.maxpnum++;
			newp++;
			if (hrec.compnum) {
				hrec.pnumbas++;
				sprintf(rbuf,gens,hrec.pnumbas);
			}  else  {
				sprintf(rbuf,gens,hrec.maxpnum);
			}
			ncpy(&tbuf[k],rbuf,l);
		}
		ncpyt(rbuf, &tbuf[k], l);
		npnum = atol(rbuf);
		if (hrec.compnum) {
			i = fmtinf[fmt].fld_pny;
			k = fld[i+j].f_pos + fld[i+j].f_size - 2;
			ncpyt(rbuf,&tbuf[k], 2);
			xyr = atol(rbuf);
			npnum += xyr * MEG;
		}
	}
	if (npnum != opnum) pnumchg = 1;
	if (strncmp(opname, npname, PNSIZE) != 0) pnamchg = 1;
	if (!valrec())   {
		if (newp) {
			hrec.maxpnum--;
			if (hrec.compnum) hrec.pnumbas--;
		}
		goto re_up;
	}
	gen_frec();	/* compress the record */
	/* open the data file, write the new record, and zap the old one */
	upfid = open(filent[filspot].f_name, 2);
	newloc = lseek(upfid, 0L, 2);
	write(upfid, ibuf, new_size);
	zapn(ibuf, oldsize, '\177');
	lseek(upfid, floc, 0);
	write(upfid, ibuf, oldsize);
	filent[filspot].f_mode = HOLES;
	fdexmod = 1;
	close(upfid);
	/* if revised patient name make new pfile entry */
	if (pnamchg || pnumchg) {
		for (i=PNSIZE; i> 0; i--) {
			if (npname[i] != ' ') break;
			npname[i] = '\0';
		}
		makp(npname, npnum, ML);
		if (cp_off == ML) goto pnc;
		if (!pnamchg) goto pnc;
		for (i=0; i<PNSIZE; i++) opname[i] = '\0';
		makp(opname, 0L, cp_off);
	}
	/* if revised patient number delete the old nfile entry and make a new one */
pnc:
	if (pnumchg) {
		makn(0L, 0, 0L, savnloc);
		makn(npnum, fnum, newloc, ML);
	}  else  {  /* simply update old nfile entry */
#ifdef DEBUG
dw("callmakn",8); dw(&opnum,4); dw(&fnum,2); dw(&newloc,4); dw(&savnloc,4);
#endif
		makn(opnum, fnum, newloc, savnloc);
	}
/* gather new list of specimen numbers in record */
	if ((fmtinf[fmt].fmt_mod & SPECIMEN) == 0) goto bspec;
	for (i = 0; i<fmtinf[fmt].num_fld; i++) {
		k = i+j;
		if (fld[k].f_pos > recsize) break;  /* done */
		if ((fld[k].f_flags & SPECIMEN) == 0) continue;
		l = fld[k].f_size;
		ncpyt(rbuf, &tbuf[fld[k].f_pos], l);
		m = atol(rbuf);
		if (m == 0L) continue;
		newspec[nspcnt++] = m;
	}
bspec:
	if ((ospcnt == 0) && (nspcnt == 0)) goto do_ws;
/* now to revise the specimen index */
/* first check off those in old and new records */
	for (i=0; i<MAXSPEC; i++) ocheck[i] = ncheck[i] = 0;
	for (i=0; i<ospcnt; i++) {
		for (j=0; j<nspcnt; j++) {
			if (oldspec[i] == newspec[j]) {
				ocheck[i] = ncheck[j] = 1;
				break;
			}
		}
	}
/* for each specimen in old list update the sfile entry */
	for (i=0; i<ospcnt; i++) {
		if (ocheck[i]) {
			uspn(oldspec[i], fnum, floc, newloc, npnum, 1); /* fix old entry */
		}  else  {
			uspn(oldspec[i], fnum, floc, newloc, opnum, 0);  /* delete old entry */
		}
	}
	/* and add sfile entries for specimen numbers added to the record */
	for (i=0; i<nspcnt; i++) {
		if (ncheck[i]) continue;
		maks(newspec[i],npnum, fnum, newloc, ML);
	}
/* update the working set entry (if processing started via working set) */

do_ws:
	write(1,bell,1);
	if (wsp < 0) return(0);
	crec[wsp].crec_n.f_loc = newloc;
	crec[wsp].crec_n.np_num = npnum;
	crec[wsp].nws_loc = newnloc;
	setcur();
	return(0);
del_all:   /* delete the record, the nfile entry, and all sfile entries */
	upfid = open(filent[filspot].f_name, 2);
	zapn(ibuf, oldsize, '\177');
	lseek(upfid, floc, 0);
	write(upfid, ibuf, oldsize);
	close(upfid);
	filent[filspot].f_mode = HOLES;
	fdexmod = 1;
	makn(0L,0, 0L, savnloc);
	for (i=0; i<ospcnt; i++) {
		uspn(oldspec[i], fnum, floc, floc, opnum, 0);
	}
	newloc = npnum = newnloc = 0;
	goto do_ws;
}

/***********************  uspn  *******************************************/
/* look up a specimen number entry (sfile) and modify (mode 1) or delete it (mode 0)  */

uspn(spnum, fnum, oldloc, newloc, pnum, mode)
int mode;
long spnum, oldloc, newloc, pnum;
unsigned fnum;
{
restart:
	slookp = 0;
	while (looks(spnum)) {
		if (srec.sf_num != fnum) continue;
		if (srec.sf_loc != oldloc) continue;
		/* found the entry we want */
		if (mode)
			maks(spnum, pnum, fnum, newloc, sloc);
		else
			maks(0L, 0L, 0, 0L, sloc);
		break;
	}
}

