/*
 *	vnfile
 *	update HFILE for file additions and deletion,
 *	adding all files preceded by + and deleting all those preceded by -.
 *	-v means verbose - report files removed, added, etc.
 *	-d means debugging diagnostics
 *	-f fmt file means add new format fmt and associate a file with it.
 *	-y xx means set highest year to xx.
 *	-p xx means set highest patient number to xx.
 *	NOTE (these will both be reset when virdex is run or if higher numbered records are entered).
 *	+c/-c  turn composite numbering feature on (+) or off (-).
 *	+a/-a  turn automatic patient numbering on (+) or off (-).
 *	+int/-int  turn internal numbering feature on (+) or off (-).
 *	+m/-m turn modified data format on/off
 *	-rx means set record separator character to x
 *	-ix means set item (field) separator character to x.
 *
 *	by David E. Miran   4/19/82
 */

#include	<stdio.h>
#include	<signal.h>
#include	"vir.h"
#include	"virfiles.h"

extern long atol();

char	*progname;
int	vflag	0;	/* set for verbose option */
int	dflag	0;	/* debugging */
int	phase	0;

extern quitsig();

struct	dexhead	hrec;		/* HFILE (header file) */
struct	fil_ent	filent[MAXFILE]; /* data file information - XFILE */
struct	fmt_def fmtdef[MAXFMT];
char	*progname;
char	rbuf[150];	/* spare line buffer */
char	*x, *y;

int hfid;

main(argc, argv)
int argc;
char **argv;
{
register int i, j, k;
char c;
int st, end, alen;
long l;

	progname = *argv;
	signal(SIGHUP, &quitsig);
	signal(SIGINT, &quitsig);
	signal(SIGQUIT, &quitsig);
	if (!flock(lockfile)) {
		printf("%s:  sorry - file is locked. Cannot update index.\n",progname);
		exit(1);
	}

	if ((hfid = open(hfile, 2)) < 0) nofile(hfile);

	read(hfid, &hrec, sizeof hrec);
	read(hfid, &fmtdef[0], MAXFMT * sizeof (struct fmt_def));
	read(hfid, &filent[0], hrec.numfile * sizeof (struct fil_ent));
	close(hfid);

	argv++;		argc--;
	while (argc) {
		alen = strlen(*argv);
		if (strcmp(*argv, "-v") == 0) {  /* verbose option */
			vflag = 1;
			goto endw;
		}
		if (strcmp(*argv, "-d") == 0) {  /* debugging option */
			dflag = 1;
			goto endw;
		}
		if (strcmp(*argv, "-f") == 0) {
			++argv; --argc;  x = *argv;
			++argv; --argc;  y = *argv;
			if (argc <= 0) {
				printf("%s: -f must be followed by fmt and file names\n",progname);
				quitsig();
			}
			newfmt(x,y);
			goto endw;
		}
		if (strcmp(*argv, "-y") == 0) {
			++argv; --argc;
			l = atol(*argv);
			hrec.pnumyr = l;
			if (vflag) printf("vnfile: highest year set to %D\n",l);
			goto endw;
		}
		if (strcmp(*argv, "-p") == 0) {
			++argv; --argc;
			l = atol(*argv);
			hrec.maxpnum = hrec.pnumbas = l;
			if (vflag) printf("vnfile: highest patient number set to %D\n",l);
			goto endw;
		}
		if (strcmp(*argv, "-c") == 0) {
			hrec.compnum = 0;
			if (vflag) printf("vnfile: composite numbering turned off\n");
			goto endw;
		}
		if (strcmp(*argv, "+c") == 0) {
			hrec.compnum = 1;
			if (vflag) printf("vnfile: composite numbering turned on\n");
			goto endw;
		}
		if (strcmp(*argv, "-a") == 0) {
			hrec.autopn = 0;
			if (vflag) printf("vnfile: automatic patient numbering turned off\n");
			goto endw;
		}
		if (strcmp(*argv, "+a") == 0) {
			hrec.autopn = 1;
			if (vflag) printf("vnfile: automatic patient numbering turned on\n");
			goto endw;
		}
		if (strcmp(*argv, "-int") == 0) {
			hrec.intnum = 0;
			if (vflag) printf("vnfile: internal patient numbering turned off\n");
			goto endw;
		}
		if (strcmp(*argv, "+int") == 0) {
			hrec.intnum = 1;
			if (vflag) printf("vnfile: internal patient numbering turned on\n");
			goto endw;
		}
		if (strcmp(*argv, "-m") == 0) {
			hrec.modata = 0;
			hrec.recsep = '!';
			if (vflag) printf("vnfile: modified data format turned off\n");
			goto endw;
		}
		if (strcmp(*argv, "+m") == 0) {
			hrec.modata = 1;
			hrec.recsep = '\n';
			if (vflag) printf("vnfile: modified data format turned on\n");
			goto endw;
		}
		if ((strncmp(*argv, "-i", 2) == 0) && (alen == 3)) {
			hrec.fldsep = argv[0][2];
			if (vflag) printf("vnfile: field separator set to %c\n",hrec.fldsep);
			goto endw;
		}
		if ((strncmp(*argv, "-r", 2) == 0) && (alen == 3)) {
			if (hrec.modata) {
				printf("vnfile: illegal to change recordd separator for modified format data\n");
				goto quit;
			}
			hrec.recsep = argv[0][2];
			if (vflag) printf("vnfile: record separator set to %c\n",hrec.recsep);
			goto endw;
		}
		if ((**argv != '+') && (**argv != '-')) {
			strcpy(rbuf, *argv);
addb:
			if ((hrec.numfmt == 1) && (rbuf[0] == '1') && (rbuf[1] =='\0')) goto endw;
			if (!saccess(rbuf,2)) {
				if ((hrec.numfmt == 1) && (rbuf[0] == '1')) goto endw;
				printf("%s: Access to file %s forbidden\n",progname,rbuf);
				quitsig();
			}
			if (hrec.numfmt == 1) {
				i = 1;
			}  else  {
				argv++;  argc--;
				i = atoi(*argv);
			}
			if ((i < 1) || (i > hrec.numfmt)) {
				printf("%s:  no such format as %d for file %s\n",progname,i,rbuf);
				quitsig();
			}
			if (lookup(rbuf) >= 0) {
				printf("%s:  File %s is already in the index - ignored.\n",progname,rbuf);
				goto endw;
			}
			addfile(rbuf, i-1);
			goto endw;
		}
		strcpy(rbuf, &argv[0][1]);
		if (**argv == '-') {
			if (rmfile(rbuf)) {
				printf("%s:  file %s cannot be removed, since it is not in the index\n",progname,rbuf);
			}
			goto endw;
		}
		if (**argv == '+') {
			goto addb;
			goto endw;
		}
		printf("%s: invalid argument %s\n",progname,*argv);
		quitsig();

endw:
	argc--;		argv++;
	}	/* end of argument processing while loop */

/* close out updated files here */
	time(&hrec.lastmod);
	phase = 1;  /* to prevent killing process */
		hfid = creat(hfile, 0664);
		i = sizeof hrec;
		j = sizeof (struct fmt_def);
		k = sizeof (struct fil_ent);
		write(hfid, &hrec, i);
		write(hfid, &fmtdef[0], MAXFMT * j);
		write(hfid, &filent[0], hrec.numfile * k);
		close(hfid);
		printf("INDEX updated\n");
quit:
	funlock(lockfile);
	exit(0);
}

/*******************************  addfile  **********************************/
/* add a new file to the file table (must not be present already) */

addfile(fname,fmnum)
char *fname;
int fmnum;
{
register int i, j;
	hrec.numfile++;
	if (hrec.numfile > MAXFILE) quitsig(28);
	hrec.maxfile++;
	if (hrec.maxfile > 65530) hrec.maxfile = 1;
	j = hrec.numfile-1;
	filent[j].f_num = hrec.maxfile;
	filent[j].fmt_cd = fmnum;
	filent[j].f_mode = NOTCUR;
	strcpy(filent[j].f_name, fname);
	if (vflag) printf("file %s added, associated with format number %d\n",fname,fmnum+1);
	return(j);
}

/*******************************  lookup  *************************/
/* look up files in the file table by name or number */

lookup(fname)
char *fname;
{
register int i;
	for (i=0; i<hrec.numfile; i++)
		if (strcmp(fname, filent[i].f_name) == 0) return(i);
	return(-1);
}

/****************************  ncp ***********************************/
/* ncp - to copy exactly n character regardless */

ncp(os,is,n)
register char *is, *os;
register int n;
{
	while (n--)
		*os++ = *is++;
}

/*******************************  newfmt  *********************************/
/* add a new format to the index, and a file to go with it */

newfmt(fmt, fil)
char *fmt, *fil;
{
register int i, j;
	for (i=0; i<hrec.numfmt; i++) {
		if (strcmp(fmt,fmtdef[i].fmt_name) == 0) {
			printf("%s: format %s is already in the index\n",progname,fmt);
			quitsig();
		}
	}
	i = lookup(fil);
	if (i >= 0) {
		printf("%s:  file %s is already indexed and associated with another format\n",progname,fil);
		quitsig();
	}
	if (!saccess(fil,2)) {
		printf("%s: Access to file %s forbidden\n",progname,fil);
		quitsig();
	}
	i = hrec.numfmt++;
	strcpy(fmtdef[i].fmt_name,fmt);
	j = addfile(fil, i);
	strcpy(fmtdef[i].fmt_app,fil);
	fmtdef[i].fmt_num = i;
	fmtdef[i].fil_num = filent[j].f_num;
	printf("%s: Format %s assigned number %d - associated with file %s\n",progname,fmt,i+1,fil);
}

/*******************************  nofile   **********************************/

nofile(fn)
char *fn;
{
	printf("cannot open file %s\n",fn);
	quitsig();
}

/****************************  quitsig  *************************************/
quitsig()
{
	signal(SIGHUP, &quitsig);
	signal(SIGINT, &quitsig);
	signal(SIGQUIT, &quitsig);
	if (phase == 1)  {
		printf("*** forbidden to kill newfile during index rewrite\n");
		return;
	}
	funlock(lockfile);
	exit(1);
}

/**************************************  rmfile  ****************************/
/* rmfile - remove a file from the index */

rmfile(dfile)
char *dfile;
{
	register int i, j, k;
	k=hrec.numfile;
	i = lookup(dfile);
	if (i < 0) return(1);
	for (j = i; j< (k-1); j++) {
		ncp(&filent[j], &filent[j+1], sizeof(struct fil_ent));
	}
	hrec.numfile--;
	if (vflag) printf("file %s removed from index\n",dfile);
	return(0);
}
