/*
	wtmp analyzer -- John Buck  December, 1981
*/

#define ALL 0


struct	who {
	char w_tty[8];
	char w_name[8];
	long w_time;
};

char *brook[] = {
	"ttyf", "ttyg", "ttyh", "ttyi", "ttyj", "ttyk", "ttyl", "ttym",
	"ttyn", "ttyo", "ttyp", "ttyq", "ttyr", "ttys", "ttyt", "ttyu",
	"ttyv", "ttyw", "ttyy", "ttyz", "ttyA", "ttyB", "ttyC", "ttyD",
	"ttyE", "ttyF", "ttyG", "ttyH", "ttyI", "ttyJ", 
	"ttyK", "ttyL", "ttyU", "ttyV", "ttyW", "console", 0
};
char *farm[] = {
	"tty0", "tty1", "tty2", "tty3", "tty4", "tty5", "tty6", "tty7", 0
};
char *west[] = {
	"ttyM", "ttyN", "ttyO", "ttyP", "ttyQ", "ttyR", "ttyS", "ttyT", 0
};
char *dial[] = {
	"ttya", "ttyb", "ttyc", "ttyd", "ttye", 0
};

char *esc = "\033=  ";
char buf[5120];
int vals[72];
char tty[64][8];
float calb[19], st[72], fact;
int fd, pct, len, ads;
short cnt;
short	bflg, fflg, wflg, dflg;

long	lastt;

main(c,v)
char **v;
{
	register char *s, *t;
	register int i;
	char **pp;

	if(c > 1 && **(v + 1) == '-'){
		v++;
		ads++;
		esc[1] = 'Y';
		c--;
	}

	if(c < 3){
		printf("Usage: analyz file bfwd\n");
		exit(1);
	}

	if((fd = open(*++v, 0)) == -1){
		printf("analyz: Can't open %s\n", *v);
		exit(2);
	}

	v++;
	while(**v){
		switch(*(*v)++){

	case 'b':
		bflg = 36;
		break;

	case 'f':
		fflg = 8;
		break;

	case 'w':
		wflg = 8;
		break;

	case 'd':
		dflg = 5;
		break;

	default:
		printf("analyz: '%c' is illegal\n", *((*v)-1));
		exit(2);
		}
	}
	len = wflg + bflg + dflg + fflg;
	pct = (c == 4);
	wholoop();
	setup();
	printit();
	set(23,1);
	exit(0);
}


wholoop()
{
	register struct who *pw;
	register r;
	int otime, catchup;
	int *t, *localtime();

	cnt = 0;
	otime = 0;

	while((r = read(fd, buf, 5120)) > 0)
		for(pw = buf; pw < &buf[r]; pw++){
			if(pw->w_time < lastt)
				pw->w_time = lastt;
			else lastt = pw->w_time;
			t = localtime(&pw->w_time);
			t[2] = t[2]*60 + t[1];
			if(t[2]/20 != otime){
				catchup = t[2]/20;
				while(otime != catchup){
					otime++;
					if(otime > 71)otime = 0;
					vals[otime] =+ cnt;
				}
			}
			if(pw->w_tty[0] == '|' || pw->w_tty[0] == '{')continue;
			if(pw->w_tty[0] == '~' || pw->w_tty[0] == 'x'){
				turnoff(ALL);
				continue;
			}
			if(!onlist(pw->w_tty))continue;
			if(pw->w_name[0]){
				cnt++;
				turnoff(pw->w_tty);
				addtty(pw->w_tty);
			} else {
				turnoff(pw->w_tty);
			}
		}
}


onlist(t)
register char *t;
{
	register short i;

	if(bflg)
		for(i = 0; i < bflg; i++)
			if(strncmp(t, brook[i], 8) == 0)
				return(1);
	if(fflg)
		for(i = 0; i < fflg; i++)
			if(strncmp(t, farm[i], 8) == 0)
				return(1);
	if(wflg)
		for(i = 0; i < wflg; i++)
			if(strncmp(t, west[i], 8) == 0)
				return(1);
	if(dflg)
		for(i = 0; i < dflg; i++)
			if(strncmp(t, dial[i], 8) == 0)
				return(1);
	return(0);
}

setup()
{
	register int i, j;

	write(1, ads ? "\014" : "\032", 1);
	set(19,8);
	for(i = 0; i < 72; i++)
		write(1,"-", 1);
	for(i = 1; i <= 23; i++){
		set(i,7);
		write(1, i == 19 ? "+" : "|", 1);
	}

	set(20,8);
	write(1,"000000000000000000000000000000111111111111111111111111111111222222222222", 72);
	set(21,8);
	write(1,"000111222333444555666777888999000111222333444555666777888999000111222333",72);
	set(22,8);
	write(1,"024024024024024024024024024024024024024024024024024024024024024024024024", 72);
	set(23,8);
	for(i = 0; i < 72; i++)
		write(1,"0", 1);
	if(pct){
		for(i = 0; i < 72; i++)
			vals[i] = vals[i]*100/len;
		len = 100;
	}

	fact = (float)(len)/19.0;
	calb[0] = 0.0;
	for(i = 1; i < 19; i++)
		calb[i] = calb[i-1] + fact;
	calb[18] = (float)(len);
	for(i = 0; i < 72; i++)
		st[i] = (float)(vals[i]);
	set(1,1);
	for(i = 18; i >= 0; i--)
		printf("%5.1f\n", calb[i]);
}

printit()
{
	register i,j,k;

	for(i = 0; i < 72; i++){
		for(j = 0; j < 19; j++)
			if(calb[j] > st[i])break;
		j = 19-j;
		for(k = 18; k > j; k--){
			set(k, i+8);
			write(1,"X",1);
		}
	}
}



set(x,y)
int x,y;
{
	esc[2] = 31 + x;
	esc[3] = 31 + y;
	write(1, esc, 4);
}


addtty(t)
register char *t;
{
	register short i;

	for(i = 0; i < 64; i++){
		if(strncmp(tty[i], t, 8) == 0)
			return;
		if(tty[i][0] == 0){
			strncpy(tty[i], t, 8);
			return;
		}
	}
	printf("No tty's left -- error\n");
	exit(1);
}

turnoff(t)
register char *t;
{
	register short i;

	for(i = 0; i < 64; i++){
		if(tty[i][0] == 0)continue;
		if(t == 0){
			cnt--;
			tty[i][0] = 0;
			continue;
		}
		if(strncmp(tty[i], t, 8) == 0){
			tty[i][0] = 0;
			cnt--;
			return;
		}
	}
	return(0);
}
